#declare Detail = 1; // 1 = Detail, 0 = Rough
#declare SlowOne = 1; // 1 = Good Radiosity, 0 = Rough Radiosity
#declare ColOn = 1; // 1 = Sky & Fog ON, 0 = OFF

global_settings {
radiosity {
#if (SlowOne)
  count 1000
  low_error_factor 0.7
  nearest_count 8
  distance_maximum 10
#else
  count 250
  nearest_count 5
#end
}
}

#declare City1 =
texture {
  pigment {
    colour rgb 0.9
  }
  finish {
    ambient 0.25
  }
}

#include "steps1.inc"
#include "steps2.inc"
#include "steps3.inc"
#include "steps4.inc"
#include "steps5.inc"
#include "platfrm1.inc"
#include "platfrm2.inc"
#include "platfrm3.inc"
#include "platfrm4.inc"
#include "platfrm5.inc"

camera {
//  location <150, 200, -300> // Overhead view
  location <50, 200, -400> // Final view
  look_at 50*y
}

disc {
  <0, 5000, -3000>, <0, -5, 3>, 1000
  pigment {
    colour rgb 1
  }
  finish {
    ambient 15
  }
}
    


plane {
  y, -20
  pigment {
    colour rgb 0.3
  }
#if (Detail)
  normal {
    wrinkles 0.5
    scale <20, 1, 5>
    rotate 30*y
  }
  finish {
    reflection 0.5
    ambient 0.0
    diffuse 0.0
  }
#end
}   

#if (ColOn)

sphere {
  0, 2
  pigment {
#if (Detail)
    granite
    colour_map {
      [0.2 0.8 colour rgb 0 colour rgb <0.5, 1, 0.6>]
    }
#else
    colour rgb 1
#end
  }
  finish {
    ambient 1
  }
    scale <70000, 6000, 50000>
  hollow
}
#if (Detail)
fog {
  distance 200
  colour rgb <0.3, 0.7, 0.4>
  fog_type 2
  fog_offset -20
  fog_alt 50
}

#end

#end

