#include "colors.inc"
#include "textures.inc"
#include "galley.pov"


global_settings{
max_trace_level 10}

camera {
	location <0, 10, 0>
	look_at <200,-10,0>

}


//light_source {<100,1000,2000> White}

// ***************************************** Rock

object {
union {
height_field { 
tga "isle3.tga" 
water_level 0.01
no_shadow
pigment {DarkWood} 
scale <1,0.7,1>
translate <-0.5,0,-0.5>
rotate <180,0,0> }


height_field { 
tga "isle3a.tga" 
water_level 0.005
no_shadow
pigment {DarkGreen} 
scale <1,0.08,1>
translate <-0.5,-0.01,-0.5>
rotate <0,180,0> }
 }
scale 100
//translate <160,-20,20>
translate <160,-15,-55>
}

// **************************************** SKY

sky_sphere {

pigment{ gradient y
color_map{
[0.0 rgb <0,0,0.3>]
[1.0 rgb <0,0,0.5>]}
scale <1,1,1>}}


sphere {0,1
hollow
no_shadow
pigment{
  leopard
  turbulence 0.65
  octaves 6
  omega 0.7
  lambda 2
  color_map {
 [0.0 0.25 color rgbt<0.05,0.05,0.05,0.05>  //Gray05
          color  rgbt<0.4,0.4,0.4,0.2>] //Gray40]
 [0.25 0.8 color rgbt<0.4,0.4,0.4,0.2>  //Gray40
          color rgbt <0,0,0,1>]
 [0.8 1.0 color rgbt <0,0,0,1> 
          color rgbt <0,0,0,1>]
 }
scale <0.4,1,1>
}
scale 500
}

// ***************************************** MOON

light_source { < 600, 100, 200 > color rgb <1, 1, 1> 
looks_like {

object {
sphere {<0.5,0.5,0>,0.5 
pigment { image_map {tga "moont.tga" once interpolate 2 }}
finish  {ambient 2.5}
translate <-0.5,-0.5,0>
scale 100
rotate <0,71.5,5> //77
  }
 }
}
}

// ***************************** FOG

fog {
fog_type 2
distance 50
fog_alt 10
fog_offset -80
up y
colour rgbt <0.7,0.7,0.7,0.5>
turbulence 0.05}

// ************************************************ captain

#include "captain.pov"

object{captain 
translate <0,0,13>
rotate <0,-70,0>
translate <45,7.7,10>
  }

// ********************************* Halo

#include "latern.pov"

light_source {<50,0,10.9> rgb <0.8,0.8,1>
                fade_distance 120.0
                fade_power    0.6
 }

// ********************************** starfield

#declare galaxy_seed = 5785785;
#declare star_scale = 0.8;
#declare star_distribution = 1.1;
#include "GALAXY.SF";

// ********************************** tree

#include "tree.pov";