// The path to other worlds, a book
// G. Shaw
// Jan 1999
// gail@rucus.ru.ac.za

#include "colors.inc"
#include "metals.inc"
#include "stones.inc"
#include "thesword.inc"
#include "wrldtextures.inc"
#include "reader.inc"

#declare LemonYellow= color rgb <1,1,0.7>

#declare PageTexture1=
 texture {
  pigment {
   gradient y
    color_map {
      [ 0.0 Black ]
      [ 0.25 LemonYellow]
      [ 1.0 LemonYellow]
    }
   triangle_wave
  }
  finish {
   ambient 0.2
   diffuse 0.5
  }
  scale 0.08
 }

 #declare PageTexture2=
 texture {
  pigment {
   wood
    color_map {
      [ 0.0 Black ]
      [ 0.25 LemonYellow]
      [ 1.0 LemonYellow]
    }
  }
  finish {
   ambient 0.2
   diffuse 0.5
  }
  scale 0.08
 }

#declare TableWood =
 texture {
  pigment {
    wood
    turbulence 0.04
    octaves 3
    scale <0.4, 0.4, 1>
    color_map {
      [0.0  color rgb <0.60, 0.30, 0.18>]
      [0.1  color rgb <0.60, 0.30, 0.18>]
      [0.9  color rgb <0.45, 0.18, 0.12>]
      [1.0  color rgb <0.30, 0.15, 0.09>]
    }
    warp {
     black_hole <-13.4,0,2>,5
     strength 1.5
     falloff 6
     inverse
    }
    warp {
     black_hole <-8,0,12>,2
     falloff 5
     inverse
    }
  }
  finish {
    ambient 0.12
    diffuse 0.43
  }
  normal {
   wood 1
   turbulence 0.04
   scale <0.4,0.4,1>
   octaves 3
  }
 }

camera {
 location <2,14,-1.55>
 look_at <2,2,4>
}


light_source {
 <-600,850,-15>
 White
 atmosphere off
 area_light <2,0,0>,<0,0,2>,2,2
 spotlight
 point_at <5,0,0>
 radius 25
 falloff 35
 tightness 10
}

light_source {
 <500,400,30>
 White*0.6
 atmosphere off
 area_light <2,0,0>,<0,0,2>,2,2
 spotlight
 point_at <0,0,0>
 radius 20
 falloff 25
 tightness 10
}
/*
light_source {
 <-50,200,0>
 White*0.3
 atmosphere off
}
*/
#declare OpenBook=
union {
 box {
  <0.5,0,0>,<6.5,1,9.2>
  texture {PageTexture1
           //scale 0.1
          }
  matrix < 1, 0, 0,
           -0.5, 1, 0,
           0, 0, 1,
           0, 0, 0 >
 }
 union {
  box {
   <0,0,0>,<6,-0.01,9.2>
   pigment {LemonYellow}
   finish {ambient 0.2
           diffuse 0.5
          }
  }
  box {
   <0.4,0,2.9>,<5.6,0.0001,7.8>
   texture {T_Gold_3C}
  }
  box {
   <0,0,0>,<1,1,-0.001>
   pigment { image_map { tga "chamber.tga" } }
   finish {ambient 0.4}
   scale <5,4.6,1>
   rotate x*90
   translate <0.5,0.001,3>
  }
  rotate z*20
  translate y*1
 }
 difference {
  cylinder {
   <-3.05,-0.35,0>,<-3.05,-0.35,9.2>,3.35
  }
  union {
   cylinder {
    <-3.05,-0.35,-0.1>,<-3.05,-0.35,9.3>,3
   }
   box {
    <-4.65,-4.4,-0.1>,<3.35,0.98,9.3>
    translate <-3,0,0>
   }
   box {
    <-2.05,-2,-0.1>,<-0.05,2,9.3>
    rotate z*-23
    translate <-5.65,1,0>
   }
   box {
    <-0.05,0,-0.1>,<1.95,1,9.3>
    rotate z*-25
    translate <-1.77,0.72,0>
   }
  }
  texture {PageTexture2 translate <-3.05,-0.35,0>}
 }
 cylinder {
  <0,0,0>,<0,1,0>,0.3
  pigment {Clear}
  pigment { image_map { gif "text1a.gif"
                        map_type 2
                        transmit 255,1
                      }
          }
  rotate y*-100
  rotate x*90
  scale <11.2,11.2,12.2>
  translate <-3.05,-0.35,-2.3>
 }

 box {
  <0,0,0>,<1,1,-0.01>
  pigment {image_map { gif "text2.gif"
                      transmit 255,1
                     }
          }
  scale <5.9,2.8,1>
  rotate x*90
  translate <0.2,0,0>
  rotate z*20
  translate y*1.01
 }
 box {
  <0,0,0>,<1,1,-0.01>
  pigment {image_map { gif "text3.gif"
                      transmit 255,1
                     }
          }
  scale <5.9,1,1>
  rotate x*90
  translate <0.2,0,7.85>
  rotate z*20
  translate y*1.01
 }
 box {
  <0,0,0>,<-6,0.001,9.2>
  pigment { rgb <0.7,0,0> }
  finish {
   ambient 0.2
   diffuse 0.4
   specular 0.5
   roughness 0.02
  }
  rotate z*12
  translate y*1
 }
 scale <1.5,1.2,1.2>
}

// Fast table, better one once texture ok.
/*box {
 <-15,-1,-4>,<20,0,20>
 texture {TableTexture  scale 1.3 rotate y*90}
}*/

#declare TablePlank =
 difference {
  box {
   <-15,-1,-1>,<20,0,1>
  }
  union {
   box {
    <-16,-0.2,-0.2>,<22.0.2,0.2>
    rotate x*45
    translate <0,0,-1>
   }
   box {
    <-16,-0.2,-0.2>,<22.0.2,0.2>
    rotate x*45
    translate <0,0,1>
   }
  }
 }

#declare PlankNo=0
#declare PlankSeed=seed(9834)
union {
 #while (PlankNo<10)
  object { TablePlank
           translate z*(-2+PlankNo*2)
           texture { TableTexture
                     scale 1.3
                     translate 15*rand(PlankSeed)
                     rotate y*90
                   }
         }
  #declare PlankNo=PlankNo+1
 #end
}

object {OpenBook translate <0.5,0,-0.4>}

// The sword poking fron the top of the book

light_source {
 <0,0,0>
 color rgb <1,1,0.2>
 atmosphere off
 fade_distance 4
 fade_power 3
 looks_like {TheSword
             scale 0.3
             rotate x*-95
             rotate y*50
            }
 translate <5,1.3,12.4>
}


// A plane to show up the metals

plane {
 y,28
 pigment {White*2}
 finish {ambient 0.2}
 no_shadow
 hollow
 rotate x*50
}

//The lightning coming from the sword

#declare LX = 4.5
#declare LY = -8.6
#declare LZ = 1.3
#declare BranchFrequence = 0.01
#declare LightningSeed = 6456
#declare LSegments =100
#declare LightningScale	= <1,1,1>
#declare LightningFlash	= false
#declare LightningWidth=0.08
#declare LightningRotation=x*-90
#declare LightningTexture=texture{pigment {rgb <2,2,2.5>}
                                  finish {ambient 1 diffuse 0}
                                 }
#include "lightning.inc"

//To allow the beam coming from the bottom of the book to be visible.

atmosphere {
  type 1
  samples 40
  distance 400
  scattering 0.95
  aa_level 8
  aa_threshold 0.1
  jitter 0.1
}


// What magic is this???

light_source {
    <2.2,1.2,4>
    Red*8
    cylinder
    point_at <11.2,1,-10>
    radius 30
    falloff 30.1
    tightness 75
  }
light_source {
   <4.1,1.2,4>
   Green*8
   cylinder
   point_at <13.1,1.2,-10>
   radius 30
   falloff 30.1
   tightness 75
}
light_source {
   <6,1.2,4>
   Blue*8
   cylinder
   point_at <15,1.2,-10>
   radius 30
   falloff 30.1
   tightness 75
}

object {Reader
        rotate x*-90
        pigment {image_map {png "skin2.png"} scale 0.2 }
        finish {
         ambient 0.15 diffuse 0.3
         specular 0.2 roughness 0.5
        }
        rotate x*90
        scale <-30,30,30>
        rotate y*-30
        translate <1,-12,-7>
       }

#declare Key=
 union {
  torus {
   0.6,0.15
   translate x*-4.1
  }
  torus {
   0.6,0.15
   translate x*-3.55
  }
  cylinder {
   <1.5,0,0>,<-3,0,0>,0.15
  }
  sphere {
   <1.5,0,0>,0.15
  }
  torus {
   0.15,0.05
   rotate z*90
   translate x*0.5
  }
  torus {
   0.15,0.05
   rotate z*90
   translate x*0.6
  }
  torus {
   0.15,0.05
   rotate z*90
   translate x*-2.8
  }
  box {
   <1.25,-0.07,0>,<1.4,0.07,0.7>
  }
  box {
   <1.25,-0.07,0>,<1.1,0.07,0.55>
  }
  box {
   <0.95,-0.07,0>,<1.1,0.07,0.35>
  }
  difference {
   box {
    <0.95,-0.07,0>,<0.8,0.07,0.75>
   }
   box {
    <1,0.03,0.5>,<0.7,0.1,0.6>
   }
  }
  box {
   <0.8,0,0>,<0.65,0,0.5>
  }
  box {
   <1.25,-0.07,0>,<1.4,0.07,-0.3>
  }
  box {
   <1.1,-0.07,0>,<1.25,0.07,-0.8>
  }
  box {
   <0.95,-0.07,0>,<0.8,0.07,-0.6>
  }
  box {
   <0.8,-0.07,0>,<0.95,0.07,-0.75>
  }
  box {
   <0.65,-0.07,0>,<0.8,0.07,-0.3>
  }
  texture {
   bozo
   turbulence 0.7
   texture_map {
     [0.0 pigment {Black} finish {ambient 0.1 diffuse 0.15 crand 0.3} normal {bumps 0.3 scale 0.1}]
     [0.14 pigment {Black} finish {ambient 0.1 diffuse 0.15 crand 0.3} normal {bumps 0.3 scale 0.1}]
     [0.15 T_Silver_3D]
     [0.17 pigment {Black} finish {ambient 0.1 diffuse 0.15 crand 0.3} normal {bumps 0.3 scale 0.1}]
     [0.2 pigment {Black} finish {ambient 0.1 diffuse 0.15 crand 0.3} normal {bumps 0.3 scale 0.1}]
     [0.4 T_Silver_3D]
     [1.0 T_Silver_3D]
   }
   scale 0.3
  }
 }

 object {Key
         translate x*1.5
         rotate y*5
         translate <-1.7,0.15,-1.4>}
