// The chamber of the sword. Inspired by 'The wheel of time' by Robert Jordan
// and the legend of King Arthur

// standard includes
#include "colors.inc"
#include "metals.inc"
#include "shapes.inc"
#include "shapesq.inc"

// specialised includes
#include "wrldtextures.inc"
#include "columns.inc"
#include "thesword.inc"
#declare LightLevel=2
#include "lamp.inc"

camera {
 up <0,1,0>
 location <8,3.2,-12>
 look_at <0,2.8,0>
}

light_source {
 <0,2.2,0>
 White*0.4
 area_light <2,0,0>,<0,0,0.2>,3,1
 shadowless
}

#declare FloorSection =
 height_field {
  tga "heightgen.tga"
  smooth
  pigment {
   image_map { gif "heightgen.gif" }
   rotate x*90
  }
  translate <-0.5,0,-0.5>
  scale <30,0.3,30>
 }

#declare TileAlong=0
#declare TileAcross=0
#while (TileAlong<7)
 #while (TileAcross<7)
  object {FloorSection
          translate <-90+30*TileAcross,0,-30+30*TileAlong>
         }
  #declare TileAcross=TileAcross+1
 #end
 #declare TileAcross=0
 #declare TileAlong=TileAlong+1
#end

// A catch for any cracks or holes in the flooring.
plane {
 y,0
 pigment { rgb <0.3,0.3,0.3>}
 hollow
}

// roof
box {
 <-167,68,-167>,<167,69,167>
 pigment {White}
}


// Walls

difference {
 cylinder {
  <0,-2,0>,<0,68,0>,170
 }
 union {
  cylinder {
   <0,-2,0>,<0,69,0>,165
  }
  cylinder {
   <0,-2,0>,<0,10,0>,0.4
   scale <2,1,1>
   translate x*165
   rotate y*-145
  }
  cylinder {
   <0,-2,0>,<0,10,0>,0.4
   scale <2,1,1>
   translate x*165
   rotate y*-143
  }
  difference {
   torus {
    2.85,0.4
   }
   box {
    <6,1,-6>,<0,-1,6>
   }
   rotate z*-90
   scale <2,1,1>
   translate <165,10,0>
   rotate y*-144
  }
 }
 texture {Alabaster}
}

//  'altar' where the sword lies

union {
 cylinder {
  <-3,0,0>,<3,0,0>,1.6
  texture{Alabaster}
 }
 torus {
  0.5,0.1
  rotate z*90
  translate <-1.92,1.9,0>
  texture {T_Silver_3D}
 }
 torus {
  0.5,0.1
  rotate z*90
  translate <1.92,1.9,0>
  texture {T_Silver_3D}
 }
 torus {
  0.5,0.1
  rotate z*90
  translate <-1.92,2.4,0>
  texture {T_Silver_3D}
 }
 torus{
  0.5,0.1
  rotate z*90
  translate <1.92,2.4,0>
  texture {T_Silver_3D}
 }
 rotate y*-5
}


object {TheColumns texture {Alabaster}}

 object { TheSword
          scale <0.38,0.38,0.38>
          rotate y*70
          rotate z*-90
          translate <-0.55,2.2,0>
          rotate y*-5
        }

/*
atmosphere {
    type 4
    samples 30
    distance 800
    scattering 0.08
    aa_level 8
    aa_threshold 0.1
    jitter 0.1
}

// Callendor's glow

union {
 light_source {
  <0,8.5,-0.015>
  Yellow
  fade_distance 1
  fade_power 3
 }
 light_source {
  <0,4.5,-0.015>
  rgb <1,1,0.4>
  fade_distance 1
  fade_power 3
 }
 light_source {
  <0,6.5,-0.015>
  rgb <1,1,0.4>
  fade_distance 1
  fade_power 3
 }
 light_source {
  <0.5.5,-0.015>
  White*0.8
  fade_distance 1
  fade_power 3
 }
 light_source {
  <0,7.5,-0.015>
  White*0.8
  fade_distance 1
  fade_power 3
 }
}
*/

#declare camera_location =<6,3.2,-10>
#declare camera_look_at = <0,2.8,0>
#declare effect_location = <0,2.2,0>
#declare effect_type="Spotlight"
#declare effect_colour= <1.5,1.5,0.2>
#declare effect_scale = <0.35,0.35,0.35>
#declare effect_rotate = <0,0,20>
#declare effect_intensity = 0.4
// The spotlight effect
 #declare glow_type = 1;
 #declare glow_rotate = <0,0,0>
 #declare glow_scale = <1, 1, 1> * .4;
 #declare rays_type = 2;
 #declare rays_scale = <1, 1, 1> * .5;
 #declare streak_type = 4;
#include "LensFlares\LnsEfcts.inc"

// A soft glow around Callendor. I tried to do this with lights and atmosphere,
// but it was slow and didn't look that great.
#declare effect_rotate=<0,0,0>
#declare effect_intensity=1
#declare glow_type=2
#declare glow_color=<0.8,0.8,1>
#declare glow_intensity=0.6
#declare glow_scale=<3,0.6,1>
#declare rays_type=0
#declare streak_type=0
#declare spots_type=0
#include "LensFlares/LnsEfcts.inc"

#declare LampNo=0
#while (LampNo<8)
 object {Lamp
         rotate y*30
         translate <25,17,0>
         rotate <0,25+LampNo*45,0>
         texture {T_Gold_3D}
        }
 #declare LampNo=LampNo+1
#end

#declare LampNo=0
#while (LampNo<8)
 object {Lamp
         rotate y*65
         translate <45,20,0>
         rotate <0,22.5+LampNo*45,0>
         texture {T_Gold_3D}
        }
 #declare LampNo=LampNo+1
#end

#declare LampNo=0
#while (LampNo<8)
 object {Lamp
         rotate y*65
         translate <65,20,0>
         rotate <0,10+LampNo*45,0>
         texture {T_Gold_3D}
        }
 #declare LampNo=LampNo+1
#end

object {Lamp
        texture {T_Gold_3D}
        translate y*25
       }
