// Gold lamp hanging from the ceiling

#include "colors.inc"
#include "metals.inc"

#ifndef (LightLevel)
 #declare LightLevel=1
#end

#declare ChainUnit=
 union {
  torus {
   0.2,0.05
   scale <1,1,0.5>
   rotate z*90
  }
  torus {
   0.2,0.05
   scale <0.5,1,1>
   rotate x*90
   translate y*0.3
  }
 }

#declare HalfSphere=
 difference {
  sphere {
   <0,0,0>,1
  }
  box {
   <-2,0,-2>,<2,2,2>
  }
 }

#declare Lampbase=
 union {
  object {HalfSphere scale 0.8}
  cylinder {
   <0,0,0>,<0,0.1,0>,1
  }
  torus {
   1,0.1
   //translate y*-0.05
  }
  difference {
   object {HalfSphere scale <-0.6,-1,-0.6>}
   box {
    <-0.1,0.7,-0.3>,<0.1,1.2,0.3>
   }
  }
 }


#declare ChainSegment=
 union {
  #declare SegmentNo=0
  #while (SegmentNo<8)
   object {ChainUnit translate y*0.6*SegmentNo}
   #declare SegmentNo=SegmentNo+1
  #end
 }

#declare Chain=
 union {
  object {
   ChainSegment
   rotate z*12.5
   translate <1.15,0.15,0>
  }
  object {
   ChainSegment
   rotate z*-12.5
   translate <-1.15,0.15,0>
  }
  object {
   ChainSegment
   rotate y*90
   rotate x*12.5
   translate <0,0.15,-1.15>
  }
  object {
   ChainSegment
   rotate y*90
   rotate x*-12.5
   translate <0,0.15,1.15>
  }
  torus {
   0.17,0.04
   translate y*4.65
  }
  difference {
   torus {
    0.17,0.04
   }
   box {
    <0,-0.1,-0.2>,<0.2,0.1,0.2>
   }
   rotate z*90
   rotate y*45
   translate y*4.66
  }
  difference {
   torus {
    0.17,0.04
   }
   box {
    <-0.2,-0.1,0>,<0.2,0.1,0.2>
   }
   rotate x*90
   rotate y*-45
   translate y*4.66
  }
  object {ChainSegment translate y*4.85}
  object {ChainSegment translate y*9.65}
  object {ChainSegment translate y*14.45}
 }

 #declare Flame=
  sphere {
   <0,0,0>,1
   texture {
    pigment { Clear }
    halo {
     linear
     max_value 1.0
     spherical_mapping
     emitting
     turbulence <0.1,1,0.1>
     color_map {
      [0.0 color rgbt <0,0,0,1>]
      [0.2 color rgbf <0.6,0.0,0,1>]
      [0.5 color rgbf <0.7,0.7,0.1,0.8>]
      [1.0 color rgbf <1.5,1.2,0.7,0>]
     }
     samples 20
     frequency 0.8
    }
   }
   //rotate x*90
   scale <0.2,0.8,0.2>
   hollow
  }

#declare Lamp=
 union {
  object {Lampbase}
  object {Chain}
  object {Flame translate y*1}
  light_source {
   <0,1.1,0>
   #if (LightLevel=1)
    rgb <1,0.8,0.5>
   #end
   #if (LightLevel=2)
    rgb <0.7,0.65,0.3>
   #end
   fade_distance 15
   fade_power 1
   atmosphere off
  }
 }
/*
camera {
 location <0,0,-10>
 look_at <0,0,0>
}

object {Lamp texture {T_Gold_3D} rotate y*30}

background {White}

*/
