// Buck25.POV    15/2/99                      Ian & Ethel MacKay

#include "colors.inc"

global_settings { max_trace_level 12 } 

background { color rgb < 0.2, 0, 0.2 > }

light_source { < 500, 600, -500 > color rgb < 0.8, 0.6, 0.4 > }    // SUN ?
light_source { < -1.5, 2.4, -4.5 > color White  }    // IN AIRLOCK
light_source { < -4.25, 4.5, -5.5 > color White  }    // INTERIOR  
camera {
        location < -1, 0.5, -30 >    
        look_at < -4, 6, 0 >            
        angle 50
       }

// ROCKET SHIP
#declare Hue =
         texture {
                  pigment {
                           granite
                           turbulence 0.8
                           color_map {
                                     [ 0.0 color rgb < 0.7, 0.4, 0.5 > ] 
                                     [ 0.3 color rgb < 0.8, 0.6, 0.6 > ]
                                     [ 0.6 color rgb < 0.6, 0.5, 0.6 > ]
                                     [ 1.0 color rgb < 0.6, 0.8, 0.5 > ]
                                     }
                               scale < 16, 5, 1 >
                            }
                   normal { dents  scale 0.25 }
                   finish { ambient 0.2 }
                 }
#declare Cry =
         texture {
                  pigment {
                           gradient x   
                           color_map {
                                  [ 0.0 color Clear ]
                                  [ 0.3 color Clear ] 
                                  [ 0.3 color rgbt < 0.8, 0.6, 0.6, 0.25 > ]
                                  [ 0.4 color rgbt < 0.6, 0.5, 0.4, 0.25 > ] 
                                  [ 0.4 color Clear ] 
                                  [ 1.0 color Clear ] 
                                     }
                               scale 3
                            }
                
                   finish { ambient 0.2 }
                 }


#declare Fin =
        difference {
                    union {
                         sphere { < 0, 0, 0 >,12 }
                         cylinder { < 0, 0, 0 >,< 12, 0, 0 >,12 }
                             scale < 1, 0.3, 0.1 >
                          }
                    cylinder { < 0, 0, -5 >,< 0, 0, 5 >,12
                              scale < 1, 0.3, 1 >
                              translate 12*x
                              }
                            scale < 1.5, 1, 1 >
                        clipped_by {
                                    box { < -20, 0, -5 >,< 20, 5, 5 > }
                                   }
                            translate < 5, 4, 0 >
                     texture {
                        pigment { 
                                  gradient x
                                  color_map {     
                                          [ 0.0 color Red ]   
                                          [ 1.0 color rgb < 0.65, 0.1, 0 > ]
                                            }
                                   scale 20     
                                 }
                        finish { ambient 0.2 }
                              }
                     texture { Cry }
                   }

#declare Tube =
          union {
             cylinder { < 0, 0, 0 >,< 6, 0, 0 >,1  open }
             torus { 1, 0.2
                     rotate 90*z
                     translate 3*x
                   }
             torus { 1, 0.22
                     rotate 90*z
                     translate 2.6*x
                   }
             torus { 1, 0.25
                     rotate 90*z
                     translate 2.2*x
                   }      
                         pigment { 
                                  gradient x 
                                  color_map {
                                           [ 0.0 color rgb < 0.4, 0, 0 > ]
                                           [ 1.0 color rgb < 1, 0.9, 0.4 > ]
                                             }
                                   scale 6
                                 }
                         finish { ambient 0.4 }
                      }
#declare Rimf =
              object { Tube scale < 1, 0.78, 0.78 > translate 2*y  }
                                  
               
#declare Sett =
              union {
                    object { Tube scale < 1, 1.2, 1.2 > }
                    object { Rimf }
                    object { Rimf rotate 45*x }
                    object { Rimf rotate 90*x } 
                    object { Rimf rotate 135*x } 
                    object { Rimf rotate 180*x } 
                    object { Rimf rotate -45*x } 
                    object { Rimf rotate -90*x } 
                    object { Rimf rotate -135*x } 
                    }
#declare Cabin = 
                sphere { < 0, 0, 0 >,5             // main
                          scale < 3, 1, 1 >
                          translate -5*x
                       clipped_by {  
                                  cylinder { < 0, 0, 0 >,< 0, 2, 0 >,5
                                               scale < 1, 1, 0.75 >
                                               translate < -15, 1, 0 > 
                                            }
                                 }
                       pigment { color rgbt < 1, 1, 1, 0.46 > }   
                       finish { phong 1 }
                     }
#declare Pop =
                sphere { < 0, 0, 0 >,0.4                     // displays?
                          scale < 0.1, 0.5, 0.5 >  
                          pigment { color Green }
                          finish { ambient 0.4 }
                        }

#declare Dek =
          union {
                sphere { < 0, 0, 0 >,2                     // seat back
                          scale < 0.1, 1, 0.5 >
                          rotate -25*z
                          translate < -3.5, 0.5, -1.5 >
                          pigment { color Red }
                          finish { ambient 0.3 }
                       }
                sphere { < 0, 0, 0 >,2                     // seat  back
                          scale < 0.1, 1, 0.5 >
                          rotate -25*z
                          translate < -3.5, 0.5, 1.5 >
                          pigment { color Red }
                          finish { ambient 0.3 }
                       }
                sphere { < 0, 0, 0 >,2                     // seat
                          scale < 0.1, 1, 0.5 >
                          rotate -25*z
                          translate < -3.65, 0.5, -1.5 >
                          pigment { color Black }
                          finish { ambient 0.3 }
                       }
                sphere { < 0, 0, 0 >,2                     // seat
                          scale < 0.1, 1, 0.5 >
                          rotate -25*z
                          translate < -3.65, 0.5, 1.5 >
                          pigment { color Black }
                          finish { ambient 0.3 }
                       }

                cone { < -6, 0, 0 >,1.25,< -4.5, 0, 0 >,1.8  open   // dash
                          pigment { color rgb < 0.5, 0.1, 0.2 > }
                          finish { ambient 0.3 }
                      }
                object { Pop  translate < 0, 2, 1.5 > }
                object { Pop  translate < 0, 2, -1.5 > }
                object { Pop  translate < 0, 2.5, 1.5 >  }
                object { Pop  translate < 0, 2.5, -1.5 > }
                object { Pop  translate < 0, 2, 2.5 >  }
                object { Pop  translate < 0, 2, -2.5 > }
                object { Pop  translate < 0, 2.5, 2.5 > }
                object { Pop  translate < 0, 2.5, -2.5 > }

              }

#declare Kut =
              cylinder { < 0, 0, 0 >,< 0, 0, -6 >,0.45
                        scale < 0.3, 1, 1 > 
                        pigment { color rgbt < 0.8, 0.6, 1.0, 0.8 > }
                        finish { ambient 0.5 }   
                       }
#declare  Kuzz =                           // cutouts for portholes
                union { 
                       
                       object { Kut rotate 12*y }
                       object { Kut rotate 20*y } 
                       object { Kut rotate 28*y } 
                       object { Kut rotate -12*y }
                       object { Kut rotate -20*y } 
                       object { Kut rotate -28*y } 
                       object { Kut rotate -36*y } 

                       }

#declare Ent =                   // Cutouts for cabin and hatch 
       union {
          union {
              sphere { < 0, 0, 0 >,4  
                       pigment { color rgbt < 0.8, 0.8, 0.6, 0.9 > }    
                     }
              cylinder { < 0, 0, -3 >,< 0, 0, -6 >,1.3 }
                         rotate -15*x
                         translate -5*x
                         pigment { color rgb < 0.8, 0.8, 0.6 > }
                         finish { ambient 0.3 }
                        }  
              cylinder { < 0, 0, 0 >,< 0, 2, 0 >,5        // cabin cutout
                          scale < 1, 1, 0.75 >
                          translate < -15, 1, 0 >
                          pigment { color rgb < 0.4, 0.75, 0.5 > }
                          finish { ambient 0.5 }
                        }    
                }

#declare Por =                                    // a porthole
         union {
              torus { 0.5, 0.05
                      rotate 90*x
                      scale < 0.3, 1, 0.5 >
                      translate -5*z
                        pigment { color rgb < 0.8, 0.2, 0.2 > }
                        finish { ambient 0.2 } 
                     }
               sphere { < 0, 0, 0 >,0.45
                        scale < 0.3, 1, 0.05 >
                        translate -5*z
                        pigment { color rgbt < 0.8, 0.6, 1.0, 0.8 > }
                        finish { ambient 0.1
                                 phong 1
                               }
                       }
               }
#declare  Pholes =
                union {   
                       object { Por rotate 12*y }
                       object { Por rotate 20*y } 
                       object { Por rotate 28*y }  
                       object { Por rotate -12*y }
                       object { Por rotate -20*y } 
                       object { Por rotate -28*y } 
                       object { Por rotate -36*y }  
                       }
#declare Mas =
             difference {
                sphere { < 0, 0, 0 >,5  }           // main
                object { Kuzz }
                          scale < 3, 1, 1 >
                          translate -5*x
                       }
#declare Alock =                               // airlock door
            union {
                cone { < 1.3, 0, 0 >,1.3,< 1.3, 0, 0.3 >,1.1 } 
                cylinder { < -0.6, 0, 0.35 >,< 0.6, 0, 0.35 >,0.03
                             rotate 45*z
                             translate 1.3*x
                         }
                cylinder { < -0.6, 0, 0.35 >,< 0.6, 0, 0.35 >,0.03
                             rotate -45*z
                             translate 1.3*x
                         }  
                 torus { 0.5, 0.03
                          rotate 90*x
                          translate < 1.3, 0, 0.35 >
                       }
                 torus { 0.4, 0.035
                          translate 0.5*y
                       }
                 torus { 0.4, 0.035
                          translate -0.5*y
                       }
                        rotate 160*y
                        translate < -6.3, 0, -5 >
                        pigment { color Gray85 }
                        finish { ambient 0.2 }
                  }



#declare Cent =                    
          union {
             difference {
                object { Mas }            // main
                object { Ent }
                         }
                difference {                                     // nose
                            sphere { < 0, 0, 0 >,1.25  scale < 2, 1, 1 >    
                                       translate -20*x }
                            torus { 1.5, 1.5
                                    scale < 1, 2, 1 >
                                    rotate 90*z
                                    translate -22.5*x
                                  }
                         }
                
                object { Alock rotate -15*x }
                object { Pholes scale < 3, 1, 1 > translate -5*x } 
                object { Sett translate 18*x }
                object { Cabin  }
                torus { 2, 0.08                 // cabin roof
                        scale < 2, 1, 1.3 >
                        translate < -13, 3, 0 >
                        pigment { color Red }
                        finish { ambient 0.2 }
                      }
                torus { 2.75, 0.08                 // cabin sill
                        scale < 2.2, 1, 1.3 >
                        translate < -13.6, 1, 0 >
                        pigment { color Red }
                        finish { ambient 0.2 }
                      }


                torus { 1.8, 0.08                 // cabin roof
                        scale < 2, 1, 1 >
                        translate < -13, 3, 0 >
                        pigment { color rgb < 0.4, 0.4, 1 > }
                        finish { ambient 0.3 }
                      }
                torus { 1.5, 0.08                 // cabin roof
                        scale < 2, 1, 1 >
                        translate < -13, 3, 0 >
                        pigment { color rgb < 1, 0.4, 0.4 > }
                        finish { ambient 0.3 }
                      }

                difference {
                     cylinder { < 0, 0, 0 >,< 0.3, 0, 0 >,4.1 // back of cabin
                           translate -13*x
                           pigment { color rgb < 0.4, 0.4, 1 > } 
                           finish { ambient 0.3 }
                         }
                      cylinder { < -1, 0, 0 >,< 1.3, 0, 0 >,3    // doorway
                          translate -13*x  
                          scale < 1, 1, 0.5 >     
                          pigment { color Gray50 }
                          finish { ambient 0.2 }
                       }
                          }
                object { Dek translate -13*x }
                sphere { < 0, 0, 0 >,3.25          // rear
                          scale < 2, 1, 1 >
                          translate 16*x
                       }
                torus { 3.25, 0.05
                          scale < 2, 1, 1 >
                          rotate 15*x 
                          translate 16*x
                      }
                torus { 3.25, 0.05
                          scale < 2, 1, 1 >
                          rotate -15*x 
                          translate 16*x
                      }
                torus { 3.25, 0.05
                          scale < 2, 1, 1 >
                          rotate 45*x
                          translate  16*x
                      }
                torus { 3.25, 0.05
                          scale < 2, 1, 1 >
                          rotate -45*x
                          translate  16*x
                      }  
                 cylinder { < 8, 0, 0 >,< 12, 0, 0 >,2.5           // joiner
                            pigment { color rgb < 0.8, 0, 0.2 > }
                            finish { ambient 0.2 }
                          }
                 texture { Hue }
                 texture { Cry } 
                }
#declare Ring =
               torus { 1.6, 0.075
                       rotate 90*z
                       texture { Hue }
                }

#declare Outer =
           union {
                   sphere { < 0, 0, 0 >,1.6    // front
                            scale < 2, 1, 1 >
                            translate -7*x
                          }
                   sphere { < 0, 0, 0 >,1.6       // back
                            scale < 2, 1, 1 >
                            translate 10*x
                          }
                   object { Ring translate -4*x }
                   object { Ring } 
                   object { Ring translate 4*x } 
                   object { Ring translate 8*x } 
                   object { Tube scale < 1, 0.75, 1 > translate 10*x }
                   cylinder { < -7, 0, 0 >,< 10, 0, 0 >,1.6 }
                     texture { Hue }
                     texture { Cry }
                  }
#declare Rocket =
            union {
                  object { Cent }
                  object { Outer translate < 0, -4, -3.5 > }
                  object { Outer translate < 0, -4, 3.5 > }  
                  object { Fin rotate 55*x translate 0.5*x }
                  object { Fin rotate -55*x translate 0.5*x }
                  object { Fin scale < 0.4, 1.6, 1 > translate < 17, -5, 0 > }
                  }
object { Rocket scale 0.6 rotate -40*y translate < -1, 2.8, 0 > }
          
#declare Land =                            // GROUND
             height_field {
                           tga "wrinc2.tga"  smooth
                           translate < -0.5, -0.5, -0.5 >
                           scale < 25, 2.5, 50 >
                           pigment { color rgb < 0.6, 0.5, 0.4 > }
                           normal { bumps 0.25 scale 0.03 }
                           finish { ambient 0.1 
                                     diffuse 0.8 }
                           }
object { Land translate -5*z }

#declare Cliff =
height_field {
              gif "fract039.gif"
              translate < -0.5, -0.5, -0.5 >  
              scale < 80, 30, 45 > //< 80, 30, 15 >
              rotate -25*x 
              pigment { color rgb < 1, 0.7, 0.4 > }
              normal { granite  scale 2 }
              finish { ambient 0.1 
                       diffuse 0.9 }
             }
object { Cliff translate < -10, 0, 20 > }
#declare Rocks =
height_field {
              gif "fract039.gif"
              translate < -0.5, -0.5, -0.5 >  
              scale < 25, 3, 5 >
              rotate < 10, 30, 0 > 
              pigment { color rgb < 0.6, 0.4, 0.2 > }
              normal { granite  scale 0.05 }
              finish { ambient 0.2  }
             }
object { Rocks translate < -5, -1.1, -24.4 > }

plane { y, 26           // CLOUDS
         pigment { 
                  wrinkles 
                  turbulence 0.5
                  color_map {   
                            [ 0.0 color rgbt < 0.2, 0, 0.2, 0.7 > ]
                            [ 0.2 color rgbt < 0.2, 0, 0.2, 0.7 > ] 
                            [ 0.5 color rgbt < 1, 0.55, 0.8, 0.3 > ]
                            [ 0.6 color rgbt < 1, 0.55, 0.8, 0.3 > ] 
                            [ 0.9 color rgbt < 0.2, 0, 0.2, 0.7 > ] 
                            [ 1.0 color rgbt < 0.2, 0, 0.2, 0.7 > ]
                             }
                       scale < 20, 1, 5 >
                  }
         finish { ambient 0.3
                  diffuse 0.1 }
                  
     }
#declare Sat =
          union {
               sphere { < 0, 0, 0 >,10 
                     pigment { color rgb < 0.7, 0.5, 0.7 > }
                     finish { ambient 0.3 
                              diffuse 0.5 }
                      }
               disc { < 0, 0, 0 >,< 1, 0, 0 >, 25, 15    
                     pigment { color rgbt < 1, 0.5, 1, 0.75 > }
                     finish { ambient 0.2 
                              diffuse 0.8 }
                    }
                }
object { Sat scale 0.75 rotate < 0, 20, 60 >  translate < -25, 35, 55 > } 
#declare Moon =
          sphere { < 0, 0, 0 >,1
                     pigment { color rgb < 0.7, 0.5, 0.7 > }
                     finish { ambient 0.3 
                              diffuse 0.5 }
                      }
object { Moon translate < -55, 40, 60 > }
object { Moon scale 0.6 translate < -15, 42, 70 > }  
object { Moon translate < 25, 45, 60 > }  
object { Moon scale 1.3 translate < -27, 25.3, 50 > }  

// FLYING MAN
#declare Puff =                          // flying-belt smoke
           union {
                 sphere { < 0, 0, 0 >,1 scale < 1, 1, 3 > }
                 torus { 1.6, 0.2 rotate 90*x }  
                         pigment { color rgbt < 0.85, 0.85, 0.85, 0.9 > }
                         finish { ambient 0.5 }
                 }
                 

#declare Sphere_Radius = 0.5
#declare Number_of_Cycles = 0.5
#declare Count_per_Cycle = 100
#declare Coefficient = 0.02
#declare Starting_Angle = 10
#declare Angle = 360 / Count_per_Cycle
#declare Count = Number_of_Cycles * Count_per_Cycle -1

#declare Smoke =
         union {
         #while ( Count >= 0 )
              object { Puff  scale  Starting_Angle * Coefficient  
                translate < 0, -50, 0 >
                       rotate < Starting_Angle, 0, 0 >
                       }
         #declare Starting_Angle =  Starting_Angle + Angle
         #declare Count = Count - 1

         #end      
               }


// FLYING MAN 
#declare Mod =
             union {
                    box { < -2, 0, -1.1 >,< -0.1, -2, -2 >
                           rotate < -5, 0, -8 >
                       }
                    box { < 0.1, 0, -1.1 >,< 2, -2, -2 >
                           rotate < -5, 0, 8 >
                       }
                    sphere { < 0, 0, 0 >,0.5 scale < 1.2, 0.5, 0.5 >
                            translate < 0.7, -0.1, -1.1 >
                            pigment { color Gray45 }
                            }
                    sphere { < 0, 0, 0 >,0.5 scale < 1.2, 0.5, 0.5 >
                            translate < -0.7, -0.1, -1.1 >
                            pigment { color Gray45 }
                            }

                    box { < -2, 0, 0 >,< 2, -2, -2 > 
                            rotate -40*x 
                            translate < 0, -0.85, -1 > 
                        }
                          rotate -15*x
                          translate < 0, -0.2, 0.1 >
                          pigment { color rgb < 1, 0.95, 0.85 > }
                          finish { ambient 0.2 }
                   }
#declare Noz =
              union {
                     sphere { < 0, 0, 0 >,1.2
                               scale < 1, 2, 1 >
                               pigment { color Gray60 }
                               normal { bumps scale 0.1 }
                               finish { ambient 0.2 
                                        phong 1 }
                            }
                      cone { < 0, 0, 0 >,0.5,< 0, -9, 0 >,0.0   
                            pigment { color Orange }
                            finish { ambient 0.65 }
                            }
                       sphere { < 0, 0, 0 >,0.75
                                scale < 1, 10, 1 >
                                translate -8*y
                                pigment { color rgbt < 1, 0.9, 0.2, 0.9 > }
                                finish { ambient 1 }
                              }
                       rotate 18*x
                    }

#declare Flyer =
             union {
                   object { Noz rotate 5*z translate < 6, 32, 0 > }
                   object { Noz rotate -5*z translate < -6, 32, 0 > } 
                   sphere { < 0, 30, 0 >,1.5 }
                   sphere { < 0, 20, 0 >,1.5 }
                   sphere { < 0, 25, 0 >,6
                             scale < 0.4, 1, 0.4 >
                          }
                   cone { < 0, 25, 0 >,2,< -6, 32, 0 >,1 
                             scale < 1, 1, 0.5 >
                             }
                   cone { < 0, 25, 0 >,2,< 6, 32, 0 >,1 
                             scale < 1, 1, 0.5 >
                             }  
                     translate < 0, 3.5, 3 >
                        pigment { color Gray60 }
                        normal { bumps scale 0.1 }
                        finish { ambient 0.2 
                                 phong 1 }
                   }
                   
#declare Bman =
         union {
                union {
                       cone { < 0, 2, 0 >,0.2,< 0, 3.5, 0 >,0.0 }
                       disc { < 0, 2, 0 >,< 0, 1, 0 >,1
                               pigment { color rgbt < 0.8, 0.5, 1, 0.75 > }
                            }
                       disc { < 0, 2.5, 0 >,< 0, 1, 0 >,1
                               pigment { color rgbt < 0.8, 0.5, 1, 0.75 > }
                            }
                       disc { < 0, 3, 0 >,< 0, 1, 0 >,1
                               pigment { color rgbt < 0.8, 0.5, 1, 0.75 > }
                            }   
                       torus { 2, 0.25   scale < 1, 2, 1 >
                               translate 0.25*y
                               pigment { color rgbt < 0.6, 0.6, 1.0, 0.5 > }
                               finish { ambient 0.2
                                        phong 1 }
                              }
                sphere { < 0, 0, 0 >,2  }      // hat
                          scale < 1.25, 1.8, 1.5 >
                          clipped_by {
                                   box { < -4, 0.1, -4 >,< 4, 6, 4 > }
                                     }
                          rotate 10*z
                          translate < 0, 35, -2 > 
                           pigment { color rgb < 0.6, 0.4, 0.4 > }
                           finish { ambient 0.2 
                                    phong 1 }
                        }
                      
                difference {
                      union {
                sphere { < 0, 0, 0 >,0.7 scale < 0.3, 1, 1 >
                          translate 1.7*x
                           pigment { color rgb < 0.6, 0.4, 0.4 > }
                           finish { ambient 0.2 }
                        } 
                sphere { < 0, 0, 0 >,0.7 scale < 0.3, 1, 1 >
                          translate -1.7*x
                           pigment { color rgb < 0.6, 0.4, 0.4 > }
                           finish { ambient 0.2  }
                        } 

                sphere { < 0, 0, 0 >,1.7   }     // head
                sphere { < 0, 0, 0 >,1.7        // chin   
                         scale < 0.65, 1, 1 >
                         rotate 30*x
                         translate 0.3*y
                       }
                            }
                object { Mod }
                           
                          scale < 1, 1.8, 1.5 >
                          rotate < 15, 0, 10 >
                          translate < 0, 35, -2 >
                          pigment { color rgb < 1, 0.95, 0.85 > }
                          finish { ambient 0.2 }
                       }
                cone { < 0, 35, -1 >,1,< 0, 28, 0 >,2    // neck
                        scale < 1, 1, 0.75 > 
                     }
                sphere { < 0, 0, 0 >,1.5        // shoulder
                          scale < 1.1, 2.5, 1 >
                          rotate 48*z
                          translate < 3, 31, 0 >
                       }
                sphere { < 0, 0, 0 >,1.5        // shoulder
                          scale < 1.1, 2.5, 1 >
                          rotate -48*z
                          translate < -3, 31, 0 >
                       }
                sphere { < 0, 0, 0 >,5        // chest
                          scale < 1, 0.5, 0.2 >  
                          translate < 0, 30, -1.5 >
                       }
                sphere { < 0, 0, 0 >,5        
                          scale < 1, 0.5, 0.2 >  
                          translate < 0, 30, 0.7 >   // back
                       }

                object { Flyer }
                 cone { < 4.6, 30, 0 >,1.2,< 7.3, 27, -2 >,0.8 }    // uarm
                 cone { < -4.6, 30, 0 >,1.2,< -7.3, 27, -2 >,0.8 }   // uarm
                 cone { < 7.3, 27, -2 >,0.8,< 8, 30, -6 >,0.7 }    // larm
                 cone { < -7.3, 27, -2 >,0.8,< -8, 23, -6 >,0.7 }   // larm
                 cone { < -8, 23, -6 >,0.7,< -7.65, 25, -4 >,1.2  open
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }               // gauntlets
                      }
                 cone { < 8, 30, -6 >,0.7,< 7.65, 28.5, -4 >,1.2  open
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }

                 sphere { < 7.3, 27, -2 >,0.7 }            // elbows
                 sphere { < -7.3, 27, -2 >,0.7 }  
                 superellipsoid { < 0.4, 0.4 >
                         scale < 1, 1, 0.6 >  // r hand
                          rotate < 45, 30, 0 >
                          translate < -8.2, 23, -6 >   
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }
                 superellipsoid { < 0.4, 0.4 >
                         scale < 1, 1, 0.6 >  // l hand
                          rotate < -45, 10, -60 >
                          translate < 8, 29.5, -6 >   
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }

                 cone { < 0, 23, 0 >,3.1,< 0, 30, 0 >,3  // upper torso
                          scale < 1.1, 1, 0.5 >
                      }
                 cylinder { < 0, 30, 0 >,< 0, 33.5, 0 >,3.1       // eps
                          scale < 1.1, 1, 0.5 >  
                      }
                 cylinder { < 0, 23, 0 >,< 0, 24.5, 0 >,3.11       // belt
                          scale < 1.1, 1, 0.5 >
                          pigment { color Black }
                      }


                 cone { < 0, 17.5, 0 >,5,< 0, 23, 0 >,3.1  // lower torso
                          scale < 1.1, 1, 0.5 >
                      }

                 cone { < 1.7, 19, 0 >,2.2,< 2.6, 11, -5 >,1.3     // thigh
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }
                 sphere { < 0, 0, 0 >,2  scale < 1.1, 2.5, 0.8 >      //l jhod
                          rotate < 32, 0, 8 >
                          translate < 2.5, 17, -1.2 >
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }
                 sphere { < 0, 0, 0 >,2  scale < 1.1, 2.5, 0.8 >      //r jhod
                          rotate < 0, 0, -8 >
                          translate < -2.8, 17, 0 >
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }

                 sphere { < 2.6, 11, -5 >,1.3                      // knee
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }

                 cone { < -1.7, 19, 0 >,2.2,< -2.6, 9, 0 >,1.3    // thigh
                          pigment { color rgb < 0.8, 0.6, 0.4 > }
                          finish { ambient 0.2 }
                      }
                 sphere { < -2.6, 9, 0 >,1.3 
                          pigment { color rgb < 0.8, 0.6, 0.4 > }   // knee
                          finish { ambient 0.2 }
                      }

                 cone { < -2.6, 9.5, 0 >,1.3,< -3.2, 4, 4.5 >,1     // calf r
                          pigment { color Black }
                          finish { ambient 0.2 }
                      }
                 cone { < 2.6, 11, -5 >,1.3,< 3.2, 3, 0 >,1    // calf
                          pigment { color Black }
                          finish { ambient 0.2 }
                      }
                 cone { < -3.2, 4.5, 4.5 >,1,< -6.5, 1.5, 4 >,0.54  // foot r
                       pigment { color Black }
                       finish { ambient 0.2 }
                      }
                 cone { < 3.2, 2.8, 1 >,1,< 5, 2.4, -5 >,0.54    // foot
                       pigment { color Black }
                       finish { ambient 0.2 }
                      }  
                       pigment { color rgb < 0.5, 0.2, 0.3 > }
                       normal { bumps }
                       finish { ambient 0.2 }
                       scale 0.2
          }
#declare Buck =
        union {
               object { Bman  rotate < -25, 150, 0 > translate -2.5*x }                      
               object { Smoke scale 0.25  
                        rotate < -100, -30, 0 > 
                        translate < 1.5, 5.25, -9.75 > }
               object { Smoke scale 0.25  
                        rotate < -100, -30, 0 > 
                        translate < 3.7, 5.25, -8 > }
               }

object { Buck scale 0.25 rotate -95*y translate < 1.75, 6, -14 > } 

                     

