/*
 *   An include file extract for stuff used in the Gateway scene...
 *   textures first, then some objects (arch, ringed moons etc...)
 *
 *   The textures here are pretty much simple derivatives of the standard
 *   "textures.inc" textures.
 */


#ifdef(CBGateway)
// do nothing
#else
#declare CBGateway = version;


#ifdef(View_POV_Include_Stack)
#   debug "including CBGatewat.inc\n"
#end
   
#include "colors.inc"   
#include "glass.inc"


// Textures


#declare CBWater = texture {
    pigment { 
        color rgbf <0,0.2,0.7,0.4>
    }
    normal {
        ripples 0.1
      frequency 2 
        scale <5.0, 5.0, 10.0>
    }
    finish {
        crand 0.05
        reflection 0.9
        brilliance 3.0
    }
}

#declare CBRoughWater = texture {
    pigment { 
        color rgbf <0,0.2,0.7,0.4>
    }
    normal {
        waves 0.2
      frequency 2 
        scale <5.0, 5.0, 10.0>
    }
    finish {
        crand 0.05
        reflection 0.9
        brilliance 3.0
    }
}


// (aka "seeweed"!)
#declare CBClearJade1 = 
 pigment 
  {marble
   turbulence 1.8
   color_map 
    {[0.0 0.9   color Clear
                color Clear]
    [0.9, 0.95   color red 0.1 green 0.6 blue 0.1
                 color red 0.0 green 0.3]
     [0.95, 1.001 color red 0.1 green 0.6 blue 0.1
                 color red 0.0 green 0.2]
   }
 }
     
#declare CBClearJade2 = 
 pigment 
  {marble
   turbulence 1.8
   color_map 
    {[0.0 0.7   color Clear
                color Clear]
    [0.7, 0.9   color red 0.1 green 0.6 blue 0.1
                 color red 0.0 green 0.3]
     [0.9, 1.001 color red 0.1 green 0.6 blue 0.1
                 color red 0.0 green 0.2]
   }
 }

#declare CBClearJade3 = 
 pigment 
  {marble
   turbulence 1.8
   color_map 
    {[0.0 0.5   color Clear
                color Clear]
    [0.5, 0.8   color red 0.3 green 0.8 blue 0.3
                 color red 0.2 green 0.5]
     [0.8, 1.001 color red 0.3 green 0.8 blue 0.3
                 color red 0.2 green 0.4]
   }
 }
     
// ye old and faithful...

#declare CBMarble = 
 texture
 {
     pigment 
     {
         marble
         turbulence 1
         color_map 
         {[0.0, 0.8   color red 1.0 green 1.0 blue 1.0
                      color red 0.8 green 0.8 blue 0.8]
          [0.8, 1.001 color red 0.8 green 0.8 blue 0.8
                      color red 0.02 green 0.02 blue 0.02]
        }
    }
    finish { ambient 0.3 diffuse 0.8 reflection 0.2 }
 }

#declare CBSky =
  texture {
      pigment {
              bozo
              turbulence 0.56
              color_map
              {
               [0.0, 0.5  color red 0.55 green 0.55 blue 1.0
                          color red 0.55 green 0.55 blue 1.0]
               [0.5, 0.6  color red 0.55 green 0.55 blue 1.0
                          color red 1.0 green 1.0 blue 1.0]
               [0.6, 1.01 color red 1.0 green 1.0 blue 1.0
                          color red 0.5 green 0.5 blue 0.5]
              }

         scale <7500.0, 1000.0, 5000.0>
         //quick_color red 0.3 green 0.8 blue 1.0
      }   
      finish {
         crand 0.05
         ambient .9
         diffuse 0.1
      }
   }

// A sort of cratered - looking texture.

#declare CBMoon = texture {
  pigment {
    spotted
    turbulence 0.40
    color_map {
      [0.00 color rgb<0.20, 0.20, 0.20>]
      [0.30 color rgb<0.80, 0.80, 0.80>]
      [1.00 color rgb<1.00, 1.00, 1.00>]
    }
    scale 0.1 
  }
  normal {
    bumps 0.1
    scale .1 
  }
  finish {
    ambient 0.025
    diffuse 1.0
    brilliance 0.1
    crand 0.050
  }
}

// concentric rings with transparent gaps...

#declare CBMoon_Rings = 
texture
{
    pigment 
    {
        wood
        color_map {
            [ 0.00 color rgbf < 1.0, 1.0, 1.0 1.0> ]
            [ 0.10 color rgbf < 1.0, 1.0, 1.0 1.0> ]
            [ 0.10 color rgbf < 0.5, 0.5, 0.5 0.0> ]
            [ 0.20 color rgbf < 0.5, 0.5, 0.5 0.0> ]
            [ 0.20 color rgbf < 1.0, 1.0, 1.0 1.0> ]
            [ 0.50 color rgbf < 1.0, 1.0, 1.0 1.0> ]
            [ 0.50 color rgbf < 0.7, 0.7, 0.7 0.0> ]
            [ 1.00 color rgbf < 1.0, 1.0, 1.0 0.0> ]
        }
   }
   finish 
   {
        ambient 0.05 
        brilliance 0.1
        diffuse 1.0 
    }
}


#declare CBGasGiantSky =
  texture {
      pigment {
          bozo
          turbulence 0.56
          color_map
          {[0.0, 0.6  color rgbf <0.9,0.9,0.9,0.9>
                      color rgbf <0.9,0.9,0.9,0.9>]
           [0.6, 0.8  color rgbf <0.9,0.9,0.9,0.9>
                      color rgbf <0.7,0.4,0.7,0.8>]
           [0.8, 0.9  color rgbf <0.7,0.4,0.7,0.8>
                      color rgbf <0.6,0.3,0.6,0.5>]
           [0.8, 1.01 color rgbf <0.6,0.3,0.6,0.5>
                      color rgbf <0.5,0.2,0.5,0.0>]
      }

         scale <750.0, 100.0, 500.0>
      }
      finish {
         crand 0.05
         ambient 1.0 
         diffuse 0.1
         brilliance 0.1
      }
   }



// Objects


#declare moon =
    sphere
    {
        <0,0,0>,1
        texture { CBMoon }
    }


// Mmmm... this was done before I discovered povray's 'while' loops; hence is 
// rather verbose...

// Greek Doric Column segments

#declare doric_section =
difference
{
    union
    {
        cylinder { <0,0,0.01>, <0,0,0.99>, 1 }  // outer skin
        cylinder { <0,0,0>, <0,0,1>, 0.9 }        // inner core
    }
    // indentations...
    cylinder { <1,0,0>, <1,0,1>, 0.1 }
    cylinder { <-1,0,0>, <-1,0,1>, 0.1 }
    cylinder { <0,1,0>, <0,1,1>, 0.1 }
    cylinder { <0,-1,0>, <0,-1,1>, 0.1 }
    cylinder { <0.886,0.5,0>, <0.886,0.5,1>, 0.1 }
    cylinder { <-0.886,0.5,0>, <-0.886,0.5,1>, 0.1 }
    cylinder { <0.886,-0.5,0>, <0.886,-0.5,1>, 0.1 }
    cylinder { <-0.886,-0.5,0>, <-0.886,-0.5,1>, 0.1 }
    cylinder { <0.5,0.886,0>, <0.5,0.886,1>, 0.1 }
    cylinder { <-0.5,0.886,0>, <-0.5,0.886,1>, 0.1 }
    cylinder { <0.5,-0.886,0>, <0.5,-0.886,1>, 0.1 }
    cylinder { <-0.5,-0.886,0>, <-0.5,-0.886,1>, 0.1 }
    cylinder { <0.707,0.707,0>, <0.707,0.707,1>, 0.1 }
    cylinder { <-0.707,0.707,0>, <-0.707,0.707,1>, 0.1 }
    cylinder { <0.707,-0.707,0>, <0.707,-0.707,1>, 0.1 }
    cylinder { <-0.707,-0.707,0>, <-0.707,0.707,1>, 0.1 }
    cylinder { <0.259, 0.966, 0>, <0.259, 0.966, 1>, 0.1 }
    cylinder { <-0.259, 0.966, 0>, <-0.259, 0.966, 1>, 0.1 }
    cylinder { <0.259, -0.966, 0>, <0.259, -0.966, 1>, 0.1 }
    cylinder { <-0.259, -0.966, 0>, <-0.259, -0.966, 1>, 0.1 }
    cylinder { <0.966, 0.256, 0>, <0.969, 0.256, 1>, 0.1 }
    cylinder { <-0.966, 0.256, 0>, <-0.969, 0.256, 1>, 0.1 }
    cylinder { <0.966, -0.256, 0>, <0.969, -0.256, 1>, 0.1 }
    cylinder { <-0.966, -0.256, 0>, <-0.969, -0.256, 1>, 0.1 }
    object
    {
        box {<0,0,0>,<0.1,0.1,0.1>}
        rotate <0,45,0>
        translate <1,0,0.4>
    }
    object
    {
        box {<0,0,0>,<0.1,0.1,0.1>}
        rotate <45,0,0>
        translate <0,1,0.8>
    }
    object
    {
        box {<0,0,0>,<0.1,0.1,0.1>}
        rotate <0,45,0>
        translate <1.02,0,0.6>
    }
    bounded_by { cylinder {<0,0,-0.001>,<0,0,1.001>,1.001} }
}

#declare sun_dial =
union
{
        sphere    { <0,0,0> 0.1 }                      // internal nob
        cylinder  { <-1,0,0>, <1,0,0>, 0.05 }          // pointer rod
        cone      { <1,0,0>,0.1, <1.2,0,0>, 0 }        // rod pointer 
        lathe                                          // fancy rod tail 
        {
            cubic_spline
            8,
            <0.05,0>, <0.05,0.1>, <0.1,0.2>, <0.08,0.24>, <0.1,0.28>, <0.08,0.3>, <0.08, 0.3>, <0,0.3>
            rotate <0,0,90>
            translate <-0.8,0,0>
        }            
        difference                                      //  the half-circle holders...
        {
                sphere { <0,0,0> 1.0 }
                sphere { <0,0,0> 0.99 }
                plane  { <0,-1,0> 0 }
                box    { <1,-1,1> <0.1,-0.01,0.05> }
                box    { <-1,-1,1> <-0.1,-0.01,0.05> }
                box    { <1,-1,-1> <0.1,-0.01,-0.05> }
                box    { <-1,-1,-1> <-0.1,-0.01,-0.05> }
                #declare Count=1;
                #while (Count < 11)
                object{sphere {<0,0,1.0> 0.02} rotate x*15*Count}  // make holes for the indented bumps...
                #declare Count=Count+1;
                #end
        }                                    
        #declare Count=1;
        #while (Count < 11)
        difference
        {
                object {sphere {<0,0,1.0> 0.03} rotate x*15*Count}
                object {sphere {<0,0,1.0> 0.02} rotate x*15*Count}
                object {plane {<0,0,-1>,-1} rotate x*15*Count}
        }
        #declare Count=Count+1;
        #end
        
        //bounded_by { sphere {<0,0,0>, 1.5 } }
  } 

#declare sun_dial_base =
lathe
    {
        cubic_spline
        7
        <0,-0.3>, <0.3,-0.3>, <0.3,-0.3>, <0.25,-0.2>, <0.15,-0.15>, <0.1,0>, <0.1,0>
        translate <0,-1,0>
    }                                                  
    
#declare arch =
difference
{

    union
    {
        torus 
        {
            1 .1  
            rotate <90,0,0>
            translate <0,0,0>
        }         

        sphere
        {
           <1,0,0>,0.2
           scale <1,.5,1> 
        } 

        sphere
        {
           <-1,0,0>,0.2
           scale <1,.5,1> 
        }             
    }
    plane {<0,1,0>, -0.001}    
}
  
  
#declare arch_thicker =
difference
{

    union
    {
        torus 
        {
            1 .101  
            rotate <90,0,0>
            translate <0,0,0>
        }         

        sphere
        {
           <1,0,0>,0.202
           scale <1,.5,1> 
        } 

        sphere
        {
           <-1,0,0>,0.202
           scale <1,.5,1> 
        }             
    }
    plane {<0,1,0>, -0.001}    
}

#declare arch_thickest =
difference
{

    union
    {
        torus 
        {
            1 .105  
            rotate <90,0,0>
            translate <0,0,0>
        }         

        sphere
        {
           <1,0,0>,0.21
           scale <1,.5,1> 
        } 

        sphere
        {
           <-1,0,0>,0.21
           scale <1,.5,1> 
        }             
    }
    plane {<0,1,0>, -0.001}    
}


#declare ringed_moon =
union
{

    disc
    {
        <0,0,0>,<0,0,1>,2.8,1.8
        texture { CBMoon_Rings scale 0.7 }
        rotate <90,0,0>
        rotate <0,0,-20>
        no_shadow
    }


    sphere
    {
        <0,0,0>,1
        texture { CBMoon }
    }
}




#version CBGateway;
#end
