// Planets - an alien sea-scape with a number of ringed and un-ringed planets.
// - panoramic scenes, intended to be twice its height in width 

#include "colors.inc"           // Standard colors library
//#include "shapes.inc"           // Commonly used object shapes
#include "textures.inc"         // standard textures includes
//#include "cb_textures.inc"      // Home-rolled evil
//#include "cb_objects.inc"       // More Home-rolled evil
#include "cb_gateway.inc"        // Home-rolled textures and objects for this scene        
//#include "skies.inc"            // Standard skies...
//#include "stars.inc"            // stars
#include "metals.inc"           // for the gold...

//#max_trace_level 20 

camera {
    location <0,2, 21>  
    look_at  <0,2, 0>
}

// light source for planets
light_source {<50000, 10000, -1100> color rgb <1.0, 1.0, 1.0> }    

// light source for inner sphere (foreground)                           
light_source { <100, 1800, 1400> color rgb <0.8, 1.0, 1.0> } 


// Outer Stars Sphere
sphere 
{ 
    <0, 0, 0>, 110000 
    hollow on
    texture { Starfield scale 100000 }
}


// Inner Sky Plate (with view hole) 

difference
{       
    box { <-5000,-5000,-1000>, <5000,5000,-1001> }
    cylinder { <0,0,-900>,<0,0,-1100>,400 } 

    scale <0.95,1.2,1>
    texture { CBSky scale <.1,.05,.05> } 
}
   
// shadowing cone to make sea dark... Mmm... smoke and mirrors...

difference
{
    cone {<0, 0, -0.1>, 8, <0, 0, -999>, 400 }
    cone {<0, 0, 0>, 7.99, <0, 0, -1000>, 399 }
    
    scale <0.95, 1.2, 1>
    texture { Starfield scale 100 } 
    translate <0,1,0>
}   



// Gateway 

object
{
    arch
    scale <8,12,8>  
//    texture { CBBlack_Marble } 
    texture { Red_Marble }
    translate <0,-1,0>
}    

// Gateway seaweedy stuff
                  
                  
// outer layer                  
difference
{
        object
        {
            arch_thickest
            scale <8,12,8>  
            texture { CBClearJade2 } 
            translate <0,-1,0>
        }    
        sphere {<0,8,0>, 8}
        
}    

// inner layer
difference
{
        object
        {
            arch_thicker
            scale 2
            texture { CBClearJade3 } 
            scale <4,6,4>  
            translate <0,-1,0>
        }    
        sphere { <0,8,0>, 8}  
        
}    



// Closest Ringed Moon

object
{
    ringed_moon
    rotate <0,40,0>
    rotate <50,0,0>
    scale 300 
    translate  <100,350,-3000>
}


// More Distant Ringed Moon

object
{
    ringed_moon
    rotate <0,40,0>
    rotate <50,0,0>
    scale 800 
    translate  <-2400,9500,-30000>
}


// Random Small Moon

object
{
    moon
    rotate <0,40,0>
    rotate <50,0,0>
    scale 20 
    translate  <500,20,-1500>
}


// Large Planet

sphere
{
    <0,0,0>,10
    texture {pigment {Tan_Wood} }
    rotate <90,0,0>
    scale 500
    translate <-5000,0,-10000>
}

// Large Planet atmosphere
sphere
{
    <0,0,0>,10
    rotate <90,0,0>
    scale 505
    texture { CBGasGiantSky }
    //scale 5
    translate <-5000,0,-10000>
}


// Water Surface

plane { <0, 1, 0>, -1
    texture { CBRoughWater scale 1.2 }
}



// traditional ruined temple bits and pieces

/*
// lone section
object
{
    doric_section
    rotate <0,45,80>
    translate <5,-1,-2>
    texture { CBMarble }
}
*/

//column
object
{
    doric_section
    rotate <90,0,0>
    translate <-5,-0.2,-0>
    texture { CBMarble }
}

object
{
    doric_section
    rotate <90,0,0>
    texture { CBMarble }
    translate <-5,0.8,-0>
}

object
{
    doric_section
    rotate <90,0,0>
    translate <-5,1.8,-0>
    texture { CBMarble }
}

object
{
    doric_section
    rotate <90,0,0>
    translate <-1,0,0>
    texture { CBMarble }
    translate <-4.1,2.8,-0>
}

object
{
    doric_section
    rotate <90,0,0>
    texture { CBMarble }
    translate <-4.7,3.8,-0>
}


object
{
    doric_section
    rotate <90,0,0>
    translate <-5,-0.2,-6>
    texture { CBMarble }
}

object
{
    doric_section
    rotate <90,0,0>
    texture { CBMarble }
    translate <-5,0.8,-12>
}


object
{
    doric_section
    rotate <90,0,0>
    translate <-5,-0.2,-12>
    texture { CBMarble }
}

object
{
    doric_section
    rotate <90,0,0>
    translate <-5,-0.2,-18>
    texture { CBMarble }
}

object
{
    doric_section
    rotate <90,0,0>
    translate <-5,-0.1,-24>
    texture { CBMarble }
}

object
{
    doric_section
    rotate <90,0,0>
    translate <-5,-0.2,-30>
    texture { CBMarble }
}
  
object
{
    doric_section
    rotate <90,0,0>
    texture { CBMarble }
    translate <-5,-0.8,-30>
}
object
{
    doric_section
    rotate <90,0,0>
    translate <-5,0.2,-30>
    texture { CBMarble }
}
  
// Playing around wit stuff...
/*
  fog {
    distance 50
    color rgbt<0.5, 0.7, 0.8, 0.05>
    fog_type 2
    fog_offset 0
    fog_alt 0.5
  }
*/  
// magician's column with sun dial
object
{
    doric_section
    rotate <90,0,0>
    scale 0.5
    translate <2,0,16>
    texture { CBMarble }
}
object
{
    doric_section
    rotate <90,0,0>
    scale 0.5
    translate <2,0.5,16>
    texture { CBMarble }
}

object
{
    doric_section
    rotate <90,0,0>
    scale 0.5
    translate <2,1.0,16>
    texture { CBMarble }
}  
/*
object
{
    doric_section
    rotate <90,0,0>
    scale 0.5
    translate <1,1.5,15>
    texture { CBMarble }
}
*/
    
light_source {
    <2, 2.5, 16> Gold 
    fade_distance 10.0 
    fade_power 1.0
 } 

union
{ 
    object {sun_dial rotate <0,0,30>}
    object {sun_dial_base}
    texture { T_Gold_1B }
//    no_shadow  
    rotate <0,150,0>
    scale 0.5
    translate<2,1.65,16>
}
                   

//column framing right hand side...

object
{
    doric_section
    rotate <90,0,0>
    translate <-3.5,-0.2,14>
    texture { CBMarble }
}

object
{
    doric_section
    rotate <90,0,0>
    texture { CBMarble }
    translate <-3.5,0.8,14>
}

object
{
    doric_section
    rotate <90,0,0>
    translate <-3,1.8,14>
    texture { CBMarble }
}

object
{
    doric_section
    rotate <90,0,0>
    translate <-1,0,0>
    texture { CBMarble }
    translate <-2.5,2.8,14>
}

object
{
    doric_section
    rotate <90,0,0>
    texture { CBMarble }
    translate <-3.45,3.8,14>
}

object
{
    doric_section
    rotate <90,0,0>
    translate <-1,0,0>
    texture { CBMarble }
    translate <-2.2,4.8,14>
}

object
{
    doric_section
    rotate <90,0,0>
    texture { CBMarble }
    translate <-3.0,5.8,14>
}

// rotated column section in water 

object
{
    doric_section
    rotate <45,0,0> 
    rotate <0,0,135>
    texture { CBMarble }
    translate <-1.7,-.9,3>
}
