// -------- Bucket

#declare iw_BucketPlastic = texture {
	pigment { color rgb < 0.25, 0.25, 0.98 > }
	finish {
	   ambient 0.23
	   diffuse 0.23
	   specular 0.05  roughness 0.05
       phong 0.10 roughness 220
	   //reflection 0.05
       crand 0.025
	}
}

#declare iw_BucketFoil = texture {
	pigment { color rgb 0.95 }
	finish {
	   ambient 0.25
	   diffuse 0.35
	   specular 0.15  roughness 0.001
       //phong 0.50 roughness 250
	   //reflection 0.05
       crand 0.025
       metallic brilliance 8
       reflection 0.6
	}
    normal {
       granite 0.075
       scale <2, 10, 1>
       scale 0.05
       turbulence 0.75
       octaves 5 omega 0.55
    }
}

#declare iw_BucketMetal = texture {
	pigment { color rgb 0.45 }
	finish {
	   ambient 0.3
	   diffuse 0.25
	   specular 0.30  roughness 0.05
       //phong 0.25 roughness 100
	   //reflection 0.05
       crand 0.05
	}
}

#declare iw_bucket = object {
   union {
      // ---- Main body
      difference {
         cone { 0*y, 0.5, 0.801*y, 0.35 }
         cone { 0*y, 0.5, 0.80*y, 0.35 scale 0.95 translate -y*0.025 }
         plane { -y, 0 translate 0.80*y texture { iw_BucketPlastic } }
         //box  { <-0.06, -0.06, 0> <0.06, 0.06, -10> rotate -z*45 scale <1, 1.5, 1> }
         //texture { iw_BucketFoil }
      }
      // ---- Spout
      /*
      difference {
         box  {
            <-0.12, -0.12, 0.5> <0.12, 0.12, -10>
            rotate -z*45
            scale <1.2, 1.5, 1>
            translate <0, 0.1, -0.45>
            rotate -x*35
         }
         cone { 0*y, 0.5, 0.80*y, 0.35 }
         //plane { x, 0 }
         plane { y, 0 }
         scale 1.15
      }*/
      union {
         difference {
            sphere { 0*y, 0.05 }
            plane { y, 0 }
            sphere { 0*y, 0.048 }
            scale <1, 1.65, 1>
         }
         difference {
            torus { 0.05, 0.015 }
            plane { -y, 0 }
            torus { 0.05, 0.0115 translate y*0.005 }
            //scale 0.975
         }
         scale <0.8, 1, 0.9>
         scale 1.45
         translate -z*0.5
      }
      // ---- Lip of bucket
      difference {
         torus { 0.525, 0.015 }
         plane { -y, 0 }
         torus { 0.525, 0.0115 translate y*0.005 }
         scale 0.975
      }
      // ---- Rings on underside
      torus { 0.3375, 0.004 scale <1, 0.75, 1> translate y*0.80 }
      torus { 0.13, 0.004 scale <1, 0.75, 1> translate y*0.80 }
      torus { 0.05, 0.0025 scale <1, 0.75, 1> translate y*0.80 }
      sphere { 0*y, 0.02 scale <1, 0.15, 1> translate y*0.80 }
      // ---- Handle attachment
      union {
         cylinder { -0.05*x, 0.05*x, 0.05 }
         torus { 0.045, 0.005 rotate -z*90 translate x*0.05 }
         box { <-0.035, -0.075, -0.005> <0.035, 0, 0.005> translate -z*0.075 }
         box { <-0.035, -0.075, -0.005> <0.035, 0, 0.005> translate  z*0.075 }
         translate <0.460, 0.075, 0>
      }
      union {
         cylinder { -0.05*x, 0.05*x, 0.05 }
         torus { 0.045, 0.005 rotate -z*90 translate x*0.05 }
         box { <-0.035, -0.075, -0.005> <0.035, 0, 0.005> translate -z*0.075 }
         box { <-0.035, -0.075, -0.005> <0.035, 0, 0.005> translate  z*0.075 }
         translate <-0.460, 0.075, 0>
      }
      // ---- Handle
      union {
         union {
            cylinder { -0.075*x, 0.100*x, 0.005 }
            difference {
               torus { 0.020, 0.005 }
               plane { x, 0 }
               plane { z, 0 }
               translate <0.100, 0, -0.020>
               rotate -x*90
            }
            cylinder { 0*y, -0.050*y, 0.005 translate <0.120, -0.020, 0> }
            translate <0.445, 0.075, 0>
         }
         union {
            cylinder { 0.075*x, -0.100*x, 0.005 }
            difference {
               torus { 0.020, 0.005 }
               plane { -x, 0 }
               plane { z, 0 }
               translate <-0.100, 0, -0.020>
               rotate -x*90
            }
            cylinder { 0*y, -0.050*y, 0.005 translate <-0.120, -0.020, 0> }
            translate <-0.445, 0.075, 0>
         }
         difference {
            torus { 0.565, 0.005 rotate -x*90 }
            plane { -y, 0 }
            scale <1, 1.1, 1>
            translate <0, 0.015, 0>
         }
         texture { iw_BucketMetal }
         rotate x*85
      }
      texture { iw_BucketPlastic }
   }
}

