#declare GrassBlade_Texture = texture {
   pigment {
      bozo
      color_map {
         [ 0.00 color rgb < 0.1, 0.8, 0.1 > ]
         [ 0.20 color rgb < 0.1, 0.9, 0.1 > ]
         [ 0.50 color rgb < 0.3, 0.8, 0.2 > ]
         [ 1.00 color rgb < 0.7, 0.8, 0.1 > ]
      }
      turbulence 0.75
      scale 0.01
   }
   finish  { ambient 0.30 diffuse 0.25 specular 0.01 roughness 0.05 crand 0.075 }
   //normal  { bozo 0.05 turbulence 0.2 scale 0.01 }
}

/*
#declare GrassBase_Texture = texture {
   pigment { color rgb < 0.1, 0.775, 0.1 > }
   finish  { ambient 0.25 diffuse 0.25 crand 0.2 }
   normal  { bozo 0.5 triangle_wave turbulence 0.15 scale 0.05 }
}
*/

#declare GrassBase_Texture = texture {
   pigment {
      agate //bozo //triangle_wave
      color_map {
         [ 0.00 color rgb < 0.6, 0.75, 0.1 > ]
         [ 0.10 color rgb < 0.1, 0.75, 0.1 > ]
         [ 0.50 color rgb < 0.1, 0.75, 0.1 > ]
         [ 0.90 color rgb < 0.4, 0.65, 0.1 > ]
         [ 1.00 color rgb < 0.4, 0.75, 0.3 > ]
      }
      turbulence 0.4
      scale 0.1
   }
   finish  { ambient 0.40 diffuse 0.15 crand 0.1 specular 0.05 roughness 0.025 }
   normal  { bozo 0.2 triangle_wave turbulence 0.15 scale 0.05 }
}

#declare GrassBlade1 = object {
   //cone { 0*y, 0.1, 0.5*y, 0 }
   difference {
      cylinder { -0.1*x, 0.1*x, 0.125 }
      cylinder { 100*x, -100*x, 0.125 translate z*0.02 }
      plane { y, 0 }
      plane {  x, 0 rotate y*45  translate x*0.025 }
      plane { -x, 0 rotate -y*45  translate -x*0.025 }
   }
   scale <0.25, 2, 1>
   //texture { GrassBlade_Texture }
}

#declare BoundingBox = object { box { <-10, 0, 10> <10, 1, 10> } }

// ===== Controls ==================================================

#declare DoHiRez = on
#declare DoMedRez = on
#declare DoLowRez = on
#declare DoNoRez = on

#declare Multiplier = 1.75
#declare HiRez_MaxBlades = 1500*Multiplier
#declare MedRez_MaxBlades = 750*Multiplier
#declare LoRez_MaxBlades = 400*Multiplier
#declare NoRez_MaxBlades = 250*Multiplier

// =================================================================




// =================================================================
//  High Resolution Patch
// =================================================================

#if ( DoHiRez = on )

#declare Max_Blades = HiRez_MaxBlades
#declare Blade_Count = 0

#declare R1 = seed (12345)
#declare R2 = seed (54321)
#declare R3 = seed (67890)
#declare R4 = seed (09876)
#declare R5 = seed (51321)
#declare R6 = seed (62230)
#declare R7 = seed (02666)

#declare Grass = object {
   union {

      #while ( Blade_Count <= Max_Blades )

         #declare Random1 = rand(R1)
         #declare Random2 = rand(R2)
         #declare Random3 = rand(R3)
         #declare Random4 = rand(R4)
         #declare Random5 = rand(R5)
         #declare Random6 = rand(R6)
         #declare Random7 = rand(R7)

         object {
            GrassBlade1
            scale <0.8 + 0.2*Random1, 0.8 + 0.2*Random2, 0.8 + 0.2*Random3>
            rotate x*40*Random4
            rotate y*360*Random5
            translate <Random6*10, 0, -Random7*10>
         }

         object {
            GrassBlade1
            scale <0.7 + 0.2*Random4, 0.7 + 0.2*Random1, 0.7 + 0.2*Random7>
            rotate x*40*Random2
            rotate y*360*Random3
            translate <Random5*10, 0, -Random6*10>
         }

         //object { GrassBlade1 scale 0.5 + 0.1*Random4 rotate x*20*Random3 rotate y*360*Random1 translate <Random4*10, 0, -Random2*10> }

         #declare Blade_Count = Blade_Count + 1

      #end //while
   }
   texture { GrassBlade_Texture }
}


#declare GrassPatch_HiRez = object {
   union {
      box { <0, 0, -1> <1, -0.01, 0> texture { GrassBase_Texture } }
      object { Grass scale 0.1 }
      translate <-0.5, 0, 0.5>
   }
}

#end



// =================================================================
//  Medium Resolution Patch
// =================================================================

#if ( DoMedRez = on )

#declare Max_Blades = MedRez_MaxBlades
#declare Blade_Count = 0

#declare R1 = seed (12345)
#declare R2 = seed (54321)
#declare R3 = seed (67890)
#declare R4 = seed (09876)
#declare R5 = seed (51321)
#declare R6 = seed (62230)
#declare R7 = seed (02666)

#declare Grass = object {
   union {

      #while ( Blade_Count <= Max_Blades )

         #declare Random1 = rand(R1)
         #declare Random2 = rand(R2)
         #declare Random3 = rand(R3)
         #declare Random4 = rand(R4)
         #declare Random5 = rand(R5)
         #declare Random6 = rand(R6)
         #declare Random7 = rand(R7)

         object {
            GrassBlade1
            scale <0.8 + 0.2*Random1, 0.8 + 0.2*Random2, 0.8 + 0.2*Random3>
            rotate x*40*Random4
            rotate y*360*Random5
            translate <Random6*10, 0, -Random7*10>
         }

         object {
            GrassBlade1
            scale <0.7 + 0.2*Random4, 0.7 + 0.2*Random1, 0.7 + 0.2*Random7>
            rotate x*40*Random2
            rotate y*360*Random3
            translate <Random5*10, 0, -Random6*10>
         }

         //object { GrassBlade1 scale 0.5 + 0.1*Random4 rotate x*20*Random3 rotate y*360*Random1 translate <Random4*10, 0, -Random2*10> }

         #declare Blade_Count = Blade_Count + 1

      #end //while
   }
   texture { GrassBlade_Texture }
}

#declare GrassPatch_MedRez = object {
   union {
      box { <0, 0, -1> <1, -0.01, 0> texture { GrassBase_Texture } }
      object { Grass scale 0.1 }
      translate <-0.5, 0, 0.5>
   }
}

#end



// =================================================================
//  Low Resolution Patch
// =================================================================

#if ( DoLowRez = on )

#declare Max_Blades = LoRez_MaxBlades
#declare Blade_Count = 0

#declare R1 = seed (12345)
#declare R2 = seed (54321)
#declare R3 = seed (67890)
#declare R4 = seed (09876)
#declare R5 = seed (51321)
#declare R6 = seed (62230)
#declare R7 = seed (02666)

#declare Grass = object {
   union {

      #while ( Blade_Count <= Max_Blades )

         #declare Random1 = rand(R1)
         #declare Random2 = rand(R2)
         #declare Random3 = rand(R3)
         #declare Random4 = rand(R4)
         #declare Random5 = rand(R5)
         #declare Random6 = rand(R6)
         #declare Random7 = rand(R7)

         object {
            GrassBlade1
            scale <0.8 + 0.2*Random1, 0.8 + 0.2*Random2, 0.8 + 0.2*Random3>
            rotate x*20*Random4
            rotate y*360*Random5
            translate <Random6*10, 0, -Random7*10>
         }

         object {
            GrassBlade1
            scale <0.7 + 0.2*Random4, 0.7 + 0.2*Random1, 0.7 + 0.2*Random7>
            rotate x*20*Random2
            rotate y*360*Random3
            translate <Random5*10, 0, -Random6*10>
         }

         //object { GrassBlade1 scale 0.5 + 0.1*Random4 rotate x*20*Random3 rotate y*360*Random1 translate <Random4*10, 0, -Random2*10> }

         #declare Blade_Count = Blade_Count + 1

      #end //while
   }
   texture { GrassBlade_Texture }
}

#declare GrassPatch_LoRez = object {
   union {
      box { <0, 0, -1> <1, -0.01, 0> texture { GrassBase_Texture } }
      object { Grass scale 0.1 }
      translate <-0.5, 0, 0.5>
   }
}

#end




// =================================================================
//  Ultra-Low ("No-Rez") Resolution Patch
// =================================================================

#if ( DoLowRez = on )

#declare Max_Blades = NoRez_MaxBlades
#declare Blade_Count = 0

#declare R1 = seed (12345)
#declare R2 = seed (54321)
#declare R3 = seed (67890)
#declare R4 = seed (09876)
#declare R5 = seed (51321)
#declare R6 = seed (62230)
#declare R7 = seed (02666)

#declare Grass = object {
   union {

      #while ( Blade_Count <= Max_Blades )

         #declare Random1 = rand(R1)
         #declare Random2 = rand(R2)
         #declare Random3 = rand(R3)
         #declare Random4 = rand(R4)
         #declare Random5 = rand(R5)
         #declare Random6 = rand(R6)
         #declare Random7 = rand(R7)

         object {
            GrassBlade1
            scale <0.8 + 0.2*Random1, 0.8 + 0.2*Random2, 0.8 + 0.2*Random3>
            rotate x*20*Random4
            rotate y*360*Random5
            translate <Random6*10, 0, -Random7*10>
         }

         object {
            GrassBlade1
            scale <0.7 + 0.2*Random4, 0.7 + 0.2*Random1, 0.7 + 0.2*Random7>
            rotate x*20*Random2
            rotate y*360*Random3
            translate <Random5*10, 0, -Random6*10>
         }

         //object { GrassBlade1 scale 0.5 + 0.1*Random4 rotate x*20*Random3 rotate y*360*Random1 translate <Random4*10, 0, -Random2*10> }

         #declare Blade_Count = Blade_Count + 1

      #end //while
   }
   texture { GrassBlade_Texture }
}

#declare GrassPatch_NoRez = object {
   union {
      box { <0, 0, -1> <1, -0.01, 0> texture { GrassBase_Texture } }
      object { Grass scale 0.1 }
      translate <-0.5, 0, 0.5>
   }
}

#end
