
#declare HiQualWindows = on

// ******************************************************************************************
// ----------------------------------- Define Textures --------------------------------------
// ******************************************************************************************


#declare GutteringTexture = texture {
   pigment { color rgb <0.999, 0.969, 0.822> }
   finish  { ambient 0.60 diffuse 0.5 specular 0.2 roughness 0.025 reflection 0.05 brilliance 2  crand 0.05 }
}

#declare CreamPlaster = texture {
   pigment { color rgb <0.999, 0.969, 0.722> }
   finish  { ambient 0.45 diffuse 0.4 specular 0.15 roughness 0.1 crand 0.1 }
}

#declare RoofTile = texture {
   pigment { color rgb <0.702, 0.308, 0.350> }
   finish  { ambient 0.55 diffuse 0.4 specular 0.15 roughness 0.1 }
   normal {
      average
      normal_map {
         [ 1 gradient x 1.0 ramp_wave scale 0.20 ]
         [ 1 gradient z 0.5 sine_wave scale 0.15 ]
      }
   }
   scale 1.2
   rotate y*90
}

#declare WindowGlass = texture {
   pigment { color rgbf<0.925, 0.925, 0.925, 0.9> }
   finish  {
	  specular 1
	  roughness 0.001
	  ambient 0.05
	  diffuse 0.05
	  refraction on
	  reflection 0.15 //0.1
	  ior 1.5
	  caustics 0.5
      crand 0.015
	  //brilliance 2 //8
   }
}

#declare WindowGlassLo = texture { // ------ Texture for quick render. no filtering.
   pigment { color rgb<0.85, 0.85, 0.85> }
   finish  {
	  specular 1
	  roughness 0.001
	  ambient 0.05
	  diffuse 0.05
	  //refraction on
	  //reflection 0.1
	  ior 1.5
	  caustics 0.5
	  //brilliance 2 //8
   }
}

#declare WhitePlaster = texture {
   pigment { color rgb <0.969, 0.969, 0.962> }
   finish  { ambient 0.60 diffuse 0.5 specular 0.05 roughness 0.01 crand 0.075}
}

#declare BlondBrick = texture {
   brick
      //---------- Mortar Texture
      texture {
         pigment { color rgb <0.994, 0.971, 0.949> }
         finish { ambient 0.60 diffuse 0.4 specular 0.2 roughness 0.05 crand 0.1 }
      }
      //---------- Brick Texture
      texture {
         pigment {
            bozo
            /*
            colour_map {
               [ 0.00 color rgb <0.894, 0.871, 0.649> ]
               [ 0.33 color rgb <0.873, 0.735, 0.390> ]
               [ 0.66 color rgb <0.755, 0.735, 0.351> ]
               [ 1.00 color rgb <0.851, 0.822, 0.351> ]
            }
            */
            colour_map {
               [ 0.00 color rgb <0.994, 0.921, 0.699> ]
               [ 0.33 color rgb <0.973, 0.785, 0.440> ]
               [ 0.66 color rgb <0.855, 0.785, 0.401> ]
               [ 1.00 color rgb <0.951, 0.872, 0.401> ]
            }
            turbulence 1
         }
         finish { ambient 0.5 /*0.6*/ diffuse 0.45 specular 0.35 roughness 0.05 crand 0.15 }
         normal {
            average
            normal_map {
               [ 1 bozo 0.6 turbulence 0.75 ]
               [ 1 crackle 0.4 ]
            }
            scale 0.1
         }
      }
   brick_size <2.5, 1, 1>
   mortar 0.20 //0.4
   scale 0.07 //0.2
}


// ******************************************************************************************
// -------------------------------------- Guttering -----------------------------------------
// ******************************************************************************************

#declare GutteringStraight = object {
   union {
      cylinder { -0.5*x, 0.5*x, 0.15 open scale <1, 1.1, 1> }
      cylinder { -0.5*x, 0.5*x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { -0.5*x, 0.5*x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { GutteringTexture }
}

#declare GutteringStraightR = object {
   union {
      cylinder { -x, 0*x, 0.15 open scale <1, 1.1, 1> }
      cylinder { -x, 0*x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { -x, 0*x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { GutteringTexture }
}

#declare GutteringStraightL = object {
   union {
      cylinder { 0*x, x, 0.15 open scale <1, 1.1, 1> }
      cylinder { 0*x, x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { 0*x, x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { GutteringTexture }
}

#declare GutteringCorner = object {
   union {
      object {
         GutteringStraight
         clipped_by {
            plane { x,0 rotate -y*45 }
            plane { -x,0 translate -x*0.1 }
         }
      }
      object {
         GutteringStraight
         rotate -y*90
         clipped_by {
            plane { x,0 rotate y*135 }
            plane { z,0 translate z*0.1 }
         }
      }
   }
   texture { GutteringTexture }
}


#declare DrainPipe = object {
   union {
      box { <-0.1, -0.1, -0.1> <0, 1.8, 0.1> }
      box { <-0.4, 2.0, -0.1> <-0.3, 2.2, 0.1> }
      box {
         <-0.078, -0.1, -0.1> <0, 0.5, 0.1>
         rotate z*55
         translate y*1.8
         clipped_by {
            plane { -y, 0 translate y*1.8 }
            plane {  y, 0 translate y*2.0 }
         }
      }
   }
   texture { GutteringTexture }
}


#declare IMPORT_SPATCH = true
#include "curtain1b.inc"

#declare CurtainTexture = texture {
	pigment { color rgb < 0.7, 0.7, 0.8 > }
	finish {
	   ambient 0.3
	   diffuse 0.25
	   specular 0.35
	   roughness 0.05
       crand 0.1
	   //reflection 0.05
	}
}

#declare House1_WindowHollow = object {
   box { <-0.575, 0, 1> <0.575, 0.80, -100> }
}

#declare House1_Window1 = object {
   union {
      difference {
         box { <-0.575, 0.00,  0> <0.575, 0.80, 0.10> }
         box { <-0.545, 0.03, 10> <0.570, 0.77, -10> }
         box { <-0.54, 0.01, 0.01> <0.54, 0.79, 0.09> }
      }
      #if ( HiQualWindows = on )
      union {
         difference {
            box { <-0.025, 0.00,  0.005> <0.60, 0.80, 0.05> }
            box { < 0.000, 0.05, 10> <0.55, 0.75, -10> }
         }
         box { <-0.025, 0.00,  0.0275> < 0.56, 0.80, 0.0325> texture { WindowGlass } }
      }
      union {
         difference {
            box { < 0.025, 0.00,  0.05> <-0.60, 0.80, 0.085> }
            box { <-0.000, 0.05, 10> <-0.575, 0.75, -10> }
         }
         box { < 0.025, 0.00,  0.0675> <-0.56, 0.80, 0.0725> texture { WindowGlass } }
         translate x*0.35
      }
      #end
      difference {
         box { <-0.55, -0.1, 0.1> <0.55, 0, -0.1> rotate -x*40 }
         plane { -y, 0 }
         texture { BlondBrick rotate y*90 scale<1,2,1> }
      }
      #if ( HiQualWindows = on )
      object {
         Curtain
         scale 0.25
         texture { CurtainTexture }
         scale <1.25, 1, 1>
         translate <-0.35, 0.575, 0.1>
      }
      object {
         Curtain
         scale 0.25
         texture { CurtainTexture }
         scale <1.25, 1, 1>
         rotate y*180
         translate < 0.35, 0.575, 0.1>
      }
      #end
   }
   texture {
      pigment { color rgb <0.999, 0.969, 0.822> }
      finish  {
         ambient 0.55 diffuse 0.5 specular 0.2
         roughness 0.025 reflection 0.05 brilliance 2
      }
   }
}


#declare House1_Window2 = object {
   union {
      difference {
         box { <-0.575, 0.00,  0> <0.575, 0.80, 0.10> }
         box { <-0.545, 0.03, 10> <0.570, 0.77, -10> }
         box { <-0.54, 0.01, 0.01> <0.54, 0.79, 0.09> }
      }
      #if ( HiQualWindows = on )
      union {
         difference {
            box { <-0.025, 0.00,  0.005> <0.60, 0.80, 0.05> }
            box { < 0.000, 0.05, 10> <0.55, 0.75, -10> }
         }
         box { <-0.025, 0.00,  0.0275> < 0.56, 0.80, 0.0325> texture { WindowGlass } }
      }
      union {
         difference {
            box { < 0.025, 0.00,  0.05> <-0.60, 0.80, 0.085> }
            box { <-0.000, 0.05, 10> <-0.575, 0.75, -10> }
         }
         box { < 0.025, 0.00,  0.0675> <-0.56, 0.80, 0.0725> texture { WindowGlass } }
         translate x*0.15
      }
      #end
      difference {
         box { <-0.55, -0.1, 0.1> <0.55, 0, -0.1> rotate -x*40 }
         plane { -y, 0 }
         texture { BlondBrick rotate y*90 scale<1,2,1> }
      }
      #if ( HiQualWindows = on )
      object {
         Curtain
         scale 0.25
         texture { CurtainTexture }
         scale <1.25, 1, 1>
         rotate y*180
         translate < 0.25, 0.575, 0.1>
      }
      #end
   }
   texture {
      pigment { color rgb <0.999, 0.969, 0.822> }
      finish  {
         ambient 0.55 diffuse 0.5 specular 0.2
         roughness 0.025 reflection 0.05 brilliance 2
      }
   }
}



#declare House1_Window1Pos = <-1.175, 1.825, 0.225>
#declare House1_Window2Pos = <-2.900, 1.825, 0.225>

#declare RoofCornerUnit = object { cone { 0*y, 0.075, 0.23*y, 0.030 } }

#declare RoofCorner = object {
   union {
      object { RoofCornerUnit translate y*0.23*00 }
      object { RoofCornerUnit translate y*0.23*01 }
      object { RoofCornerUnit translate y*0.23*02 }
      object { RoofCornerUnit translate y*0.23*03 }
      object { RoofCornerUnit translate y*0.23*04 }
      object { RoofCornerUnit translate y*0.23*05 }
      object { RoofCornerUnit translate y*0.23*06 }
      object { RoofCornerUnit translate y*0.23*07 }
      object { RoofCornerUnit translate y*0.23*08 }
      object { RoofCornerUnit translate y*0.23*09 }
   }
   texture {
      pigment { color rgb <0.702, 0.308, 0.350> }
      finish  { ambient 0.55 diffuse 0.4 specular 0.15 roughness 0.1 }
   }
   scale <1.15, 1, 0.25>
}

#declare House1_Roof = object {
   union {
      difference {
         box { <-3, 0, 0> <0, 1.00, 3> }
         plane { -x, 0 rotate z*50 }
         plane { z, 0 rotate x*60 }
      }
      box { <-3, 0.00, 0.0> <0.00, -0.18, 3> texture { WhitePlaster } }
      object { RoofCorner rotate x*65 rotate -y*38 }
      object { RoofCorner rotate x*90 rotate -y*90 translate <-1.32, 0.982, 1.7> }
   }
   texture { RoofTile }
}

#declare House1_Shell = object {
   difference {
      union {
         box { <-3, 0, 0.225> <-0.175, 2.85, 3> }
         //box { <-3, 2.67, 0.0> <0.00, 2.85, 3> texture { WhitePlaster } }
         cylinder { -3*x, -0.15*x, 0.035 scale <1, 1, 1.5> translate <0, 2.745, 0.25> texture { WhitePlaster } }
      }
      box { <-2.9, 0, 0.275> <-0.20, 2.75, 2.9> texture { CreamPlaster } } // --- main hollow
      // --- windows
      object { House1_WindowHollow translate House1_Window1Pos }
      object { House1_WindowHollow translate House1_Window2Pos }
   }
   texture { BlondBrick translate -z*0.1}
}


#include "lamp.inc"

#declare BookCase = object {
   union {
      difference {
         box { <-0.375, 0.00,  0> <0.375, 1.20, -0.225> }
         box { <-0.370, 0.05,  -0.05> <0.370, 1.175, -100> }
      }
      box { <-0.370, 0.0,  -0.05> <0.370, 0.01, -0.215> translate y*0.70}
      box { <-0.370, 0.0,  -0.05> <0.370, 0.01, -0.215> translate y*0.95}
   }
   texture {
      pigment { color rgb <0.5, 0.4, 0.1> }
      finish { ambient 0.25 diffuse 0.50 specular 0.1 roughness 0.005 crand 0.025 }
   }
   rotate y*90
   translate <-0.3, 1.4, 1.35>
}

#declare House1_SideRoof = object {
   union {
      difference {
         box { <-3, 0, 0> <0, 1.00, 3> }
         //plane { -x, 0 rotate z*50 }
         plane { z, 0 rotate x*60 }
      }
      //box { <-3.05, 0.00, 0.0> <0.00, -0.18, 3> texture { WhitePlaster } }
      object { RoofCorner rotate x*65 rotate -y*0 }
      object { RoofCorner rotate x*90 rotate -y*90 translate <-1.32, 0.982, 1.7> }
   }
   texture { RoofTile }
}

#declare House1_SideBit = object {
   union {
      box { <-0.175, 0, 0.00> <2.00, 1.85, 3> texture { BlondBrick } }
      difference {
         object { House1_SideRoof scale <1, 0.6, 1> translate <2, 1.85, -0.1> }
         plane { x, 0 translate -x*0.1755
            texture {
               pigment { color rgb <0.702, 0.308, 0.350> }
               finish  { ambient 0.55 diffuse 0.4 specular 0.15 roughness 0.1 }
            }
         }
      }
      box { <-0.176, 0.00, 0.0> <2.00, -0.12, 3> texture { WhitePlaster } translate <0, 1.85, -0.1> }
      union {
         object { GutteringCorner }
         union {
            object { GutteringCorner }
            object { GutteringStraightR scale <0.55, 1, 1> }
            rotate y*90
            translate -x*4.30
         }
         object { GutteringStraightR scale <4.4, 1, 1> }
         scale <0.5, 0.5, 0.65>
         translate <2, 1.85, -0.1>
      }
   }
}

#declare House1_Aerial = object {
   union {
      cylinder { 0*y, 1.855*y, 0.0075 }
      cylinder { 0*y, -1.95*y, 0.0020 rotate x*50 rotate y*60 translate y*1.65 }
      cylinder { 0*y, -1.95*y, 0.0020 rotate x*30 rotate y*180 translate y*1.65 }
      cylinder { 0*y, -1.95*y, 0.0020 rotate x*30 rotate y*300 translate y*1.65 }
      union {
         box { <-0.0065, 0, 0.46> <0.0065, 0.01, -0.46> }
         cylinder { -0.375*x, 0.375*x, 0.0025 translate z*0.420 }
         cylinder { -0.500*x, 0.500*x, 0.0025 translate z*0.270 }
         cylinder { -0.355*x, 0.355*x, 0.0025 translate z*0.120 }
         cylinder { -0.275*x, 0.275*x, 0.0025 translate z*0.000 }
         cylinder { -0.175*x, 0.175*x, 0.0025 translate -z*0.120 }
         cylinder { -0.125*x, 0.125*x, 0.0025 translate -z*0.270 }
         cylinder { -0.125*x, 0.125*x, 0.0025 translate -z*0.420 }
         translate y*1.855
         rotate -y*15
      }
   }
   texture {
      pigment { color rgb 0.5 }
      finish { ambient 0.35 diffuse 0.35 specular 0.1 roughness 0.025 }
   }
}

#declare House1 = object {
   union {
      object { House1_Shell }
      object { House1_Roof translate y*2.95 }
      light_source { <-1, 2.5, 2> color rgb <1.0, 1.0, 0.975>*0.55 }
      object { House1_Window1 translate House1_Window1Pos }
      object { House1_Window2 translate House1_Window2Pos }
      object { DrainPipe rotate y*180 scale <0.9, 1, 1> translate <-0.25, 0.70, 0.425> }
      object { Lamp scale <0.0275, 0.0325, 0.0325> rotate y*30 translate <-0.695, 1.895, 0.55> }
      object { BookCase }
      union {
         object { GutteringCorner }
         object { GutteringStraightR scale <5.5, 1, 1> }
         scale 0.6
         translate y*2.925
      }
      object { House1_Aerial translate <-0.5, 2.75, 1.5> }
      object { House1_SideBit }
   }
}

