
#declare RoofTile2 = texture {
   pigment { color rgb <0.402, 0.208, 0.150> }
   finish  { ambient 0.50 diffuse 0.5 specular 0.10 roughness 0.01 }
   normal {
      average
      normal_map {
         [ 1 gradient x 1.0 ramp_wave scale 0.20 ]
         [ 1 gradient z 0.5 sine_wave scale 0.15 ]
      }
   }
   scale 1.2
   rotate y*90
}

#declare Q229_RoofTile = texture {
   pigment { color rgb <0.602, 0.338, 0.300> }
   finish  { ambient 0.4 diffuse 0.35 specular 0.1 roughness 0.01 }
   normal {
      average
      normal_map {
         [ 1 gradient x ramp_wave scale 0.20 ]
         [ 1 gradient z sine_wave scale 0.15 ]
      }
   }
   scale 0.65
}


#declare RedBrick = texture {
   brick
      //---------- Mortar Texture
      texture {
         pigment { color rgb <0.894, 0.871, 0.849> }
         finish { ambient 0.4 diffuse 0.45 specular 0.2 roughness 0.05 crand 0.1 }
      }
      //---------- Brick Texture
      texture {
         pigment {
            bozo
            colour_map {
               [ 0.00 color rgb <0.944, 0.721, 0.499> ]
               [ 0.33 color rgb <0.923, 0.585, 0.240> ]
               [ 0.66 color rgb <0.805, 0.385, 0.201> ]
               [ 1.00 color rgb <0.901, 0.672, 0.201> ]
            }
            turbulence 1
         }
         finish { ambient 0.45 diffuse 0.35 specular 0.2 roughness 0.05 crand 0.15 }
         normal {
            average
            normal_map {
               [ 1 bozo 0.6 turbulence 0.75 ]
               [ 1 crackle 0.4 ]
            }
            scale 0.1
         }
      }
   brick_size <2.35, 1, 1>
   mortar 0.275 //0.4
   scale 0.125
}

#declare GutteringTexture = texture {
   pigment { color rgb <0.999, 0.769, 0.322>*0.65 }
   finish  { ambient 0.60 diffuse 0.5 specular 0.2 roughness 0.025 reflection 0.05 brilliance 2  crand 0.05 }
}

#declare WhitePlaster = texture {
   pigment { color rgb <0.969, 0.969, 0.962> }
   finish  { ambient 0.60 diffuse 0.5 specular 0.05 roughness 0.01 crand 0.075}
}


// ******************************************************************************************
// -------------------------------------- Guttering -----------------------------------------
// ******************************************************************************************

#declare GutteringStraight = object {
   union {
      cylinder { -0.5*x, 0.5*x, 0.15 open scale <1, 1.1, 1> }
      cylinder { -0.5*x, 0.5*x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { -0.5*x, 0.5*x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { GutteringTexture }
}

#declare GutteringStraightR = object {
   union {
      cylinder { -x, 0*x, 0.15 open scale <1, 1.1, 1> }
      cylinder { -x, 0*x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { -x, 0*x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { GutteringTexture }
}

#declare GutteringStraightL = object {
   union {
      cylinder { 0*x, x, 0.15 open scale <1, 1.1, 1> }
      cylinder { 0*x, x, 0.03 translate <0, -0.06, -0.13> scale <1, 1.1, 1> }
      cylinder { 0*x, x, 0.2 open scale <1, 0.35, 1.2> }
      clipped_by { plane { y,0 } plane { z,0 } }
   }
   texture { GutteringTexture }
}

#declare GutteringCorner = object {
   union {
      object {
         GutteringStraight
         clipped_by {
            plane { x,0 rotate -y*45 }
            plane { -x,0 translate -x*0.1 }
         }
      }
      object {
         GutteringStraight
         rotate -y*90
         clipped_by {
            plane { x,0 rotate y*135 }
            plane { z,0 translate z*0.1 }
         }
      }
   }
   texture { GutteringTexture }
}


#declare House2_Roof = object {
   union {
      difference {
         box { <-3, 0, 0> <1, 2.75, 4.5> }
         plane { z, 0 rotate x*60 texture { Q229_RoofTile rotate y*90 } }
         plane { -z, 0 rotate -x*60 translate z*4.5 texture { Q229_RoofTile rotate y*90 } }
         plane { x, 0 rotate -z*30 translate -x*3 texture { Q229_RoofTile rotate y*0 } }
         plane { -x, 0 rotate z*20 translate x*1 }
         translate y*0.15
      }
      box { <-3, 0, 0> <1, 0.15, 4.5> texture { WhitePlaster } }
   }
   //texture { Q229_RoofTile rotate y*90 }
}

#declare House2_Shell = object {
   box { <-3, 0, 0> <1, 2.75, 4.5> }
}

#declare House2 = object {
   union {
      object { House2_Shell }
      object { House2_Roof translate y*2.75 }
      union {
         object { GutteringCorner translate x*1 }
         object { GutteringCorner rotate y*90 translate -x*3 }
         object { GutteringCorner rotate y*180 translate <-3, 0, 4.5> }
         object { GutteringStraightR scale <4, 1, 1> translate x*1 }
         object { GutteringStraightR scale <4.5, 1, 1> rotate y*90 translate -x*3 }
         scale <1, 0.8, 1>
         translate y*2.925
      }
   }
}
