
// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc:
// Date:
// Auth: Chris Hernandez


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
//#include "CHARS.INC"   // FIXME-add comments describing each of these
//#include "CONSTS.INC"
//#include "METALS.INC"
//#include "SHAPES.INC"
//#include "SHAPES2.INC"
//#include "SHAPESQ.INC"
//#include "SKIES.INC"
//#include "STONES.INC"
//#include "STONES2.INC"
//#include "WOODMAPS.INC"
//#include "WOODS.INC"


// ===== Scene Controls ==========================================

   #declare Environment_Switch = on
   #declare Grass_Switch = on
   #declare Kid_Switch = on
   #declare Tree_Switch = on
   #declare TreeHouse_Switch = on
   #declare GIFTree_Switch = on
   #declare Fence_Switch = on
   #declare FenceGrass_Switch = on
   #declare Dimmer = 0.975 //0.825
   #declare House_Switch = on

   #declare HiQuality = off

// ===============================================================



// -------------------------------- light sources ---------------

light_source {
   <100, 300, -100> color rgb <0.75, 0.75, 0.74>*Dimmer*0.85
   //#if ( HiQuality = on ) area_light x, z, 0.5, 0.5 jitter adaptive 1 #end
}

light_source {
   <95, 300, -100> color rgb <0.75, 0.75, 0.74>*Dimmer*0.85
   //#if ( HiQuality = on ) area_light x, z, 0.5, 0.5 jitter adaptive 1 #end
}

light_source {
   <105, 300, -100> color rgb <0.75, 0.75, 0.74>*Dimmer*0.85
   //#if ( HiQuality = on ) area_light x, z, 0.5, 0.5 jitter adaptive 1 #end
}

light_source {
   <100, 300, -105> color rgb <0.75, 0.75, 0.74>*Dimmer*0.85
   //#if ( HiQuality = on ) area_light x, y, 0.5, 0.5 jitter adaptive 1 #end
}

light_source {
   <-100, 500, -105> color rgb <0.75, 0.75, 0.74>*Dimmer*0.35
   //#if ( HiQuality = on ) area_light x, y, 0.5, 0.5 jitter adaptive 1 #end
}

light_source {
   <20, 5, -40> color rgb <0.75, 0.75, 0.73>*Dimmer*0.20
   //#if ( HiQuality = on ) area_light x, y, 2, 2 jitter adaptive 1 #end
}


light_source {
   <-5, 1, -50> color rgb <0.75, 0.75, 0.73>*Dimmer*0.20
   //#if ( HiQuality = on ) area_light x, y, 2, 2 jitter adaptive 1 #end
}

light_source {
   <0.0, 0.3, -10.0> color rgb <0.75, 0.75, 0.73>*Dimmer*0.15
   //#if ( HiQuality = on ) area_light x, y, 2, 2 jitter adaptive 1 #end
}

background { color rgb <0.6, 0.6, 0.6> }


#declare TempTexture = texture {
	pigment { color rgb < 0.7, 0.7, 0.8 > }
	finish {
	   ambient 0.3
	   diffuse 0.25
	   specular 0.35
	   roughness 0.05
	   //reflection 0.05
	}
}

#declare RedT = texture { pigment { color rgb <1,0,0> } }



global_settings {
   max_trace_level 6
   ambient_light rgb <1.0, 1.0, 0.985>
}

// ------------------------------------ Camera -------------------
camera {
  location  <0.0, 0.3, -10.0> //<-8.0, 0.25, -12>
  look_at   <0.0, 1.0,  0.0>  //<0.5 , 1.5 , 0.0>
  angle 25
  #if ( HiQuality = on )
     //blur_samples 50  aperture 0.025  focal_point <0.5, 0.95, -6>  confidence 0.75
     blur_samples 200  aperture 0.0125  focal_point <0.5, 0.95, -6>  confidence 0.90
  #end
}

//#default { texture { TempTexture } }



#if ( GIFTree_Switch = on )

   #include "GIFTREES.INC"

   object { CBH_GIFTree4 scale <0.5, 0.70, 0.5>*0.80 translate <4.80, 0.00, 13.00> }
   object { CBH_GIFTree4 scale <0.55, 0.75, 0.5>*1.00 rotate y*180 translate <-2.20, 0.00, 20.50> }

#end



plane { y, 0
   texture {
      pigment { color rgb <0, 0.5, 0> }
      finish { ambient 0.3 diffuse 0.3 specular 0.15 roughness 0.05 }

      normal {
         bump_map {
         tga "grasshf1c.tga"
         map_type 0
         interpolate 2
         bump_size 10.0
      }
      rotate x*90
      }

   }
}



// ---- grass --------------------------------------------------------

#if ( Grass_Switch = on )

#include "grass.inc"

union {
   object { GrassPatch_HiRez }
   object { GrassPatch_MedRez translate < 1, 0, 0> }
   object { GrassPatch_MedRez translate <-1, 0, 0> }

   object { GrassPatch_MedRez translate < 0, 0, 1> }
   object { GrassPatch_MedRez translate <-1, 0, 1> }
   object { GrassPatch_MedRez translate < 1, 0, 1> }

   object { GrassPatch_LoRez rotate y*90 translate < 0, 0, 2> }
   object { GrassPatch_LoRez translate <-1, 0, 2> }
   object { GrassPatch_LoRez translate < 1, 0, 2> }

   object { GrassPatch_LoRez rotate -y*90 translate < 0, 0, 3> }
   object { GrassPatch_LoRez translate <-1, 0, 3> }
   object { GrassPatch_LoRez translate < 1, 0, 3> }

   object { GrassPatch_LoRez rotate y*90 translate < 0, 0, 4> }
   object { GrassPatch_LoRez translate <-1, 0, 4> }
   object { GrassPatch_LoRez translate < 1, 0, 4> }
   object { GrassPatch_LoRez translate <-2, 0, 4> }
   object { GrassPatch_LoRez translate < 2, 0, 4> }

   object { GrassPatch_NoRez rotate -y*180 scale <1, 1.1, 1> translate < 0, 0, 5> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate <-1, 0, 5> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate < 1, 0, 5> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate <-2, 0, 5> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate < 2, 0, 5> }

   object { GrassPatch_NoRez rotate y*180 scale <1, 1.1, 1> translate < 0, 0, 6> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate <-1, 0, 6> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate < 1, 0, 6> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate <-2, 0, 6> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate < 2, 0, 6> }

   object { GrassPatch_NoRez rotate -y*90 scale <1, 1.1, 1> translate < 0, 0, 7> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate <-1, 0, 7> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate < 1, 0, 7> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate <-2, 0, 7> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate < 1, 0, 7> }
   object { GrassPatch_NoRez scale <1, 1.15, 1> translate < 2, 0, 7> }

   object { GrassPatch_LoRez scale <1, 1.20, 1> translate <0.1, 0.00, 2.3> }

   scale <1.25, 0.87, 1.25> translate <0, 0.002, -6.35>
}

#end



// -------- Next door

#if ( House_Switch = on )

#include "house1.inc"

object {
   House1
   rotate -y*45
   translate <-1.65, 0, 7.65> //<-1.5, 0, 7>
   //texture { Talbingo_BlondBrick }
}



#include "house2b.inc"

object {
   House2
   rotate -y*45
   //translate <4.5, 0, 18>
   translate <5.25, 0, 22>
   texture { RedBrick }
}

#end

// ---------- Tree

#if ( Tree_Switch = on )

/*
#declare iw_TestTree2 = object {
   #include "treetmp2.pov"
}
*/



#include "tree2d.pov"

object {
   //iw_TestTree2
   IW_Tree
   scale <-1.20, 1.00, 1.20>
   scale 0.385
   rotate -x*90
   rotate y*150
   translate <0.1, -0.30, 2.3>
}

#include "roots2.pov"

object {
   IW_TreeRoots
   scale 0.20
   rotate x*91.5
   scale <-1, -1.05, 1>
   rotate -y*45
   //rotate -z*20
   translate <0.1, 0.12, 2.3>
}

object {
   IW_TreeRoots
   scale 0.25
   rotate x*94.5
   scale <-1, -1.05, 1>
   rotate y*30
   //rotate -z*20
   translate <0.1, 0.135, 2.3>
}

#end

#if ( TreeHouse_Switch = on )

#declare IW_TreeHouseWood = texture {
   pigment {
      wood
      colour_map {
         [ 0.00 color rgb <0.959, 0.873, 0.533> ]
         [ 0.25 color rgb <0.859, 0.773, 0.533> ]
         [ 0.28 color rgb <0.750, 0.710, 0.700> ]
         [ 0.29 color rgb <0.750, 0.710, 0.700> ]
         [ 0.50 color rgb <0.799, 0.683, 0.433> ]
         [ 0.75 color rgb <0.939, 0.823, 0.533> ]
         [ 1.00 color rgb <0.959, 0.873, 0.533> ]
      }
      turbulence 0.7
   }
   finish { ambient 0.30 diffuse 0.35 crand 0.075 specular 0.015 roughness 0.05 }
   normal {
      wood 0.05
      slope_map {
         [ 0.00 <0.200, 0.384> ]
         [ 0.25 <0.306, 0.206> ]
         [ 0.28 <0.106, 0.106> ]
         [ 0.50 <0.327, 0.288> ]
         [ 0.75 <0.406, 0.249> ]
         [ 1.00 <0.406, 0.227> ]
      }
      scale <1.5, 2, 1.5>
      scale 1.9
      turbulence 0.9
   }
   rotate x*90
   scale <0.5, 4, 0.5>
   scale 0.15
}


#declare IW_TreeHousePanel_Front = object {
   box { <-0.95, 0, 0.00> <0.95, 0.12, 0.02> }
}

#declare IW_TreeHousePanel_Side = object {
   box { <0.00, 0, 0.95> <-0.02, 0.12, -1.125> }
}

#declare IW_TreeHousePanel_Bottom = object {
   box { <-0.95, 0.00, 0.00> <0.95, 0.02, 0.1375> }
}

#declare IW_TreeHouseFloor = object {
   union {
      object { IW_TreeHousePanel_Bottom translate < 0.01, 0.00, 0.00> }
      object { IW_TreeHousePanel_Bottom translate <-0.00, 0.00, 0.15> }
      object { IW_TreeHousePanel_Bottom translate < 0.01, 0.00, 0.30> }
      object { IW_TreeHousePanel_Bottom translate < 0.00, 0.00, 0.45> }
      object { IW_TreeHousePanel_Bottom translate <-0.02, 0.00, 0.60> }
      object { IW_TreeHousePanel_Bottom translate < 0.00, 0.00, 0.75> }
      object { IW_TreeHousePanel_Bottom translate <-0.01, 0.00, 0.90> }
      object { IW_TreeHousePanel_Bottom translate < 0.00, 0.00, 1.05> }
      object { IW_TreeHousePanel_Bottom translate <-0.01, 0.00, 1.20> }
      object { IW_TreeHousePanel_Bottom translate < 0.01, 0.00, 1.35> }
      object { IW_TreeHousePanel_Bottom translate < 0.00, 0.00, 1.50> }
      object { IW_TreeHousePanel_Bottom translate < 0.02, 0.00, 1.65> }
      object { IW_TreeHousePanel_Bottom translate <-0.01, 0.00, 1.85> }
      object { IW_TreeHousePanel_Bottom translate < 0.00, 0.00, 2.00> }
      //object { IW_TreeHousePanel_Bottom translate <0.00, 0.00, 0.00> }
   }
}

#declare IW_TreeHouseWall_Front = object {
   union {
      object { IW_TreeHousePanel_Front rotate x*2 translate < 0.01, 0.00, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate < 0.01, 0.10, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate < 0.02, 0.20, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate < 0.00, 0.30, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate <-0.01, 0.40, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate < 0.01, 0.50, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate <-0.02, 0.60, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate <-0.03, 0.70, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate < 0.01, 0.80, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate < 0.02, 0.90, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate <-0.00, 1.00, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate < 0.01, 1.10, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate <-0.01, 1.20, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate < 0.02, 1.30, 0.00> }
      object { IW_TreeHousePanel_Front rotate x*2 translate <-0.03, 1.40, 0.00> }
   }
}


#declare IW_TreeHouseWall_Side = object {
   union {
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 0.00, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 0.10, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 0.20, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 0.30, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 0.40, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 0.50, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 0.60, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 0.70, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 0.80, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 0.90, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 1.00, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 1.10, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 1.20, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 1.30, 0.00> }
      object { IW_TreeHousePanel_Side rotate z*2 translate <0.00, 1.40, 0.00> }
   }
}


#declare IW_TreeHouseShell = object {
   union {
      object { IW_TreeHouseWall_Front translate <0.00, 0.00, 0.95> }
      object { IW_TreeHouseWall_Front translate <0.00, 0.00,-1.15> }
      object { IW_TreeHouseWall_Side translate < 0.95, 0.00, 0.00> }
      object { IW_TreeHouseWall_Side translate <-0.92, 0.00, 0.00> }
      object { IW_TreeHouseFloor translate <0, 0, -1.15> }
      object { IW_TreeHouseFloor translate <0, 1.5, -1.15> }
   }
}

#declare IW_TreeHouse = object {
  union {
     difference {
        //box { <-0.95, 0, 0.95> <0.95, 1.5, -1.15> }
        object { IW_TreeHouseShell }
        //box { <-0.93, 0.02, 0.93> <0.93, 1.48, -1.13> }
        box { <-100, 0.4, -0.20> <100, 0.8, 0.20> }
        box { <-0.225, 0.5, 100> <0.225, 0.8, -100> translate x*0.45 }
        box { <-0.225, 0.5, 100> <0.225, 0.8, -100> translate -x*0.45 }
        box { <-0.25, -100, -0.25> <0.25, 0.5, 0.25> translate -z*0.7 }
      }
   }
   texture { IW_TreeHouseWood rotate z*90 }
}

object { IW_TreeHouse rotate y*12 translate <0, 2.20, 2.3> }

#declare IW_TreeLadderRung = object {
   box { <-0.248, 0, -0.02> <0.248, 0.13, 0> }
   texture { IW_TreeHouseWood rotate z*90 }
   rotate -z*2
}

#declare IW_TreeLadder = object {
   union {
      object { IW_TreeLadderRung rotate  z*01 rotate y*15 translate <0.00, 1.95, 1.9825> }
      object { IW_TreeLadderRung rotate  z*01 rotate y*13 translate <-0.01, 1.60, 1.985> }
      object { IW_TreeLadderRung rotate -z*01 rotate y*11 translate <-0.00, 1.15, 1.985> }
      object { IW_TreeLadderRung rotate  z*01 rotate y*09 translate <0.045, 0.70, 1.985> }
      object { IW_TreeLadderRung rotate  z*00 rotate y*07 translate <0.085, 0.30, 1.985> }
   }
}

object { IW_TreeLadder translate -x*0.05 }

#end

// ------------- Street Light
/*
#include "streetlight.inc"

object { IW_StreetLight rotate y*140 translate <0, 3, 50> }
//object { IW_StreetLight rotate y*(140+180) translate <0, 3, 60> }
//object { IW_StreetLight rotate y*140 translate <0, 3, 50> }
*/


// ------------- Sign

/*
union {
   cylinder { 0*y, 0.65*y, 0.025 }
   box { <-0.25, 0.25, -0.025> <0.25, 0.60, -0.030> }
   texture { TempTexture }
   rotate -y*22.5
   translate <-0.6, 0, -3.3>
}
*/


#declare FenceWood = texture {
   pigment {
      wood
      colour_map {
         [ 0.00 color rgb <0.859, 0.773, 0.533> ]
         [ 0.25 color rgb <0.859, 0.773, 0.533> ]
         [ 0.28 color rgb <0.650, 0.610, 0.600> ]
         [ 0.29 color rgb <0.650, 0.610, 0.600> ]
         [ 0.50 color rgb <0.799, 0.683, 0.433> ]
         [ 0.75 color rgb <0.839, 0.723, 0.533> ]
         [ 1.00 color rgb <0.859, 0.773, 0.533> ]
      }
      turbulence 0.7
   }
   finish { ambient 0.275 diffuse 0.325 crand 0.075 specular 0.05 roughness 0.05 }
   normal {
      wood 0.15 //0.20
      slope_map {
         [ 0.00 <0.200, 0.384> ]
         [ 0.25 <0.306, 0.206> ]
         [ 0.28 <0.106, 0.106> ]
         [ 0.50 <0.327, 0.288> ]
         [ 0.75 <0.406, 0.249> ]
         [ 1.00 <0.406, 0.227> ]
      }
      scale <1.5, 2, 1.5>
      scale 1.9
      turbulence 0.9
   }
   rotate x*90
   scale <0.5, 4, 0.5>
   scale 0.15
}


union {
   box { <-0.025, 0, -0.025> <0.025, 0.65, 0.025> }
   union {
      box { <-0.25, 0.25, -0.025> <0.25, 0.360, -0.030> translate -x*0.01 }
      box { <-0.25, 0.365, -0.025> <0.25, 0.49, -0.030> rotate z*2 }
      box { <-0.25, 0.495, -0.025> <0.25, 0.605, -0.030> translate -x*0.01 }
      texture { FenceWood rotate z*90 }
      texture {
         pigment {
            image_map {
               gif "sign3.gif"
   		       map_type 0
			   interpolate 2
               filter all 0.35
               transmit 249 1.0
               transmit 250 1.0
               transmit 251 1.0
               transmit 252 1.0
               transmit 253 1.0
               transmit 254 1.0
			   transmit 255 1.0 //138 1.0
			   once
		     }
             translate <-0.5, -0.5, 0>
             //scale <1.4, 1, 1>
             rotate -z*2.5
             scale 0.55
             translate <0, 0.43, 0.0>
          }
          finish { ambient 0.45 crand 0.075 diffuse 0.1 }
       }
   }
   texture { FenceWood }
   rotate -y*22.5
   translate <-0.6, 0, -3.3>
}


// ------------- Kid

#if ( Kid_Switch = on )

#include "kid4.inc"

object { Kid translate y*0.0275 }

#end


//----------------------------------------------------------------------------------

#if ( Environment_Switch = on )
   #include "iw_environment.inc"
#end



// ----------- Fence


// -----------------------------------------------------------------------------


#if ( Fence_Switch = on )

#if ( FenceGrass_Switch = on )

#declare GrassBlade_Texture = texture {
   pigment {
      bozo
      color_map {
         [ 0.00 color rgb < 0.1, 0.8, 0.1 > ]
         [ 0.20 color rgb < 0.1, 0.9, 0.1 > ]
         [ 0.50 color rgb < 0.3, 0.8, 0.2 > ]
         [ 1.00 color rgb < 0.7, 0.8, 0.1 > ]
      }
      turbulence 0.75
      scale 0.01
   }
   finish  { ambient 0.25 diffuse 0.30 specular 0.1 roughness 0.05 crand 0.075 }
   //normal  { bozo 0.05 turbulence 0.2 scale 0.01 }
}

#declare GrassBlade1 = object {
   //cone { 0*y, 0.1, 0.5*y, 0 }
   difference {
      cylinder { -0.1*x, 0.1*x, 0.125 }
      cylinder { 100*x, -100*x, 0.125 translate z*0.02 }
      plane { y, 0 }
      plane {  x, 0 rotate y*45  translate x*0.025 }
      plane { -x, 0 rotate -y*45  translate -x*0.025 }
   }
   scale <0.10, 1.0, 0.6>
   scale 0.6
   //texture { GrassBlade_Texture }
}

// ===== Controls ==================================================

#declare Max_Blades = 75 //60

// =================================================================




// =================================================================
//  High Resolution Patch
// =================================================================

#declare Blade_Count = 0

#declare R1 = seed (12345)
#declare R2 = seed (54321)
#declare R3 = seed (67890)
#declare R4 = seed (09876)
#declare R5 = seed (51321)
#declare R6 = seed (62230)
#declare R7 = seed (02666)

#declare FenceGrassPatch = object {
   union {

      #while ( Blade_Count != Max_Blades )

         #declare Random1 = rand(R1)
         #declare Random2 = rand(R2)
         #declare Random3 = rand(R3)
         #declare Random4 = rand(R4)
         #declare Random5 = rand(R5)
         #declare Random6 = rand(R6)
         #declare Random7 = rand(R7)

         object {
            GrassBlade1
            scale <0.8 + 0.2*Random1, 0.6 + 0.2*Random2, 0.8 + 0.2*Random3>
            rotate x*10*Random4
            rotate y*(150 + 70*Random5)
            translate <-Random5*2.65, 0, -0.035 - Random6*0.13>
         }

         object {
            GrassBlade1
            scale <0.5 + 0.2*Random4, 0.35 + 0.2*Random1, 0.5 + 0.2*Random7>
            rotate x*10*Random2
            rotate y*(150 + 70*Random3)
            translate <-Random4*2.65, 0, -0.05 - Random5*0.13>
         }

         //object { GrassBlade1 scale 0.5 + 0.1*Random4 rotate x*20*Random3 rotate y*360*Random1 translate <Random4*10, 0, -Random2*10> }

         #declare Blade_Count = Blade_Count + 1

      #end //while
   }
   texture { GrassBlade_Texture }
}

#end // Fence Grass Switch

// -------------------------- Bolts

#declare Bolt_PlaneDist = 0.08

#declare Bolt_Texture = texture {
   pigment { color rgb 0.6 }
   finish {
      ambient 0.3
      diffuse 0.45
      specular 0.01
      roughness 0.065
      crand 0.05
   }
}

#declare Bolt = object {
   union {
      difference {
         cylinder { 0*z, -0.05*z, 0.1}
         plane { y, -Bolt_PlaneDist rotate z*000 }
         plane { y, -Bolt_PlaneDist rotate z*045 }
         plane { y, -Bolt_PlaneDist rotate z*090 }
         plane { y, -Bolt_PlaneDist rotate z*135 }
         plane { y, -Bolt_PlaneDist rotate z*180 }
         plane { y, -Bolt_PlaneDist rotate z*225 }
         plane { y, -Bolt_PlaneDist rotate z*270 }
         plane { y, -Bolt_PlaneDist rotate z*315 }
      }
      cylinder { -0.02*z, -0.10*z, 0.04}
      torus { 0.03, 0.01 rotate x*90 translate -z*0.10 }
      cylinder { -0.02*z, -0.075*z, 0.03}
      texture { Bolt_Texture }
      //scale <1, 1, 1.2>
      scale 0.3
   }
}



// ----------- Fence


#declare FenceWood = texture {
   pigment {
      wood
      colour_map {
         [ 0.00 color rgb <0.859, 0.773, 0.533> ]
         [ 0.25 color rgb <0.859, 0.773, 0.533> ]
         [ 0.28 color rgb <0.650, 0.610, 0.600> ]
         [ 0.29 color rgb <0.650, 0.610, 0.600> ]
         [ 0.50 color rgb <0.799, 0.683, 0.433> ]
         [ 0.75 color rgb <0.839, 0.723, 0.533> ]
         [ 1.00 color rgb <0.859, 0.773, 0.533> ]
      }
      turbulence 0.9
   }
   finish { ambient 0.35 diffuse 0.35 crand 0.075 specular 0.05 roughness 0.05 }
   normal {
      wood 0.15 //0.30
      slope_map {
         [ 0.00 <0.200, 0.384> ]
         [ 0.25 <0.306, 0.206> ]
         [ 0.28 <0.106, 0.106> ]
         [ 0.50 <0.327, 0.288> ]
         [ 0.75 <0.406, 0.249> ]
         [ 1.00 <0.406, 0.227> ]
      }
      scale <1.5, 2, 1.5>
      scale 1.9
      turbulence 0.9
   }
   rotate x*90
   scale <0.5, 4, 0.5>
   scale 0.15
}


#declare Fence_Support = object {
   difference {
      box{ <-0.05, 0, -0.05> <0.05, 1.35, 0.05> }
      box{ <-100, -0.040, -0.04> <100, 0.040, 0.04> translate y*1.05 }
      box{ <-100, -0.040, -0.04> <100, 0.040, 0.04> translate y*0.20 }
      texture { FenceWood }
   }
}

#declare Fence_Paling = object {
   union {
      box { <-0.15, 0, 0> <0, 1.3, 0.015> }
      cylinder { 0.025*z, -0.035*z, 0.01 texture { Bolt_Texture } translate <-0.05, 1.05, 0.00> }
   }
}

#declare PalingSpacing = 0.165

#declare Fence_Unit = object {
   union {
      object { Fence_Support }
      box{ <-2.65, -0.040, -0.03> <0, 0.040, 0.03> translate y*1.05 texture { FenceWood rotate -z*89 } }
      box{ <-2.65, -0.040, -0.03> <0, 0.040, 0.03> translate y*0.25 texture { FenceWood rotate -z*87 } }
      object { Bolt translate <0, 1.05, -0.05> }
      object { Bolt translate <0, 0.25, -0.05> }
      object { Fence_Paling translate -x*(0.070+PalingSpacing*00) translate <0.0, 0.009, 0.001> texture { FenceWood translate x*0.45 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*01) translate <0.0, 0.020, 0.001> texture { FenceWood translate x*0.10 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*02) translate <0.0, 0.005, 0.001> texture { FenceWood translate x*0.99 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*03) translate <0.0, 0.009, 0.001> texture { FenceWood translate x*0.00 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*04) translate <0.0, 0.002, 0.001> texture { FenceWood translate x*2.30 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*05) translate <0.0, 0.012, 0.001> texture { FenceWood translate x*4.60 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*06) translate <0.0, 0.007, 0.001> texture { FenceWood translate x*2.00 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*07) translate <0.0, 0.000, 0.001> texture { FenceWood translate x*1.20 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*08) translate <0.0, 0.003, 0.001> texture { FenceWood translate x*1.70 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*09) translate <0.0, 0.014, 0.001> texture { FenceWood translate x*7.40 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*10) translate <0.0, 0.006, 0.001> texture { FenceWood translate x*4.35 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*11) translate <0.0, 0.017, 0.001> texture { FenceWood translate x*6.00 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*12) translate <0.0, 0.009, 0.001> texture { FenceWood translate x*5.33 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*13) translate <0.0, 0.010, 0.001> texture { FenceWood translate x*4.21 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*14) translate <0.0, 0.002, 0.001> texture { FenceWood translate x*8.27 }}
      object { Fence_Paling translate -x*(0.070+PalingSpacing*15) translate <0.0, 0.015, 0.001> texture { FenceWood translate x*9.26 }}
      #if ( FenceGrass_Switch) object { FenceGrassPatch scale <1, 0.75, 1> } #end
      //texture { FenceWood translate x*0.00 }
   }
}

#declare Fence_Left = object {
   union {
      object { Fence_Unit translate -x*2.65 }
      object { Fence_Unit translate x*0.00 }
      object { Fence_Unit translate x*2.65 }
   }
   texture { TempTexture }
}

#declare Fence_Right = object { Fence_Unit }


union {
   //box { <-4, 0, 0> <2.65, 1.30, 0.05> }
   object { Fence_Left }
   //box { <0, 0, 0> <0.05, 1.30, -3> translate x*2.65 }
   object { Fence_Right rotate y*90 translate <2.65, 0, -2.65> }
   //texture { Talbingo_FenceWood }
   rotate -y*45
   translate <0, 0, 5>
}

#end  //  Fence Switch


// ------ END OF FILE

