// ***********************************
//  Darin Dugger's "Kite" clouds
// ***********************************

#declare T_Cloud2 =
texture {
    pigment {
        bozo
        turbulence 1.5
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.5 color rgbf<.93, .93, .93, 0.15>
                      color rgbf<.9, .9, .9, .9> ]
            [0.5, 0.7 color rgbf<.9, .9, .9, .9>
                      color rgbf<1, 1, 1, 1> ]
            [0.7, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }

    finish {
        ambient 0.9
        diffuse 0.1
    }
}

#declare T_Cloud3 =
texture {
    pigment {
        bozo
        turbulence 1.0 //0.8 //0.6
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.955, .955, .955, 0.15>
                      color rgbf<.93, .93, .93, .93> ]
            [0.4, 0.5 color rgbf<.93, .93, .93, .93>
                      color rgbf<1, 1, 1, 1> ]
            [0.5, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }
    finish {
        ambient 1.0
        diffuse 0.0
    }
}
texture {
    pigment {
        bozo
        turbulence 0.8 //0.6
        octaves 10
        omega .5
        lambda 2.5
        color_map {
            [0.0, 0.4 color rgbf<.995, .995, .995, 0.1>
                      color rgbf<.96, .96, .96, .96> ]
            [0.4, 0.5 color rgbf<.96, .96, .96, .96>
                      color rgbf<1, 1, 1, 1> ]
            [0.5, 1.0 color rgbf<1, 1, 1, 1>
                      color rgbf<1, 1, 1, 1> ]
        }
    }
    finish {
        ambient 0.95
        diffuse 0.0
    }
scale .9
translate y*-0.15
}


#declare O_Cloud2 =
union {
    plane { -y, -650
        texture {
            T_Cloud3
            scale 550
        }
    }
    plane { -y, -2000
        texture {
            T_Cloud2
            scale <900,1,6000>
            translate x*3000
            rotate -30*y
        }
    }
}


#declare P_Cloud4 = pigment {
    wrinkles
    turbulence 0.1
    lambda 2.2
    omega 0.707
    color_map {
        [0.20 color rgb <0.20, 0.575, 0.8> ]
        [0.50 Gray95 ]
        [1.00 Gray75 ]
    }
    scale <0.5, 0.15, 1>
}

sky_sphere {
	pigment {
		gradient y
		pigment_map {
			[0.00 rgb <0.847, 0.847, 0.847> ] // horizon
			[0.07 color rgb <0.20, 0.575, 0.9> ]                   // horizon
			[0.12 P_Cloud4 scale 0.25 ]
		}
	}
}

object { O_Cloud2 scale <1.75, 1, 1.75> inverse }

/*
fog {
   fog_type 1
   distance 25000
   turbulence 0.5
   color rgbft <0.847, 0.847, 0.847, 0, 0.1>
}
*/

