
#declare Kid_Flesh = texture {
   pigment { color red 0.96 green 0.80 blue 0.69 }
   finish { ambient 0.35 diffuse 0.35 crand 0.02 }
   normal { wrinkles 0.15 turbulence 0.25 scale 0.01 }
}

#declare Kid_ShirtTexture = texture {
   pigment { color rgb <0.925, 0.925, 0.975> }
   finish  { ambient 0.45 diffuse 0.425 crand 0.035 }
   //normal  { wrinkles 0.30 turbulence 0.5 scale <0.015, 0.03, 0.02> }
   normal {
       average
       normal_map {
          [ 0.8 bozo 0.150 turbulence 0.65 scale <1, 5, 1> scale 0.2 ]
          [ 1.0 gradient x 0.210 sine_wave turbulence 0.25 scale 0.2 ]
       }
       rotate z*55
       scale 0.75
    }
}

#declare Kid_ShortsTexture = texture {
   pigment { color rgb <0.50, 0.80, 0.80>*0.35 }
   finish  { ambient 0.45 diffuse 0.45 crand 0.10 }
   normal {
       average
       normal_map {
          [ 0.8 bozo 0.150 turbulence 0.65 scale <1, 5, 1> scale 0.2 ]
          [ 1.0 gradient x 0.250 sine_wave turbulence 0.25 scale 0.2 ]
       }
       rotate z*55
       scale 0.75
    }
}

#declare Kid_GloveTexture = texture {
   pigment { color rgb <0.95, 0.625, 0.675> }
   finish { ambient 0.45 diffuse 0.65 specular 0.05 roughness 0.005 crand 0.095 }
}

#declare towel_normal = normal {
       bump_map {
          gif "towelscan.gif"
          interpolate 2
          map_type 0
          bump_size 1.5
       }
       turbulence 0.1
       scale 0.025
       rotate z*5
    }

#declare towel_pigment = pigment {
       image_map {
          gif "towelscan.gif"
          interpolate 2
          map_type 0
       }
       turbulence 0.25
       scale 0.0005
       rotate z*5
    }

#declare Kid_CapeBorderTexture = texture {
	pigment { color rgb < 0.85, 0.40, 0.75 > }
	finish {
	   ambient 0.325
	   diffuse 0.25
	   specular 0.035
	   roughness 0.1
       crand 0.175
	   //reflection 0.05
	}
    normal {
       average
       normal_map {
          [ 0.6 bozo 0.060 turbulence 0.65 scale <1, 5, 1> scale 0.2 ]
          [ 1.0 gradient x 0.075 sine_wave turbulence 0.15 scale 0.2 ]
       }
       rotate z*5
    }
}

#declare Kid_CapeTexture = texture {
	pigment {
       average
       pigment_map {
          [0.70 color rgb < 0.85, 0.40, 0.75 > ]
          [1.15 towel_pigment ]
       }
    }
    finish {
	   ambient 0.075
	   diffuse 0.25
	   //specular 0.05
	   //roughness 0.01
       crand 0.01
	   //reflection 0.05
	}
    normal {
       average
       normal_map {
          [ 1.3 bozo 0.30 turbulence 0.65 scale <1, 2.5, 1> scale 0.2 ]
          [ 1.1 gradient x 0.200 sine_wave turbulence 0.15 scale 0.35 ]
          [ 1.35 towel_normal ]
       }
       rotate z*5
    }
}


#declare Kid_ShoeTextureWhite = texture {
   pigment { color rgb 0.9 }
   finish { ambient 0.55 diffuse 0.3 crand 0.085 }
}

#declare Kid_ShoeTextureBlack =   texture {
   pigment { color rgb 0.2 }
   finish { ambient 0.4 diffuse 0.50 specular 0.025 roughness 0.005 crand 0.1 }
}



#declare Kid_LeftArm = object {
   union {
      // --- Shirt Cuff
      union {
         cone { 0.235*x, 0.175, -0.385*x, 0.220 open }
         sphere { 0*x, 0.175 translate 0.235*x }
         torus { 0.220, 0.0075 rotate -z*90 scale <1.5, 1, 1> translate -0.385*x }
         texture { Kid_ShirtTexture }
         scale <1, 1, 0.9>
         rotate z*47
      }
      // --- Upper arm/bicep
      union {
         sphere { 0, 0.185 scale <1.5, 1, 1> }
         //cylinder { 0*x, -0.7*x, 0.20 }
         sphere { 0*x, 0.18 scale <3.00, 1, 1> translate -x*0.25 }
         sphere { 0*x, 0.17 scale <1.85, 1, 1> translate -0.5*x }
         //sphere { 0, 0.195 scale <1.8, 0.65, 0.9> translate <-0.275, -0.07, 0> }
         texture { Kid_Flesh  }
         scale <1.035, 1, 0.9>
         rotate z*43
      }
      // --- Lower Arm
      union {
         //cylinder { 0*x, 0.75*x, 0.11 scale <1, 1, 0.8> }
         cone { -0.05*x, 0.110, 0.75*x, 0.08 scale <1, 1.10, 1.0> }
         difference {
            sphere { 0*x, 0.15 }
            plane { y, 0 }
            plane { x, 0 }
            scale <4, 0.9, 0.60>
            translate <0.05, 0.02, 0>
         }
         difference {
            sphere { 0*x, 0.115 }
            plane { -y, 0 }
            plane {  x, 0 }
            scale <5, 0.95, 0.6>
            translate <-0.05, -0.020, 0>
            //texture { RedT }
         }
         texture { Kid_Flesh  }
         scale <1, 1, 0.9>
         rotate -z*40
         translate < -0.505, -0.505, 0 >
      }
      // --- Glove
      union {
         //-- Upper Part
         union {
            difference {
               cone { 0.255*x, 0.160, 0.75*x, 0.08 open }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*000 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*010 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*020 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*030 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*040 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*050 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*060 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*070 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*080 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*090 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*100 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*110 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*120 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*130 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*140 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*150 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*160 translate 0.255*x }
               box { <-0.015, -0.015, -100> <0.015, 0.015, 100> rotate -z*45  rotate -x*170 translate 0.255*x }
               cone { 0.285*x, 0.15, 0.75*x, 0.08 translate -x*0.02 }
            }
            sphere { 0*x, 0.0825 scale <1.15, 1, 1> translate 0.75*x }
            scale <1, 1.15, 0.90>
         }
         //-- Hand
         union {
            cone { 0*x, 0.09, 0.16*x, 0.12 translate 0.75*x scale <1, 1, 0.6> }
            sphere { 0*x, 0.04  scale <1.4, 2.5, 1.9> translate 0.80*x }
            difference {
               sphere { 0*x, 0.10 }
               plane { x, 0 }
               scale <0.75, 1, 0.6>
               translate 0.89*x
            }
            // --- Thumb
            union {
               sphere {
                  0*x, 0.05
                  scale <1.75, 1.2, 0.75>
                  rotate z*30
                  rotate y*25
               }
               sphere {
                  0*x, 0.04
                  scale <0.8, 1.6, 1>
                  rotate -z*60
                  rotate  y*50
                  translate <0.04, 0.06, -0.0>
               }
               sphere {
                  0*x, 0.03
                  scale <0.9, 1.6, 1>
                  rotate -z*100
                  rotate x*35
                  rotate  y*50
                  translate <0.07, 0.07, -0.03>
               }
               sphere {
                  0*x, 0.025
                  scale <1.0, 1.7, 1>
                  rotate -z*190
                  //rotate -x*25
                  //rotate  y*50
                  translate <0.07, 0.04, -0.06>
               }
               rotate z*10
               translate <0.795, 0.025, -0.025>
            }
            // --- Forefinger
            union {
               sphere {  0*x, 0.033  scale <1, 0.9, 1.9> }
               sphere { 0*x, 0.031 scale <1.6, 0.975, 1> rotate y*10 translate <-0.04, -0.0, -0.04> }
               sphere {  0*x, 0.029  scale <1, 1, 1.9> rotate -y*10 rotate x*20 translate <-0.08, -0.01, 0.01> }
               rotate z*8
               rotate -y*5
               rotate -x*10
               translate <0.945, 0.085, -0.035>
            }
            // --- Middle Finger
            union {
               sphere { 0*x, 0.035  scale <1, 1, 1.9> }
               sphere { 0*x, 0.031 scale <1.6, 1, 1> translate <-0.04, 0, -0.05> }
               sphere {  0*x, 0.031  scale <1, 1, 1.9> rotate -y*10 rotate x*20 translate <-0.08, -0.01, 0.01> }
               rotate z*3
               rotate -y*5
               translate <0.96, 0.025, -0.035>
            }
            // --- Ring Finger
            union {
               sphere { 0*x, 0.032 scale <1, 1, 1.9> }
               sphere { 0*x, 0.030 scale <1.6, 1, 1> translate <-0.04, 0, -0.04> }
               sphere {  0*x, 0.030  scale <1, 1, 1.9> rotate -y*10 rotate -x*5 translate <-0.08, 0.01, 0.01> }
               rotate -z*4
               rotate -y*5
               rotate  x*4
               translate <0.96, -0.035, -0.035>
            }
            // --- Pinkie Finger
            union {
               sphere { 0*x, 0.031 scale <1, 1, 1.9> }
               sphere { 0*x, 0.029 scale <1.6, 1, 1> translate <-0.04, 0, -0.04> }
               sphere {  0*x, 0.028  scale <1, 1, 1.9> rotate -y*0 rotate -x*40 translate <-0.07, 0.025, 0.02> }
               rotate -y*5
               //rotate  x*7
               rotate -z*23
               translate <0.93, -0.09, -0.035>
            }
            //texture { TempTexture }
         }
         rotate -z*40
         scale 1.15
         translate < -0.595, -0.445, 0 >
         texture { Kid_GloveTexture }
      }
   }
}




#declare Kid_TorsoLeft = object {
   union {
      object {
         Kid_LeftArm
         rotate z*3.5
         //translate -x*0.7
         scale <0.725, 1, 1>
         translate y*0.3
      }
      union {
         difference {
            sphere { 0, 1 }
            plane  { -y, 0 }
            plane  { -x, 0 }
            scale < 0.35, 1.1, 0.15 >
         }
         difference {
            sphere { 0, 1 }
            plane  {  y, 0 }
            plane  { -x, 0 }
            scale < 0.35, 0.295, 0.15 >
         }
         translate <0.425, 0.4, 0>
         texture { Kid_ShirtTexture }
      }
   }
   translate -x*0.425
}

#declare Kid_TorsoWidth = 0.30
#declare Kid_Torso = object {
   union {
      object { Kid_TorsoLeft translate -x*Kid_TorsoWidth }
      object { Kid_TorsoLeft rotate y*180 translate x*Kid_TorsoWidth }
      difference {
         cylinder { -x*Kid_TorsoWidth, x*Kid_TorsoWidth, 1 }
         plane { y, 0 }
         scale < 1, 0.295, 0.15 >
         translate <0, 0.4, 0>
         texture { Kid_ShirtTexture }
      }
      difference {
         cylinder { -x*Kid_TorsoWidth, x*Kid_TorsoWidth, 1 }
         plane { -y, 0 }
         scale < 1, 1.1, 0.15 >
         translate <0, 0.4, 0>
         texture { Kid_ShirtTexture }
      }
   }
}


#declare Kid_Shorts = object {
   union {
      torus { 0.45, 0.05 scale < 1, 1, 0.5 > }
      difference {
         sphere { 0*y, 0.45 }
         plane { -y, 0 }
         scale <1, 1, 0.4>
      }
      union {
         cone {
            0*y, 0.25, -1.25*y, 0.335
            scale <1, 1, 0.70>
         }
         sphere { 0*y, 0.3 scale <1, 1.35, 0.9> translate <0.05, -0.25, -0.0> }
         rotate  -z*5
         translate <-0.25, -0.05, 0>
      }
      union {
         cone {
            0*y, 0.25, -1.25*y, 0.335
            scale <1, 1, 0.70>
         }
         sphere { 0*y, 0.3 scale <1, 1.35, 0.9> translate <-0.05, -0.25, -0.0> }
         rotate  z*5
         translate <0.25, -0.05, 0>
      }
      translate -y*0.6
      texture { Kid_ShortsTexture }
   }
}

#declare Kid_ShoeL = object {
   union {
      // ------- Body of shoe
      union {
         difference {
            sphere { 0*y, 0.375 }
            plane { y, 0 }
            plane { z, 0 }
            scale < 0.80, 1.5, 1.75>
            //translate y*0.65
         }
         difference {
            torus { 0.355, 0.025 }
            plane { z, 0 }
            scale < 0.80, 1.75, 3.5>
            texture { Kid_ShoeTextureWhite }
         }
         difference {
            sphere { 0*y, 0.375 }
            plane { y, 0 }
            plane { z, 0 }
            scale < 0.80, 0.90, 3.5>
            //translate y*0.65
         }
         texture { Kid_ShoeTextureBlack }
         texture {
            pigment {
               image_map {
				  gif "shoe_swish.gif"
				  map_type 0
				  interpolate 2
				  transmit 252 1.0 //138 1.0
				  once
			   }
               translate <-0.5, -0.5, 0>
               scale <1.4, 1, 1>
               rotate y*90
               scale 0.365
               translate <0, 0.15, 0.45>
            }
            finish { ambient 0.55 crand 0.075 diffuse 0.1 }
         }
      }

      // ------- Lower Rear
      difference {
         sphere { 0*y, 0.375 }
         plane { y, 0 }
         scale < 0.85, 1.75, 1>
         //translate y*0.65
         texture { Kid_ShoeTextureBlack }
         texture {
            pigment {
               image_map {
				  gif "shoe_povair.gif"
				  map_type 0
				  interpolate 2
				  transmit 96 1.0 //138 1.0
				  once
			   }
               translate <-0.5, -0.5, 0>
               scale <1.15, 1, 1>
               scale 0.365
               translate y*0.15
            }
            finish { ambient 0.55 diffuse 0.1 crand 0.075 }
         }
      }
      torus { 0.355, 0.025 scale < 0.85, 1.75, 1> texture { Kid_ShoeTextureWhite } }

      // ------- Upper Rear
      union {
         difference {
            sphere { 0*y, 0.375 }
            sphere { 0*y, 0.360 translate y*0.05 texture { Kid_ShoeTextureBlack } }
            plane { -y, 0 }
            plane { -y, 0 rotate -x*15 }
            box { <-0.225, -0.15, 0> <0.225, 0.15, 100> rotate  z*30 }
            box { <-0.225, -0.15, 0> <0.225, 0.15, 100> rotate -z*30 }
         }
         difference {
            torus { 0.368, 0.008 }
            plane { -z, 0 }
            scale <1, 1.75, 1>
            rotate -x*12 translate -y*0.005
            texture { Kid_ShoeTextureWhite }
         }
         intersection {
            difference {
               cylinder { -y, y, 0.375 }
               cylinder { -100*y, 100*y, 0.350 }
            }
            difference {
               sphere { 0*y, 0.475 scale <0.35, 0.58, 0.7 > translate <0, 0, -0.375> }
               //plane { y, 0 }
               plane { y, 0 rotate -x*0 }
               plane { -z, 0 }
               //rotate y*30
            }
            scale <1.0, 0.25, 1>
            rotate -x*15
            //translate -y*0.25
         }
         scale < 0.80, 1.85, 1>
         texture { Kid_ShoeTextureBlack }
         texture {
            pigment {
               image_map {
				  gif "shoe_stripes.gif"
				  map_type 0
				  interpolate 2
				  transmit 4 1.0 //138 1.0
				  once
			   }
               translate <-0.5, -0.5, 0>
               scale <5, 1, 1>
               rotate y*90
               rotate -x*30
               scale 0.25
               translate -y*0.15
            }
            finish { ambient 0.55 diffuse 0.1 crand 0.075 }
         }
         translate <0, 0.75, -0.05>
      }
      // ------- Tongue
      union {
         cone { 0*y, 0.2, 0.315*y, 0.3 }
         difference {
            sphere { 0*y, 0.3 }
            plane { y, 0 }
            scale <1, 0.8, 1>
            translate y*0.315
         }
         scale <0.85, 1, 0.15 >
         rotate x*05
         translate <0, 0.45, 0.25>
      }
   }
   scale <0.9, 1.025, 1>
   scale 1.10
   texture { Kid_ShoeTextureBlack }
}

#declare Kid_LegLeft = object {
   union {
      cone { 0*y, 0.220, -1.25*y, 0.10 }
      object { Kid_ShoeL scale 0.60 rotate -y*10 rotate z*8 translate <0.045, -1.45, 0> }
   }
   rotate -z*8
   translate <-0.3575, -1.6, 0>
   texture { Kid_Flesh }
}

#declare Kid_LegRight = object {
   union {
      cone { 0*y, 0.220, -1.25*y, 0.10 }
      object { Kid_ShoeL scale 0.60 rotate  y*20 rotate -z*8 translate <-0.045, -1.45, 0> }
   }
   rotate z*8
   translate <0.3575, -1.6, 0>
   texture { Kid_Flesh }
}

#declare Rocket_Kid = object {
   union {
      object { Kid_Torso }
      object { Kid_Shorts }
      object { Kid_LegLeft }
      object { Kid_LegRight }
   }
}


#include "bucket.inc"
#declare IMPORT_SPATCH = true

#include "capetest11.pov"
#declare Cape = object {
   union {
      object { Cape_Layer1 texture { Kid_CapeTexture } }
      object { Cape_Layer2 texture { Kid_CapeBorderTexture } }
   }
}



#declare Kid = object {
   union {
      object {
         iw_bucket
         scale 1.0
         scale <0.210, 0.23, 0.25>
         rotate -x*30
         rotate z*0
         //rotate y*33
         translate <0.5, 0.92, -6.01> //<-5.0, 0.9, -8.5>
      }

      union {
         object {
            Rocket_Kid
            scale <0.775, 0.8, 0.85>
            rotate -y*0
            translate <0.65, 0.1, 0>
         }
         object {
            Cape
            scale <0.4075, 0.70, 0.5>
            rotate y*0
            //texture { Kid_CapeTexture }
            translate <0.590, 0.0755, -0.625>
         }
         scale <0.335, 0.300, 0.325>
         rotate -y*0
         translate <0.28, 0.675, -6>
      }
   }
}
