//
// Computer game
//
// - an image by Robert Fremin for the IRTC competition
//
// Imaginary worlds
//
// Jan-Feb 1999
// 

#version 3.1;

#include "colors.inc"
#include "woods.inc"
#include "units.inc"

// ---------------------------------------------------------------------------

// Booleans for development
#declare use_monitor  = 1;
#declare use_display  = 1;	// image on CRT
#declare use_table    = 1;
#declare use_cable    = 1;
#declare use_keyboard = 1;
#declare use_mouse    = 1;
#declare use_mousepad = 1;
#declare use_wall     = 1;
#declare use_speaker  = 1;
#declare use_CD       = 1;

// ---------------------------------------------------------------------------

global_settings
{
	ambient_light .1
	assumed_gamma 1.0
}

camera
{
	location <0*m, 30*cm, -65*cm>
	look_at y*10*cm
	right x*(800/600)
	sky y
}

// ---------------------------------------------------------------------------

light_source { <0*m, .5*m, -5*m> Gray30 fade_distance 600*cm fade_power 2 shadowless }

light_source
{
	<2*m, 2*m, -1*m>
	rgb <1,.96,.94>
	spotlight
	point_at <10*cm,0,0>
	radius 5	//4
	falloff 8	//7
	fade_distance 320*cm
	fade_power 3
}


// ---------------------------------------------------------------------------

background { White }

// ---------------------------------------------------------------------------

// Monitor (17")
#if (use_monitor)
#include "monitor.inc"
union
{
	Monitor(use_display)

	rotate y*-35
	translate <-20*cm, 0, 5*cm>
}
#end  // use_monitor


// ---------------------------------------------------------------------------

// Network cable
#if (use_cable)
#include "mixed.inc"
union
{
	CoaxCable(5*mm, CoaxTexture, 15*mm)
	Connector(<-30*cm, 5*mm, 0>)

	rotate y*-10
	translate <23*cm, 0, -20*cm>
}
#end  // use_cable


// ---------------------------------------------------------------------------

// Table
#if (use_table)
box
{
	<-.5,-1,-.5> <.5,0,.5> scale <2*m, 2*cm, 1*m>
	texture { T_Wood23 rotate <1,92,3> scale 5 }
	finish { ambient .001 specular .1 reflection .05 phong .1 phong_size 50 }
}
#end  // use_table


// ---------------------------------------------------------------------------

// Wall
#if (use_wall)
plane
{
	z, 52*cm
	pigment { checker rgb <.4,.4,1>*.5, Gray40 translate y*-.5 scale <10,1000,1>*cm turbulence .5 }
	normal { bumps bump_size 6*mm scale <1,100,1>*mm }
}
#end  // use_wall

// ---------------------------------------------------------------------------

// Mouse
#if (use_mouse)
#include "mouse.inc"

#declare MouseCableTexture =
texture
{
	pigment { Gray90 }
	finish { diffuse .6 specular .4 phong .7 }
}

union
{
	Mouse()
	union
	{
		CoaxCable(4.5*mm, MouseCableTexture, 10*mm)
		pigment { Grey }
		rotate y*-90
		rotate x*2
		translate z*30*cm-y*2*mm
	}

	rotate y*-40
	translate <20*cm, 1*mm+6*mm, 1*cm>
}
#end  // use_mouse


// ---------------------------------------------------------------------------

// Keyboard
#if (use_keyboard)
#include "keyboard.inc"
union
{
	Keyboard()

	rotate <-8, -20, 0>
	translate <-12*cm, 2.2*cm, -10*cm>
}
#end  // use_keyboard


// ---------------------------------------------------------------------------

// Mousepad
#if (use_mousepad)
#include "mixed.inc"
union
{
	MousePad()
	rotate y*-23
	translate <24*cm, 2.5*mm, 4*cm>
}
#end  // use_mousepad


// ---------------------------------------------------------------------------

// Speaker
#if (use_speaker)
#include "mixed.inc"
union
{
	Speaker()
	translate y*10*cm

	rotate y*10
	translate <18,0,30>*cm
}
#end  // use_speaker


// ---------------------------------------------------------------------------

// CD
#if (use_CD)
#include "mixed.inc"
union
{
	CDROM()
	translate <29*cm, 0, -23*cm>
}
#end  // use_CD
