// Mixed objects include file
// by Robert Fremin, d96rfr@csd.uu.se, 1999
//
// Macros:
// CoaxCable(...)
// Connector(...)
// MousePad()
// Speaker()
// CDROM()
//

#ifndef (MIXED_INC)
#declare MIXED_INC = true;
#debug "=#= included mixed.inc =#=\n"

#version 3.1;

#include "colors.inc"
#include "metals.inc"
#include "glass.inc"
#include "units.inc"


// ---------------------------------------------------------------------------

#declare CoaxTexture =
texture
{
	pigment { Gray10 }
	finish { diffuse .6 specular .4 phong .7 }
}

#macro CoaxCable(Diameter, Texture, Factor)
blob
{
	threshold .3

	#local N = 500;
	#local Coax = array[N]
	#local CoaxLength = 50*cm;
	#local CoaxWidth = Diameter / 2;	// => radius
	#local i = 0;
	#while (i < N)
		#local Coax[i] = <i*(CoaxLength/N), 0, 10*cm*sin(radians(i)) * i/N>;
                #local CoaxY = -(i/N) * (Factor-CoaxWidth) + 2.5*mm;
                #if (CoaxY < 0) #local CoaxY = 0; #end
		sphere { Coax[i] CoaxWidth strength 1 translate <-30*cm+18*mm , CoaxY + CoaxWidth, 0> }
		#local i = i + 1;
	#end

	texture { Texture }	
}
#end  // CoaxCable()


#macro Connector(Pos)
union
{
	cylinder { x*-18*mm x*18*mm 4*mm }
	difference
	{
		cylinder { z*0 z*-18*mm 4*mm }
		cylinder { z*-8*mm z*-20*mm 3.5*mm }
	}
	torus { 4.8*mm .5*mm rotate x*90 scale <1,1,3> translate z*-11*mm }
	torus { 4.8*mm .5*mm rotate x*90 scale <1,1,3> translate z*-16*mm }

	cylinder { z*0 z*-17.5*mm 2.5*mm open pigment { White*2 } }
	cylinder { z*0 z*-18*mm .5*mm }

	cylinder { z*-6*mm z*6*mm 1*mm translate x*-13*mm }
	cylinder { z*-6*mm z*6*mm 1*mm translate x*13*mm }

	torus { 4.8*mm .5*mm rotate z*90 scale <3,1,1> translate x*11*mm }
	torus { 4.8*mm .5*mm rotate z*90 scale <3,1,1> translate x*16*mm }
	torus { 2*mm .6*mm rotate z*90 scale <10,1,1> translate x*22*mm pigment { Red } finish { specular .2 } }

	texture { T_Chrome_5C }
	translate Pos
}
#end  // Connector()


// ---------------------------------------------------------------------------

// Mouse pad
#macro MousePad()
union
{
	superellipsoid
	{
		<.05,.05> scale .5
		pigment { Red }
		scale <250*mm, 1*mm, 200*mm>
		normal { bumps bump_size .1 scale .01 }
		translate y*2*mm
	}
	superellipsoid
	{
		<.05,.05> scale .5
		pigment { image_map { gif "irtc-logo.gif" once interpolate 2 } rotate x*90 translate <-.5,-.5,-.5> scale .8 }
		scale <250*mm, 1*mm, 200*mm>
		normal { bumps bump_size .1 scale .01 }
		translate y*2.001*mm
	}

	superellipsoid
	{
		<.05,.05> scale .5
		scale <250*mm, 4*mm, 200*mm>
		pigment { Gray20 }
	}
}
#end  // MousePad()


// ---------------------------------------------------------------------------

// Speaker
#macro Speaker()
union
{
	#local VentPos  = <-2.5, 7, 0> * cm;
	#local BConePos = <0, -2, 0> * cm;
	#local TConePos = <1.5, 5.5, 0> * cm;

	#local SpeakerConeTexture =
	texture
	{
		pigment { Gray10 }
		finish { diffuse .6 specular .3 }
	}

	#local GrillTex =
	texture
	{
		pigment { Black filter .8 /*.3*/ transmit .5 /*.3*/ }
		finish { diffuse .5 crand .5 specular .6 }
		normal { granite }
	}


	difference
	{
		// body
		superellipsoid { <.1,.1> scale .5 * <10, 20, 10> *cm }
		// grill
		box { <-.5,-.5,-.5> <.5,.5,.5> scale <9, 17, 2>*cm translate z*-5*cm+y*1*cm }
		// bass cone
		sphere { 0 4*cm scale <1,1,.5> translate z*-4*cm+BConePos texture { SpeakerConeTexture } }
		// treble cone
		sphere { 0 2*cm scale <1,1,.5> translate z*-4*cm+TConePos texture { SpeakerConeTexture } }
		// vent
		cylinder { 0 z*-10 1.75*cm translate VentPos pigment { Grey } }
	}
	union
	{
		torus { 4*cm 2*mm rotate x*90 translate z*-4*cm }
		sphere { 0 2.5*cm }
		sphere { 0 5*mm scale <1,1,.5> translate <-3.5, 3.5,-4>*cm texture { T_Chrome_2C } }
		sphere { 0 5*mm scale <1,1,.5> translate < 3.5, 3.5,-4>*cm texture { T_Chrome_2C } }
		sphere { 0 5*mm scale <1,1,.5> translate <-3.5,-3.5,-4>*cm texture { T_Chrome_2C } }
		sphere { 0 5*mm scale <1,1,.5> translate < 3.5,-3.5,-4>*cm texture { T_Chrome_2C } }
		texture { SpeakerConeTexture }

		translate BConePos
	}
	union
	{
		torus { 4*cm 2*mm rotate x*90 translate z*-4*cm }
		sphere { 0 2.5*cm translate z*-1*cm }
		sphere { 0 5*mm scale <1,1,.5> translate <-3.5, 3.5,-4>*cm texture { T_Chrome_2C } }
		sphere { 0 5*mm scale <1,1,.5> translate < 3.5, 3.5,-4>*cm texture { T_Chrome_2C } }
		sphere { 0 5*mm scale <1,1,.5> translate <-3.5,-3.5,-4>*cm texture { T_Chrome_2C } }
		sphere { 0 5*mm scale <1,1,.5> translate < 3.5,-3.5,-4>*cm texture { T_Chrome_2C } }
		texture { SpeakerConeTexture }
		scale <.5,.5,1>
		translate TConePos
	}

	// grill
	box { <-.5,-.5,-.5> <.5,.5,.5> scale <9, 17, .1>*cm translate z*-5+y*1*cm texture { GrillTex } }

	// vent
	torus { 1.75*cm 5*mm rotate x*90 translate z*-3.5*cm+VentPos }
	cylinder { 0 z*-3.5*cm 1.25*cm open translate VentPos }

	// controls
	cone { z*0 7*mm z*-1*cm 4*mm translate <-3, -8.5, -5>*cm }
	cone { z*0 7*mm z*-1*cm 4*mm translate <-1, -8.5, -5>*cm }
	cone { z*0 7*mm z*-1*cm 4*mm translate < 1, -8.5, -5>*cm }
	sphere { <3.5, -8.5, -5>*cm 3*mm pigment { Red*5 } no_shadow }

	pigment { White }
	finish { specular .3 }
}
#end  // Speaker()


// ---------------------------------------------------------------------------

// CDROM
#macro CDROM()
union
{
	difference
	{
		cylinder { y*.01*mm y*1*mm 6*cm }
		cylinder { y*-1*mm y*3*mm 2*cm }

		pigment { rgb <.9,.86,.82>*1.3 }
		finish { F_MetalB crand .01 }
		normal { bumps bump_size .01*mm scale .01 }
	}
	difference
	{
		cylinder { y*.01*mm y*1*mm 2*cm }
		cylinder { y*-1*mm y*3*mm 7.5*mm }
		texture { T_Glass4 }
		interior { I_Glass }
	}
	torus { 6*cm .5*mm translate y*.5*mm texture { T_Glass4 } interior { I_Glass } }

	#macro Spectrum(Angle, Tex, Rot)
	intersection
	{
		difference
		{
			cylinder { y*1.0001*mm y*1.002*mm 6*cm }
			cylinder { y*-1*mm y*3*mm 2*cm }
		}
		plane { z,0 rotate y*-Angle }
		plane { -z,0 rotate y*Angle }

		texture { Tex }
		rotate y*Rot
	}
	#end

	union
	{
		Spectrum(10, texture { pigment { gradient x color_map { [0 rgb <.94,.90,.86>*1.05 filter 1 transmit 0][.8 rgbft <1,.7,.8,1,.2>][.9 rgb <.94,.90,.86>*1.05 filter 1 transmit 0] } translate x*-.5 scale 4 } finish { F_MetalB } }, 0)
		Spectrum(10, texture { pigment { gradient x color_map { [0 rgb <.94,.90,.86>*1.05 filter 1 transmit 0][.9 rgbft <0,.9,.9,1,.2>] } translate x*-.5 scale 4 } finish { F_MetalB } }, 180)

		Spectrum(20, texture { pigment { gradient x color_map { [0 rgb <.98,.96,.94>*1.05 filter 1 transmit 0][.9 rgb <1,.96,.92> filter 1 transmit 0] } translate x*-.5 scale 4 } finish { F_MetalB } }, 90)
		Spectrum(20, texture { pigment { gradient x color_map { [0 rgb <.98,.96,.94>*1.05 filter 1 transmit 0][.9 rgb <1,.96,.92> filter 1 transmit 0] } translate x*-.5 scale 4 } finish { F_MetalB } }, -90)

		rotate y*-92
	}
}
#end  // CDROM()


#end  // ifndef
