// Monitor include file
// by Robert Fremin, d96rfr@csd.uu.se, 1999
//
// Macros:
// Monitor()
//

#ifndef (MONITOR_INC)
#declare MONITOR_INC = true;
#debug "=#= included monitor.inc =#=\n"

#version 3.1;

#include "colors.inc"
#include "units.inc"


// ---------------------------------------------------------------------------

#declare MonitorFinish =
finish { ambient .3 diffuse .6 specular .1 }

#declare MonitorScreenFinish =
finish { ambient 3 diffuse .6 specular .1 reflection .01 phong .4 phong_size 5000 }

#declare MonitorTexture =
texture
{
//	pigment { color <.8,.75,.7>*1.5 }
	pigment { rgb <.9, .9, .88> * 1.3 }
//	pigment { White }
	finish { MonitorFinish }
	normal { bumps bump_size .05 scale .1 }
}

#declare MonitorScreenTexture =
texture
{
//	pigment { image_map { gif "Newimplogo.gif" once } translate <-.5,-.5,0> scale .9 }
//	pigment { image_map { png "quake01.png" interpolate 2 once } translate <-.5,-.5,0> scale <.97,.81,1> }
	pigment { image_map { png "quake03.png" interpolate 2 once } translate <-.5,-.5,0> scale <.96,.81,1> }
	finish { MonitorScreenFinish }
}

#declare MonitorScreenBackgroundTexture =
texture
{
	pigment { color .001 }
	finish { MonitorScreenFinish }
}

#declare PowerLightTexture =
texture
{
	pigment { Green }
	finish { ambient .7 }
//	finish { diffuse .4 specular .3 reflection .1 phong 1 phong_size 50 }
}

#declare MonitorLabelTexture =
texture
{
	pigment { image_map { gif "iw_logo1.gif" once } translate <-.5,-.5,0> scale .9 }
//	pigment { Red }
	finish { MonitorFinish specular .2 reflection .1 }
}


// ---------------------------------------------------------------------------

#macro Monitor(DisplayImage)
union
{
	// Front
	union
	{
		difference
		{
			superellipsoid { <.05,.1> scale .5 scale <40*cm, 32*cm, 8*cm> }
			superellipsoid { <.01,.1> scale .25 scale <55*cm, 45*cm, 55*cm> rotate y*45 translate z*-5*cm }
			box { <-.5,-.5,-.5> <.5,.5,.5> scale <40*mm, 12*mm, 3*mm> translate <-150*mm, -135*mm, -39*mm> }
		}
		box { <-.5,-.5,-.5> <.5,.5,.5> texture { MonitorLabelTexture } scale <40*mm, 12*mm, 2*mm> translate <-150*mm, -135*mm, -39*mm> }
	}

	// Screen
	union
	{
		superellipsoid { <.2,.2> scale .5 texture { MonitorScreenBackgroundTexture } scale <35*cm, 27*cm, 3*cm> translate z*-15*mm }
                #if (DisplayImage)
		        superellipsoid { <.2,.2> scale .5 texture { MonitorScreenTexture } scale <35*cm, 27*cm, 3.001*cm> translate z*-15*mm }
                #end
	}

	// Body
	union
	{
		intersection
		{
			// Body with buttons
			union
			{
				// body
				difference
				{
					// main body
					superellipsoid { <.04,.04> scale .5 scale <36*cm, 32*cm, 30*cm> }
					// button hole
					superellipsoid { <.05,.05> scale .5 scale <28*mm, 20*mm, 10*mm> translate <13*cm, -14*cm, -15*cm> }
					// lid hole
					superellipsoid { <.05,.05> scale .5 scale <135*mm, 34*mm, 20*mm> translate <-7*cm, -14.4*cm, -15*cm> }
				}
				union
				{
					intersection
					{
						// main body
						superellipsoid { <.05,.05> scale .5 scale <36*cm, 32*cm, 30*cm> }
						// lid
						superellipsoid { <.05,.05> scale .5 scale <132*mm, 32*mm, 18*mm> translate <-7*cm, -14.4*cm, -15*cm> }
					}
					union
					{
						#local i = 3*mm;
						sphere { <-i, -i, 0> 1*mm }
						sphere { <-i,  0, 0> 1*mm }
						sphere { <-i,  i, 0> 1*mm }
						sphere { < 0, -i, 0> 1*mm }
						sphere { < 0,  0, 0> 1*mm }
						sphere { < 0,  i, 0> 1*mm }
						sphere { < i, -i, 0> 1*mm }
						sphere { < i,  0, 0> 1*mm }
						sphere { < i,  i, 0> 1*mm }
						translate <-13*cm, -13.4*cm, -15*cm>
					}
				}
				// Power-switch
				union
				{
					superellipsoid { <.05,.05> scale .5 scale <25*mm, 18*mm, 10*mm> }
					torus { 3*mm .75*mm rotate x*90 translate z*-5*mm }
					cylinder { y*-2*mm y*2*mm .75*mm translate z*-5*mm }

					// Power-LED
					box { <-.5,-.5,-.5> <.5,.5,.5> scale <1*mm, 8*mm, 1*mm> translate <8*mm, -3.5*mm, -5*mm> texture { PowerLightTexture } }

					translate <13*cm, -14*cm, -14.6*cm>
				}

				rotate x*5
				translate <0, -5*cm, 14*cm>
			}
			plane { -y, 0 rotate x*-20 translate y*-20*cm }
		}

		// bottom body
		superellipsoid { <.05,.05> scale .5 scale <34*cm, 10*cm, 27*cm> rotate x*-7 translate <0, -13*cm, 14*cm> }

		box { <-.5,-.5,-.5> <.5,.5,.5> scale <28*cm, 5*cm, 22*cm> rotate x*14 translate <0, 10.5*cm, 10*cm> }
		sphere { 0 10*cm scale <1,.75,1> rotate x*-20 translate <0, -15*cm, 13*cm> }
	}

	// Stand
	union
	{
		cone { y*0 10*cm y*2 9*cm }
		prism
		{
			cubic_spline 0*mm, -20*mm, 9,
			<-30*cm,  10*cm>,
			<-10*cm,  15*cm>,
			< 10*cm,  15*cm>,
			< 15*cm, -15*cm>,
			<  0*cm, -14*cm>,
			<-15*cm, -15*cm>,
			<-10*cm,  15*cm>,
			< 10*cm,  15*cm>,
			< 30*cm,  10*cm>
		}
		translate <0, -22*cm, 13*cm>
	}

	texture { MonitorTexture }

	translate y*24*cm	// level base at 0
}
#end  // Monitor()

#end  // ifndef
