// Mouse include file
// by Robert Fremin, d96rfr@csd.uu.se, 1999
//
// Macros:
// Mouse()
//

#ifndef (MOUSE_INC)
#declare MOUSE_INC = true;
#debug "=#= included mouse.inc =#=\n"

#version 3.1;

#include "colors.inc"
#include "units.inc"


// ---------------------------------------------------------------------------

#declare mousebody =
intersection
{
	sphere { 0 2*cm }
	cylinder { y*-1*cm y*3*cm 1.98*cm }
	scale <1,1,2>
}

#declare mousebuttonbody =
intersection
{
	object { mousebody }
	box { <-3*cm, .5*cm, 1*cm> <3*cm, 3*cm, 3*cm> }
}

#declare mousebuttons =
difference
{
	object { mousebuttonbody }
//	box { <-.05*cm, 0, 0*cm> <.05*cm, 3*cm, 3*cm> }	// 2-button
	box { <-.9*cm, 0, 0*cm> <-1*cm, 3*cm, 3*cm> }
	box { <.9*cm, 0, 0*cm> <1*cm, 3*cm, 3*cm> }
}

// mouse
#macro Mouse()
union
{
	object { mousebuttons }
	difference
	{
		object { mousebody }
		box { <-3*cm, .4*cm, .8*cm> <3*cm, 3*cm, 3*cm> }
		box { <-5*cm, .1*cm, -5*cm> <5*cm, 0*cm, 5*cm> }
	}
	translate y*5*mm

	clipped_by { plane { -y,0  } }

	scale <1, .7, .7> * 2

//	texture { T_Chrome_4A }
	pigment { White*1.2 }
	finish { specular .05 phong .05 phong_size 80 }
	normal { granite bump_size .5*mm }
}
#end  // Mouse()


#end  // ifndef
