#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A row of books, suitable for use with the Bookshelf model.
 *
 * Scale is 1 POVunit == 1 inch.
 */

#if (TestRender)
#include "colors.inc"
#include "golds.inc"
#include "booktextures.inc"

camera {
	location <22,7,25>
	look_at <22,7,0>
}

light_source {
	<0, 5, 20>
	color Gray50
}
light_source {
	<-10, 5, 10>
	color Gray50
}
light_source {
	< 10, 5, 10>
	color Gray50
}
light_source {
	< 36, 50, 0>
	color Gray50
}
light_source {
	< 18, 50, 0>
	color Gray50
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { White }
#end


#local nBooks = 22;

// height, width, fontSize
#local Dimensions = array[nBooks][3] {
	{15,   3, 1.0}		// Witches Broomstick Manual
	{16,   3, 1.0}		// Care and Feeding of Flying Carpets
	{18,   4, 2.2}		// D Gentry
	{14,   3, 1.0}		// Exorcism on a Budget
	{15,   2, 1.0}		// How to Contact Elvis
	{13,   5, 1.0}		// 1001 Diseases
	{15,   3, 1.1}		// Modern Herbal Remedies
	{14,   3, 1.1}		// Make The Concoction
	{12,   2, 1.0}		// Orc Law Dictionary
	{16,   4, 1.0}		// Construction, A Goblin Perspective
	{15.5, 4, 1.0}		// A Necromancers Study Guide
	{15,   5, 1.5}		// Manual of Golems
	{14.5, 3, 1.0}		// Rare Mythology and Lore
	{15,   3, 1.0}		// The Book of Nyon the Mad
	{16,   2, 1.0}		// Monster Manual
	{16,   2, 1.0}		// Fiend Folio
	{16,   2, 1.0}		// Unearthed Arcana
	{15,   5, 1.5}		// Dragon Anatomy
	{17,   2, 1.0}		// Dungeon Keeper Tips and Tricks
	{18,   3, 1.05}		// Demons and Devilkin
	{16,   5, 2.0}		// Fairy Songs
	{15,   4, 1.2}		// Endgame
}

// cover texture, title + band texture
#local Textures = array[nBooks][2] {
	{texture{T_agedleather}, texture {T_Gold_3B} } // Witches Broomstick Manual
	{texture{T_brownleather}, texture {T_Gold_1B} } // Care and Feeding of Flying Carpets
	{texture{T_signature}, texture {T_Gold_1A} } // D Gentry
	{texture{T_blackleather}, texture {T_blackleather} } // Exorcism on a Budget
	{texture{T_agedleather}, texture {T_Gold_5C} } // How to Contact Elvis
	{texture{T_ironcrown}, texture {T_ironcrown} } // 1001 Diseases
	{texture{T_darkgreenleather1}, texture {T_Gold_1A} } // Modern Herbal Remedies
	{texture{T_redleather}, texture {T_Gold_1A} } // Make The Concoction
	{texture{T_blackleather}, texture {T_Gold_2C} } // Orc Law Dictionary
	{texture{T_brownleather}, texture {T_Gold_1A} } // Construction, A Goblin Perspective
	{texture{T_ironcrown}, texture {T_Gold_1A} } // A Necromancers Study Guide
	{texture{T_agedleather}, texture {T_Gold_5A} } // Manual of Golems
	{texture{T_darkredleather}, texture {T_Gold_1A} } // Rare Mythology and Lore
	{texture{T_bloodleather}, texture {T_Gold_1A} } // The Book of Nyon the Mad
	{texture{T_agedleather}, texture {T_Gold_2C} } // Monster Manual
	{texture{T_agedleather}, texture {T_Gold_2C} } // Fiend Folio
	{texture{T_agedleather}, texture {T_Gold_1A} } // Unearthed Arcana
	{texture{T_bloodleather}, texture {T_Gold_1A} } // Dragon Anatomy
	{texture{T_blackleather}, texture {T_Gold_1A} } // Dungeon Keeper Tips and Tricks
	{texture{T_darkbrownleather}, texture {T_Gold_1A} } // Demons and Devilkin
	{texture{T_darkgreenleather}, texture {T_Gold_1A} } // Fairy Songs
	{texture{T_darkredleather}, texture {T_Gold_1A} } // Endgame
}

// book title, font
#local Titles = array[nBooks][2] {
	{"Witches Broomstick Manual", "TIMROM.TTF"}
	{"Care and Feeding of Flying Carpets", "TIMROM.TTF"}
	{"D  Gentry", "TIMROM.TTF"}
	{"Exorcism on a Budget", "TIMROM.TTF"}
	{"How to Contact Elvis", "TIMROM.TTF"}
	{"1001 Diseases", "TIMROM.TTF"}
	{"Modern Herbal Remedies", "TIMROM.TTF"}
	{"Make The Concoction", "TIMROM.TTF"}
	{"Orc Law Dictionary", "TIMROM.TTF"}
	{"Construction, A Goblin Perspective", "TIMROM.TTF"}
	{"A Necromancers Study Guide", "TIMROM.TTF"}
	{"Manual of Golems", "TIMROM.TTF"}
	{"Rare Mythology and Lore", "TIMROM.TTF"}
	{"The Book of Nyon the Mad", "TIMROM.TTF"}
	{"Monster Manual", "TIMROM.TTF"}
	{"Fiend Folio", "CRYSTAL.TTF"}
	{"Unearthed Arcana", "TIMROM.TTF"}
	{"Dragon Anatomy", "TIMROM.TTF"}
	{"Dungeon Keeper Tips and Tricks", "TIMROM.TTF"}
	{"Demons and Devilkin", "TIMROM.TTF"}
	{"Fairy Songs", "TIMROM.TTF"}
	{"Endgame", "TIMROM.TTF"}
}

// translation for the titles
#local TitleTrans = array[nBooks] {
	<0.3, 13.5, 0.55>	// Witches Broomstick Manual
	<0.3, 15.2, 0.55>	// Care and Feeding of Flying Carpets
	<0.45, 13.8, 0.68>	// D Gentry
	<0.3, 11, 0.55>		// Exorcism on a Budget
	<0.3, 11.6, 0.55>	// How to Contact Elvis
	<0.3, 9.5, 0.55>	// 1001 Diseases
	<0.3, 13, 0.55>		// Modern Herbal Remedies
	<0.3, 11.1, 0.55>	// Make The Concoction
	<0.3, 10, 0.55>		// Orc Law Dictionary
	<0.3, 15.2, 0.55>	// Construction, A Goblin Perspective
	<0.3, 14, 0.55>		// A Necromancers Study Guide
	<0.3, 13.0, 0.55>	// Manual of Golems
	<0.3, 12.5, 0.55>	// Rare Mythology and Lore
	<0.3, 13.2, 0.55>	// The Book of Nyon the Mad
	<0.3, 11, 0.55>		// Monster Manual
	<0.3, 10.1, 0.55>	// Fiend Folio
	<0.3, 11, 0.55>		// Unearthed Arcana
	<0.3, 12.8, 0.55>	// Dragon Anatomy
	<0.3, 15.4, 0.55>	// Dungeon Keeper Tips and Tricks
	<0.3, 13.5, 0.55>	// Demons and Devilkin
	<0.3, 12.5, 0.55>	// Fairy Songs
	<0.3, 9.5, 0.55>	// Endgame
}

// decoration
#local Decorations = array[nBooks][4] {
	{0, 0, 0, 0}		// Witches Broomstick Manual
	{0, 0, 0, 0}		// Care and Feeding of Flying Carpets
	{0, 0, 0, 0}		// D Gentry
	{0, 0, 0, 0}		// Exorcism on a Budget
	{14, 1, 0, 0}		// How to Contact Elvis
	{0, 0, 0, 0}		// 1001 Diseases
	{0, 0, 0, 0}		// Modern Herbal Remedies
	{0, 0, 0, 0}		// Make The Concoction
	{0, 0, 0, 0}		// Orc Law Dictionary
	{0, 0, 0, 0}		// Construction, A Goblin Perspective
	{0, 0, 0, 0}		// A Necromancers Study Guide
	{0, 0, 0, 0}		// Manual of Golems
	{0, 0, 0, 0}		// Rare Mythology and Lore
	{0, 0, 0, 0}		// The Book of Nyon the Mad
	{15, 14.7, 1, 1.3}	// Monster Manual
	{15, 14.7, 1, 1.3}	// Fiend Folio
	{15, 14.7, 1, 1.3}	// Unearthed Arcana
	{0, 0, 0, 0}		// Dragon Anatomy
	{0, 0, 0, 0}		// Dungeon Keeper Tips and Tricks
	{0, 0, 0, 0}		// Demons and Devilkin
	{0, 0, 0, 0}		// Fairy Songs
	{0, 0, 0, 0}		// Endgame
}

#declare Books6 = union {

#local X = 36;
#local N = 0;

#while ( N < nBooks )
	#local Height = Dimensions[N][0];
	#local Width = Dimensions[N][1];
	#local Width2 = Width/2;
	#local Length = 10.0;
	#local T_cover = Textures[N][0]

	union {
		difference {	// the spine
			cylinder {<0,0,0>, <0,Height,0>, (Width2) }
			cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2) }
			box { <-Width,-1,-Width>, <Width,Height+1,0> }
			scale <1, 1, 0.5/Width2>
		}
		difference {
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25 }
			cylinder {<-Width,-1,-0.1>, <-Width,Height+1,-0.1>, 0.15}
			box { <-Width-1,-1,-Width>, <-Width,Height+1,Width> }
			scale <0.5,1,1>
		}
		difference {
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25}
			cylinder {<Width,-1,-0.1>, <Width,Height+1,-0.1>, 0.15}
			box { <Width,-1,-Width>, <Width+1,Height+1,Width> }
			scale <0.5,1,1>
		}

		// the covers
		box {<-Width2,0,-Length>,<-Width2+0.1,Height,-0.2>}
		box {<Width2,0,-Length>,<Width2-0.1,Height,-0.2>}

		// the paper
		difference {
			box { <-Width2+0.01, 0.25, -Length+0.25>,
					<Width2-0.01, Height-0.25, 1>
			}
			difference {
				box { <-Width, -1, 0>, <Width, Height+1, 3> }
				cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2)
					scale <1,1,0.5/Width2>
				}
			}
			cylinder {<0,-1,2*(-Length+0.25)>, <0,Height+1,2*(-Length+0.25)>,
				((Width-0.25)/2)
				scale <1,1, 0.5>
			}
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			texture { T_paper }
		}

		#local T_title = Textures[N][1]
		#local Title = Titles[N][0]
		#local Font = Titles[N][1]
		#local Trans = TitleTrans[N];
		#local FontSize = Dimensions[N][2];

		// the title
		text { ttf Font Title 0.2, 0
			rotate <0,180,90>
			scale <FontSize, FontSize, 1.0>
			translate Trans
			texture { T_title }
		}

		#if ( Decorations[N][0] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][0],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][1] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][1],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][2] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][2],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][3] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][3],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end

		texture { T_cover }

		translate <-Width2, 0, 0>	// left edge against Y axis

		translate <X, 0, 0>
	}

	#local N = N + 1;
	#local X = X - Width;
#end

}

#if (TestRender)
object { Books6 }
#end

#version Temp_Vers;
