#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A row of books, suitable for use with the Bookshelf model.
 * This one is mostly obscured, so far less effort was put into
 * it.
 *
 * Scale is 1 POVunit == 1 inch.
 */

#if (TestRender)
#include "colors.inc"
#include "golds.inc"
#include "booktextures.inc"

camera {
	location <-22,7,25>
	look_at <-22,7,0>
}

light_source {
	<0, 5, 20>
	color Gray50
}
light_source {
	<-10, 5, 10>
	color Gray50
}
light_source {
	< 10, 5, 10>
	color Gray50
}
light_source {
	< 36, 50, 0>
	color Gray50
}
light_source {
	< 18, 50, 0>
	color Gray50
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { White }
#end


#declare nBooks = 18;

// height, width, fontSize
#declare Dimensions = array[nBooks][3] {
	{15,   4, 1.0}		// No Title
	{16,   4, 1.0}		// No Title
	{18,   4, 1.0}		// No Title
	{14,   4, 1.0}		// No Title
	{15,   4, 1.0}		// No Title
	{13,   4, 1.0}		// No Title
	{15,   4, 1.0}		// No Title
	{14,   4, 1.0}		// No Title
	{12,   4, 1.0}		// No Title
	{16,   4, 1.0}		// No Title
	{15,   4, 1.0}		// No Title
	{15,   4, 1.0}		// No Title
	{14,   4, 1.0}		// SSCOP
	{15,   4, 1.0}		// Q.2931
	{16,   4, 1.0}		// POTS
	{16,   4, 1.0}		// SS7
	{16,   4, 2.0}		// Sonet
	{18,   4, 1.0}		// The Care and Feeding of ATM
}

// cover texture, title + band texture
#declare Textures = array[nBooks][2] {
	{texture{T_agedleather}, texture {T_Gold_3B} } // No Title
	{texture{T_brownleather}, texture {T_Gold_1B} } // No Title
	{texture{T_darkbrownleather}, texture {T_Gold_1A} } // No Title
	{texture{T_blackleather}, texture {T_blackleather} } // No Title
	{texture{T_agedleather}, texture {T_Gold_5C} } // No Title
	{texture{T_ironcrown}, texture {T_ironcrown} } // No Title
	{texture{T_darkgreenleather}, texture {T_Gold_1A} } // No Title
	{texture{T_redleather}, texture {T_Gold_1A} } // No Title
	{texture{T_blackleather}, texture {T_Gold_2C} } // No Title
	{texture{T_brownleather}, texture {T_Gold_1A} } // No Title
	{texture{T_ironcrown}, texture {T_Gold_1A} } // No Title
	{texture{T_agedleather}, texture {T_Gold_5A} } // No Title
	{texture{T_darkredleather}, texture {T_Gold_1A} } // SSCOP
	{texture{T_bloodleather}, texture {T_Gold_1A} } // Q.2931
	{texture{T_agedleather}, texture {T_Gold_2C} } // POTS
	{texture{T_darkgreenleather}, texture {T_Gold_1A} } // SS7
	{texture{T_agedleather}, texture {T_Gold_1A} } // Sonet
	{texture{T_bloodleather}, texture {T_Gold_1A} } // The Care and Feeding of ATM
}

// book title, font
#declare Titles = array[nBooks][2] {
	{"No Title", "TIMROM.TTF"}
	{"No Title", "TIMROM.TTF"}
	{"No Title", "TIMROM.TTF"}
	{"No Title", "TIMROM.TTF"}
	{"No Title", "TIMROM.TTF"}
	{"No Title", "TIMROM.TTF"}
	{"No Title", "TIMROM.TTF"}
	{"No Title", "TIMROM.TTF"}
	{"No Title", "TIMROM.TTF"}
	{"No Title", "TIMROM.TTF"}
	{"No Title", "TIMROM.TTF"}
	{"No Title", "CRYSTAL.TTF"}
	{"SSCOP", "TIMROM.TTF"}
	{"Q.2931", "TIMROM.TTF"}
	{"POTS", "TIMROM.TTF"}
	{"SS7", "TIMROM.TTF"}
	{"Sonet", "TIMROM.TTF"}
	{"The Care and Feeding of ATM", "TIMROM.TTF"}
}

// translation for the titles
#declare TitleTrans = array[nBooks] {
	<0.3, 13.5, 0.55>	// No Title
	<0.3, 15.2, 0.55>	// No Title
	<0.45, 13.8, 0.60>	// No Title
	<0.3, 11, 0.55>		// No Title
	<0.3, 11.6, 0.55>	// No Title
	<0.3, 9.5, 0.55>	// No Title
	<0.3, 13, 0.55>		// No Title
	<0.3, 11.1, 0.55>	// No Title
	<0.3, 10, 0.55>		// No Title
	<0.3, 15.2, 0.55>	// No Title
	<0.3, 9, 0.55>		// No Title
	<0.3, 9.0, 0.55>	// No Title
	<0.3, 8.5, 0.55>	// SSCOP
	<0.3, 9.2, 0.55>	// Q.2931
	<0.3, 9, 0.55>		// POTS
	<0.3, 8.6, 0.55>	// SS7
	<0.4, 10.5, 0.55>	// Sonet
	<0.3, 14.9, 0.55>	// The Care and Feeding of ATM
}

// decoration
#declare Decorations = array[nBooks][4] {
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// No Title
	{0, 0, 0, 0}		// SSCOP
	{0, 0, 0, 0}		// Q.2931
	{0, 0, 0, 0}		// POTS
	{0, 0, 0, 0}		// SS7
	{0, 0, 0, 0}		// Sonet
	{0, 0, 0, 0}		// The Care and Feeding of ATM
}

#declare Books7 = union {

#declare X = 36;
#declare N = 0;

#while ( N < nBooks )
	#declare Height = Dimensions[N][0];
	#declare Width = Dimensions[N][1];
	#declare Width2 = Width/2;
	#declare Length = 10.0;
	#declare T_cover = Textures[N][0]

	union {
		difference {	// the spine
			cylinder {<0,0,0>, <0,Height,0>, (Width2) }
			cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2) }
			box { <-Width,-1,-Width>, <Width,Height+1,0> }
			scale <1, 1, 0.5/Width2>
		}
		difference {
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25 }
			cylinder {<-Width,-1,-0.1>, <-Width,Height+1,-0.1>, 0.15}
			box { <-Width-1,-1,-Width>, <-Width,Height+1,Width> }
			scale <0.5,1,1>
		}
		difference {
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25}
			cylinder {<Width,-1,-0.1>, <Width,Height+1,-0.1>, 0.15}
			box { <Width,-1,-Width>, <Width+1,Height+1,Width> }
			scale <0.5,1,1>
		}

		// the covers
		box {<-Width2,0,-Length>,<-Width2+0.1,Height,-0.2>}
		box {<Width2,0,-Length>,<Width2-0.1,Height,-0.2>}

		// the paper
		difference {
			box { <-Width2+0.01, 0.25, -Length+0.25>,
					<Width2-0.01, Height-0.25, 1>
			}
			difference {
				box { <-Width, -1, 0>, <Width, Height+1, 3> }
				cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2)
					scale <1,1,0.5/Width2>
				}
			}
			cylinder {<0,-1,2*(-Length+0.25)>, <0,Height+1,2*(-Length+0.25)>,
				((Width-0.25)/2)
				scale <1,1, 0.5>
			}
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			texture { T_paper }
		}

		#declare T_title = Textures[N][1]
		#declare Title = Titles[N][0]
		#declare Font = Titles[N][1]
		#declare Trans = TitleTrans[N];
		#declare FontSize = Dimensions[N][2];

		// the title
		text { ttf Font Title 0.2, 0
			rotate <0,180,90>
			scale <FontSize, FontSize, 1.0>
			translate Trans
			texture { T_title }
		}

		#if ( Decorations[N][0] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][0],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][1] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][1],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][2] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][2],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][3] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][3],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end

		texture { T_cover }

		translate <-Width2, 0, 0>	// left edge against Y axis

		translate <X, 0, 0>
	}

	#declare N = N + 1;
	#declare X = X - Width;
#end

}

#if (TestRender)
object { Books7 }
#end

#version Temp_Vers;
