#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A row of books, suitable for use with the Bookshelf model.
 * These books concern technical topics. Sort of. The titles are
 * written in a runic font, no-one save Edwin can read them.
 *
 * Scale is 1 POVunit == 1 inch.
 */

#if (TestRender)
#include "colors.inc"
#include "golds.inc"
#include "booktextures.inc"

camera {
	location <-25,7,25>
	look_at <-25,7,0>
}

light_source {
	<0, 5, 20>
	color Gray50
}
light_source {
	<-10, 5, 10>
	color Gray50
}
light_source {
	< 10, 5, 10>
	color Gray50
}
light_source {
	< 36, 50, 0>
	color Gray50
}
light_source {
	< 18, 50, 0>
	color Gray50
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { White }
#end


#declare nBooks = 20;

// height, width, fontSize
#declare Dimensions = array[nBooks][3] {
	{17,   3, 1.0}		// Chemistry
	{15,   4, 1.5}		// Biology
	{19,   3, 1.0}		// Gray's Anatomy
	{15,   3, 1.0}		// Immunology
	{14,   4, 1.0}		// Psychology
	{17,   3, 1.0}		// Metallurgy
	{15,   4, 1.0}		// Materials Science
	{14,   5, 2.0}		// Physics
	{19,   4, 1.7}		// Calculus
	{17,   3, 1.0}		// Trigonometry
	{16,   2, 1.0}		// Geometry
	{13,   2, 1.0}		// Algebra
	{14,   3, 1.0}		// Electronics
	{15,   4, 1.0}		// Transistors
	{18,   6, 1.3}		// Quantum Mechanics
	{17,   4, 1.5}		// Relativity
	{18,   4, 2.0}		// Fusion
	{14,   3, 1.0}		// Geology
	{14,   3, 1.0}		// Meteorology
	{15,   5, 1.2}		// Pharmacology
}

// cover texture, title + band texture
#declare Textures = array[nBooks][2] {
	{texture{T_darkredleather}, texture {T_Gold_3B} } // Chemistry
	{texture{T_redleather}, texture {T_Gold_1B} } // Biology
	{texture{T_agedleather}, texture {T_Gold_1A} } // Gray's Anatomy
	{texture{T_darkgreenleather}, texture {T_Gold_1A} } // Immunology
	{texture{T_agedleather}, texture {T_Gold_5C} } // Psychology
	{texture{T_brownleather}, texture {T_Gold_1A} } // Metallurgy
	{texture{T_darkbrownleather}, texture {T_Gold_1A} } // Materials Science
	{texture{T_darkbrownleather2}, texture {T_Gold_1A} } // Physics
	{texture{T_blackleather}, texture {T_Gold_2C} } // Calculus
	{texture{T_brownleather}, texture {T_Gold_1A} } // Trigonometry
	{texture{T_darkcherryleather}, texture {T_Gold_1A} } // Geometry
	{texture{T_agedleather}, texture {T_Gold_5A} } // Algebra
	{texture{T_darkredleather}, texture {T_Gold_1A} } // Electronics
	{texture{T_darkcherryleather}, texture {T_Gold_1A} } // Transistors
	{texture{T_darkbrownleather1}, texture {T_Gold_2C} } // Quantum Mechanics
	{texture{T_darkgreenleather}, texture {T_Gold_1A} } // Relativity
	{texture{T_darkblueleather}, texture {T_Gold_1A} } // Fusion
	{texture{T_darkbrownleather}, texture {T_Gold_1A} } // Geology
	{texture{T_darkbrownleather1}, texture {T_Gold_1A} } // Meteorology
	{texture{T_verydarkblueleather}, texture {T_Gold_1A} } // Pharmacology
}

// book title, font
#declare Titles = array[nBooks][2] {
	{"Chemistry", "MERO_DEM.TTF"}
	{"Biology", "MERO_DEM.TTF"}
	{"Gray's Anatomy", "MERO_DEM.TTF"}
	{"Immunology", "MERO_DEM.TTF"}
	{"Psychology", "MERO_DEM.TTF"}
	{"Metallurgy", "MERO_DEM.TTF"}
	{"Materials Science", "MERO_DEM.TTF"}
	{"Physics", "MERO_DEM.TTF"}
	{"Calculus", "MERO_DEM.TTF"}
	{"Trigonometry", "MERO_DEM.TTF"}
	{"Geometry", "MERO_DEM.TTF"}
	{"Algebra", "MERO_DEM.TTF"}
	{"Electronics", "MERO_DEM.TTF"}
	{"Transistors", "MERO_DEM.TTF"}
	{"Quantum Mechanics", "MERO_DEM.TTF"}
	{"Relativity", "MERO_DEM.TTF"}
	{"Fusion", "MERO_DEM.TTF"}
	{"Geology", "MERO_DEM.TTF"}
	{"Meteorology", "MERO_DEM.TTF"}
	{"Pharmacology", "MERO_DEM.TTF"}
}

// translation for the titles
#declare TitleTrans = array[nBooks] {
	<0.3, 11.25, 0.55>	// Chemistry
	<0.3, 11, 0.55>		// Biology
	<0.3, 15, 0.60>		// Gray's Anatomy
	<0.3, 10.5, 0.55>	// Immunology
	<0.3, 10, 0.55>		// Psychology
	<0.3, 11, 0.55>		// Metallurgy
	<0.3, 13.5, 0.55>	// Materials Science
	<0.55, 11.5, 0.55>	// Physics
	<0.5, 13, 0.55>		// Calculus
	<0.3, 13, 0.55>		// Trigonometry
	<0.3, 10.5, 0.55>	// Geometry
	<0.3, 8.5, 0.55>	// Algebra
	<0.3, 10.5, 0.55>	// Electronics
	<0.3, 12, 0.55>		// Transistors
	<0.5, 16.2, 0.55>	// Quantum Mechanics
	<0.4, 13.5, 0.55>	// Relativity
	<0.6, 12.6, 0.55>	// Fusion
	<0.3, 9.4, 0.55>	// Geology
	<0.3, 10, 0.55>		// Meteorology
	<0.4, 12.5, 0.55>	// Pharmacology
}

// decoration
#declare Decorations = array[nBooks][4] {
	{1, 4, 13, 16}		// Chemistry
	{0, 0, 0, 0}		// Biology
	{1, 2, 17, 18}		// Gray's Anatomy
	{0, 0, 0, 0}		// Immunology
	{0, 0, 0, 0}		// Psychology
	{0, 0, 0, 0}		// Metallurgy
	{0, 0, 0, 0}		// Materials Science
	{0, 0, 0, 0}		// Physics
	{1.1, 0, 0, 17.9}	// Calculus
	{1, 3, 14, 16}		// Trigonometry
	{0, 0, 0, 0}		// Geometry
	{0, 0, 0, 0}		// Algebra
	{0, 0, 0, 0}		// Electronics
	{0, 0, 0, 0}		// Transistors
	{0, 0, 0, 0}		// Quantum Mechanics
	{0, 0, 0, 0}		// Relativity
	{0, 0, 0, 0}		// Fusion
	{0, 0, 0, 0}		// Geology
	{0, 0, 0, 0}		// Meteorology
	{0, 0, 0, 0}		// Pharmacology
}

#declare Books9 = union {

#declare X = 36;
#declare N = 0;

#while ( N < nBooks )
	#declare Height = Dimensions[N][0];
	#declare Width = Dimensions[N][1];
	#declare Width2 = Width/2;
	#declare Length = 10.0;
	#declare T_cover = Textures[N][0]

	union {
		difference {	// the spine
			cylinder {<0,0,0>, <0,Height,0>, (Width2) }
			cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2) }
			box { <-Width,-1,-Width>, <Width,Height+1,0> }
			scale <1, 1, 0.5/Width2>
		}
		difference {
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25 }
			cylinder {<-Width,-1,-0.1>, <-Width,Height+1,-0.1>, 0.15}
			box { <-Width-1,-1,-Width>, <-Width,Height+1,Width> }
			scale <0.5,1,1>
		}
		difference {
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25}
			cylinder {<Width,-1,-0.1>, <Width,Height+1,-0.1>, 0.15}
			box { <Width,-1,-Width>, <Width+1,Height+1,Width> }
			scale <0.5,1,1>
		}

		// the covers
		box {<-Width2,0,-Length>,<-Width2+0.1,Height,-0.2>}
		box {<Width2,0,-Length>,<Width2-0.1,Height,-0.2>}

		// the paper
		difference {
			box { <-Width2+0.01, 0.25, -Length+0.25>,
					<Width2-0.01, Height-0.25, 1>
			}
			difference {
				box { <-Width, -1, 0>, <Width, Height+1, 3> }
				cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2)
					scale <1,1,0.5/Width2>
				}
			}
			cylinder {<0,-1,2*(-Length+0.25)>, <0,Height+1,2*(-Length+0.25)>,
				((Width-0.25)/2)
				scale <1,1, 0.5>
			}
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			texture { T_paper }
		}

		#declare T_title = Textures[N][1]
		#declare Title = Titles[N][0]
		#declare Font = Titles[N][1]
		#declare Trans = TitleTrans[N];
		#declare FontSize = Dimensions[N][2];

		// the title
		text { ttf Font Title 0.2, 0
			rotate <0,180,90>
			scale <FontSize, FontSize, 1.0>
			translate Trans
			texture { T_title }
		}

		#if ( Decorations[N][0] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][0],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][1] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][1],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][2] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][2],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][3] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][3],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end

		texture { T_cover }

		translate <-Width2, 0, 0>	// left edge against Y axis

		translate <X, 0, 0>
	}

	#declare N = N + 1;
	#declare X = X - Width;
#end

}

#if (TestRender)
object { Books9 }
#end

#version Temp_Vers;
