#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * The Mana Compass. A gold pocket compass which points to the nearest
 * Earth Node. If you don't know what this means, you obviously
 * don't play Rolemaster.
 *
 * scale is 1 POVunit == 1 inch
 */

#if (TestRender)
#include "colors.inc"
#include "golds.inc"

camera {
	location <0,5,0>
	look_at <0,0,0>
}

light_source {
	<0, 20, -20>
	color White
}

light_source {
	<-10, 4, -10>
	color White
}

light_source {
	<0, 10, 0>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

//plane {
//	<0,1,0>, 0
//	pigment { Green }
//}
#end

#declare T_White_Paint = texture {
	pigment { White }
	finish {
		brilliance 0.5
	}
}

#declare T_Black_Metal  =  texture {
	pigment { Black }
	finish {
		metallic
		ambient 0.2
		diffuse 0.65
		reflection 0.1
		brilliance 0.4
	}
}

#declare T_Compass_Gold = texture { T_Gold_1A }

#declare M_Compass_Glass = material {
	texture {
		pigment { color rgbf<1.0, 1.0, 1.0, 0.95> }
		finish  {
			ambient 0.1
			diffuse 0.1
			reflection 0.1
			specular 0.8
			roughness 0.003
			phong 0.1
			phong_size 400
		}
	}
	interior {
		ior 1.01
	}
}

#declare Mana_Compass = merge {
	difference { // the compass body
		merge {
			torus { 2.0, 0.25
				translate <0,0.25,0>
			}
			cylinder {<0,0,0>, <0,0.5,0>, 2.0 }
		}
		cylinder { <0,0.24,0>, <0,1.0,0>, 1.9 }
		texture { T_Compass_Gold }
	}

	// the clasp
	cylinder {
		<2.1,0.25,0>, <2.35,0.25,0>, 0.1
		texture { T_Compass_Gold }
	}
	sphere { <2.35,0.25,0>, 0.15
		texture { T_Compass_Gold }
	}
	torus { 0.5,0.1
		scale <0.6,1,1>
		translate <0.3,0,0>
		rotate -z*20
		translate <2.4,0.25,0>
		texture { T_Compass_Gold }
	}

	// the white paint on the interior
	cylinder { <0,0.24,0>, <0,0.25,0>, 2.01
		texture { T_White_Paint }
	}

	difference { // the degree markings
		merge {
			box { <-1.85, 0.1, -0.03>, <+1.85, 0.26, +0.03> rotate y*0}
			box { <-1.85, 0.1, -0.03>, <+1.85, 0.26, +0.03> rotate y*30 }
			box { <-1.85, 0.1, -0.03>, <+1.85, 0.26, +0.03> rotate y*60 }
			box { <-1.85, 0.1, -0.03>, <+1.85, 0.26, +0.03> rotate y*90 }
			box { <-1.85, 0.1, -0.03>, <+1.85, 0.26, +0.03> rotate y*120 }
			box { <-1.85, 0.1, -0.03>, <+1.85, 0.26, +0.03> rotate y*150 }
		}
		cylinder { <0,0,0>, <0,1,0>, 1.5 }

		texture { T_Black_Metal }
	}

	// the nub for the compass needle to float on
	cone { <0,0.24,0>, 0.25
			<0,0.475,0>, 0
		texture { T_Black_Metal }
	}

	// the needle
	merge {
		box { <-1.1,0.4,-0.05>, <+1,0.45,+0.05> }
		box { <0,0.4,-0.04>, <-0.4,0.45,+0.04>
			rotate y*40
			translate <-1.1,0,0>
		}
		box { <0,0.4,-0.04>, <-0.4,0.45,+0.04>
			rotate -y*40
			translate <-1.1,0,0>
		}
		box { <0,0.4,-0.04>, <-0.4,0.45,+0.04>
			rotate y*40
			translate <-0.86,0,0>
		}
		box { <0,0.4,-0.04>, <-0.4,0.45,+0.04>
			rotate -y*40
			translate <-0.86,0,0>
		}
		text { ttf "TIMROM.TTF" "M" 0.05, 0
			rotate <90,0,0>
			scale <0.7,1,0.7>
			translate <0.93,0.45,-0.2>
		}

		// the needle can rotate on its axis here
		rotate -y*18

		texture { T_Black_Metal }
	}

#ifndef (Quick)
	// the glass on top
	intersection {
		sphere { <0.0,0>, 2.0
			scale <1,0.1,1>
			translate <0,0.5,0>
		}
		box { <-2,0.495,-2>, <2,2,2> }
		material { M_Compass_Glass }
	}
#end
}


#if (TestRender)
object { Mana_Compass }
#end
#version Temp_Vers;
