#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A semi-accurate model of a Cray-1 supercomputer, circa 1976.
 * Unit is roughly 4 feet in diameter, 8 feet tall.
 * It is modeled sitting on the XZ plane, centered about the Y axis.
 *
 * Scale is 1 POVunit == 1 foot.
 */

#if (TestRender)
#include "colors.inc"
#include "metals.inc"

camera {
	location <-2,3,-8>
	look_at <0,1,0>
}

light_source {
	<0, 20, -20>
	color White
}

light_source {
	<-10, 4, -10>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

plane {
	<0,1,0>, 0
	pigment { Green }
}
#end

#declare Dull_Aluminum  =  texture {
	pigment { color rgb <0.5, 0.5, 0.5> }
	finish {
		metallic
		ambient 0.2
		diffuse 0.65
		specular 0.85
		roughness 0.4
		reflection 0.05
		brilliance 0.5
	}
}

/*
 * The color of the sides of the Cray.
 *
 * This color is not accurate, the Cray-1 was a deep blue (almost black).
 * Silicon Valley legend holds that when Apple Computer took delivery of
 * their Cray X-MP, they said "great machine, just one problem: its not
 * purple". So there is at least one purple Cray out there. Nonetheless,
 * this shade of blue is not the color of Apple's Cray either. It is
 * just a color that looks good in my scene.
 */
#declare Purple_Paint = texture {
	pigment { color red 0.15 green 0.14 blue 0.86 }
	finish {
		metallic
		ambient 0.2
		diffuse 0.65
		specular 0.75
		roughness 0.8
//		reflection 0.02
		brilliance 0.1
	}
}

#declare Black_Vinyl = texture {
	pigment {
		// brick color_mortar, color_brick
		brick color rgb <0.1,0.1,0.1>, color rgb <0,0,0>
		brick_size <0.02, 0.01, 0.02>
		mortar 0.005
		rotate <0,45,0>
		scale <0.5, 1, 1>
		turbulence <0.005, 0, 0.005>
	}
	finish {
		phong 0.3
		phong_size 10
		roughness 0.2
		ambient 0.9
		diffuse 1.0
		reflection 0.01
		brilliance 1.5
	}
	normal {
		bumps 0.8
	}
}



// A 16 sided prism. 2 units diameter in XZ plane, 1 unit tall
#declare sixteenohedron = prism {
	linear_spline
	linear_sweep
	0, 1, 17
	<cos(( 0/16)*2*pi), sin(( 0/16)*2*pi)>,
	<cos(( 1/16)*2*pi), sin(( 1/16)*2*pi)>,
	<cos(( 2/16)*2*pi), sin(( 2/16)*2*pi)>,
	<cos(( 3/16)*2*pi), sin(( 3/16)*2*pi)>,
	<cos(( 4/16)*2*pi), sin(( 4/16)*2*pi)>,
	<cos(( 5/16)*2*pi), sin(( 5/16)*2*pi)>,
	<cos(( 6/16)*2*pi), sin(( 6/16)*2*pi)>,
	<cos(( 7/16)*2*pi), sin(( 7/16)*2*pi)>,
	<cos(( 8/16)*2*pi), sin(( 8/16)*2*pi)>,
	<cos(( 9/16)*2*pi), sin(( 9/16)*2*pi)>,
	<cos((10/16)*2*pi), sin((10/16)*2*pi)>,
	<cos((11/16)*2*pi), sin((11/16)*2*pi)>,
	<cos((12/16)*2*pi), sin((12/16)*2*pi)>,
	<cos((13/16)*2*pi), sin((13/16)*2*pi)>,
	<cos((14/16)*2*pi), sin((14/16)*2*pi)>,
	<cos((15/16)*2*pi), sin((15/16)*2*pi)>,
	<cos((16/16)*2*pi), sin((16/16)*2*pi)>
}


#declare Wedge_cutout1 = prism {
	linear_spline
	linear_sweep
	-1, 7, 4
	<0,0>, <-8,-1>, <-1,-8>, <0,0>
}

#declare Wedge_cutout2 = prism {
	linear_spline
	linear_sweep
	-1, 7, 4
	<0,0>, <-8,-1.05>, <-1.05,-8>, <0,0>
}

#declare Cray1 = union {
	difference { // seating
		object {
			sixteenohedron
			scale <4,0.1,4>
		}

		// cut channels between seats
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*0*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*1*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*2*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*3*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*4*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*5*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*6*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*7*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*8*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*9*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*10*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*11*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*12*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*13*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*14*22.5 }
		box { <0,0,-0.01>, <4.25,1,0.01> rotate y*15*22.5 }

		object {
			sixteenohedron
			scale <2.4,3,2.4>
			translate <0,-1,0>
		}

		Wedge_cutout2

		translate <0,1,0>
		texture { Black_Vinyl }
	}

	difference { // base
		object {
			sixteenohedron
			scale <4,1,4>
		}

		object {
			sixteenohedron
			scale <1.1,3,1.1>
			translate <0,-1,0>
		}

		Wedge_cutout1

		texture { Purple_Paint }
	}

	difference { // aluminum base of tower
		object {
			sixteenohedron
			scale <2.25,0.1,2.25>
		}

		object {
			sixteenohedron
			scale <0.95,8,0.95>
			translate <0,-1,0>
		}

		Wedge_cutout2

		translate <0,1,0>
		texture { Dull_Aluminum }
	}

	difference { // center tower
		object {
			sixteenohedron
			scale <2.2,6,2.2>
		}

		object {
			sixteenohedron
			scale <1,8,1>
			translate <0,-1,0>
		}

		Wedge_cutout1

		texture { Purple_Paint }
	}

	difference { // aluminum "fins" between sections
		union {
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*0*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*1*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*2*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*3*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*4*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*5*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*6*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*7*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*8*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*9*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*10*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*11*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*12*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*13*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*14*22.5 }
			box { <0,0,-0.02>, <2.25,6.1,0.02> rotate y*15*22.5 }
		}

		object {
			sixteenohedron
			scale <0.9,8,0.9>
			translate <0,-1,0>
		}

		Wedge_cutout1

		texture { Dull_Aluminum }
	}

	texture { Purple_Paint }
}

#if (TestRender)
object { Cray1 }
#end

#version Temp_Vers;
