#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * Textures for the floor. Edwin's shop floor is tiled with slate.
 *
 * scale is 1 POVunit == 1 foot
 */

#if (TestRender)
#include "colors.inc"

camera {
	location <5,5,5>
	look_at <0,0,0>
}

light_source {
	<0, 20, -20>
	color White
}

light_source {
	<-10, 4, -10>
	color White
}

light_source {
	<0, 10, 0>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}


#end


#declare T_FloorTile = texture {
	brick
	texture {	// the mortar texture
		pigment { Gray80 }
		finish {
			specular 0.1
			roughness 0.05
			diffuse 0.5
			ambient 0.3
		}
	}
	texture {	// the brick texture
		pigment { Gray50 }
		finish {
			reflection 0.01
			metallic
			diffuse 0.5
			ambient 0.3
		}
	}

	brick_size 2
	mortar 0.05
}

#if (TestRender)
plane {
	<0,1,0>, 0
	texture { T_FloorTile }
}
#end
#version Temp_Vers;
