#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * An ancient Elvish flute of the First Era. Discovered in a curio
 * shop by Fry, brought back to Edwin for analysis. The flute is
 * 12 inches long and one inch in diameter. It runs along the Y axis,
 * centered at the origin.
 *
 * scale is 1 POVunit == 1 inch
 */

#if (TestRender)
#include "colors.inc"
#include "metals.inc"

camera {
	location <-8,-0.5,1>
	look_at <-6,-0.5,0>
}

light_source { <0, 10,  -10> color White}
light_source { <0, 10,   10> color White}
light_source { <-10, 10, 0>  color White}
light_source { < 10, 10, 0>  color White}
light_source { <0, 10,   0>  color White}
light_source { <-10, 0,  0>  color White}
light_source { < 10, 0,  0>  color White}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}
#end


#local T_flutemetal = texture {
	pigment { P_Silver1 }
	finish {
		ambient 0.35
		brilliance 1
		diffuse 0.3
		metallic
		reflection 0.1
	}
}
#local T_runemetal = texture {
	pigment { P_Silver3 }
	finish {
		ambient 0.35
		brilliance 2
		diffuse 0.4
		metallic
		reflection 0.2
	}
}

#declare Flute = difference {
	merge {
		difference {	// inscribe ancient Elvish runes.
			cylinder { <-6, 0, 0>, <6, 0, 0>, 0.5 }
			text { ttf "MERO_DEM.TTF" "piccolo" 0.2, 0.45*x
				scale <1, 0.7, 10000>
				translate <-2.25, -0.28, 0>
			}
		}

		// an inner sheet of metal behind the opening cut by the Runes
		cylinder { <-6, 0, 0>, <6, 0, 0>, 0.49
			texture { T_runemetal }
		}

		// the mouthpiece
		intersection {
			cylinder { <-4, 0, 0>, <-4, 2, 0>, 1.0
				scale <1, 1, 0.7>
			}
			cylinder { <-6, 0, 0>, <-2, 0, 0>, 0.6 }
		}

		texture { T_flutemetal }
	}

	// hollow out the flute interior
	cylinder { <-5.9, 0, 0>, <7, 0, 0>, 0.45 }

	// The mouth hole
	cylinder { <-4, 0, 0>, <-4, 2, 0>, 0.25 }

	// the finger holes
	cylinder { <-1, 0, 0>, <-1, 2, 0>, 0.12 }
	cylinder { < 0, 0, 0>, < 0, 2, 0>, 0.12 }
	cylinder { < 1, 0, 0>, < 1, 2, 0>, 0.12 }
	cylinder { < 2, 0, 0>, < 2, 2, 0>, 0.12 }
	cylinder { < 3, 0, 0>, < 3, 2, 0>, 0.12 }
	cylinder { < 4, 0, 0>, < 4, 2, 0>, 0.12 }
	cylinder { < 5, 0, 0>, < 5, 2, 0>, 0.12 }

	texture { pigment { Black } }
}



#if (TestRender)
object { Flute
	rotate x*45
}
#end
#version Temp_Vers;
