#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * a pair of red-framed eyeglasses, the lenses tinted rose.
 * slightly more than 3.5 inches wide, the earpieces 4 inches
 * long. The glasses are centered in the XY plane, with the
 * earpieces straight back in the +Z direction.
 *
 * Scale is 1 POVunit == 1 inch.
 * by Denton Gentry 1999
 */

#if (TestRender)
#include "colors.inc"

camera {
	location <-3,-0.5,3>
	look_at <0,-0.5,3>
}

light_source {
	<-10, 0, -20>
	color White
}

light_source {
	<10, 0, -20>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

plane {
	<0,0,-1>,
	-5
	pigment { checker Black, White }
}
#end

#declare T_frame = texture {
	pigment {
		leopard
		colour_map {
			[ 0.00 color rgb <0.64, 0.16, 0.16> ]
			[ 0.80 color rgb <0.8, 0.2, 0.2> ]
			[ 0.90 color rgb <0.8, 0.8, 0.2> ]
			[ 1.00 color rgb <1, 1, 1> ]
		}
	}
	finish {
		ambient 0.2
		diffuse 0.2
		specular 0.2
		roughness 0.8
	}
}

// The lens shape, with no material information
#declare L = intersection {
	sphere { <0,0,  19.9375>, 20 }
	sphere { <0,0, -19.9375>, 20 }
	cylinder {<0,0,-1>, <0,0,1>, 0.75}
}

// The bifocal shape, with no material information
#declare B = intersection {
	object { L }
	cylinder { <0,-0.2,-1>, <0,-0.2,1>, 0.425 }
	box { <-1, -1, -1>, <1, -0.2, 1> }
}

// lens, centered <0,0,0>, 1.5 inch diameter & 1/8 inch thick
#declare Lens = union {
	difference { // the lens, sans bifocal
		object { L }
		object { B }
		interior { ior 1.4 }
	}
	object { // the bifocal
		object { B }
		interior { ior 2.5 }
	}

	// Edwin's glasses are slightly rose tinted...
	pigment { color rgbf <1.0, 0.925, 0.925, 0.85> }
	finish {
		ambient 0
		diffuse 0
		reflection 0.2
		phong 0.2
		phong_size 90
	}
}

#declare Glasses = union {
	// left lens
	union {
#ifndef (Quick)
		object { Lens }
#end
		torus { 0.75, 0.02
			rotate x*90
			texture { T_frame }
		}
		translate <-1, 0, 0>
	}

	// right lens
	union {
#ifndef  (Quick)
		object { Lens }
#end
		torus { 0.75, 0.02
			rotate x*90
			texture { T_frame }
		}
		translate <1, 0, 0>
	}

	// nose bridge
	intersection {
		torus { 0.5, 0.02
			rotate x*90
		}
		box { <-1,0.35,-1>, <1, 1, 1> }
		texture { T_frame }
	}

	// left earpiece
	union {
		cylinder {<-1.76, 0, 0.01>, <-1.76, 0, 3.25>, 0.02 }
		sphere {<-1.76, 0, 0>, 0.02 }
		intersection {
			torus { 0.75, 0.02
				rotate x*90
				rotate y*90
				translate <-1.76, -0.75, 3.25>
			}
			box { <-2, -0.745, 3.25>, <-1, 1, 5> }
		}
		sphere {<-1.76, -0.745, 4>, 0.03}
		texture { T_frame }
	}

	// right earpiece
	union {
		cylinder {<1.76, 0, 0.01>, <1.76, 0, 3.25>, 0.02 }
		sphere {<1.76, 0, 0>, 0.02 }
		intersection {
			torus { 0.75, 0.02
				rotate x*90
				rotate y*90
				translate <1.76, -0.75, 3.25>
			}
			box { <1, -0.745, 3.25>, <2, 1, 5> }
		}
		sphere {<1.76, -0.745, 4>, 0.03}
		texture { T_frame }
	}
}

#if (TestRender)
object { Glasses }
#end

#version Temp_Vers;
