#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * The Incunabula of Mazarin, a dusty old tome of Arcane spell lore.
 *
 * Created with the covers parallel to the YZ plane, with the spine
 * of the book centered about the Y axis. Roughly 12 inches tall,
 * 10 inches long, and 3 inches thick (hey, there's a lot of lore in
 * there!)
 *
 * Scale is 1 POVunit == 1 inch.
 */

#if (TestRender)
#include "colors.inc"
#include "golds.inc"

camera {
	location <-2,16,0>
	look_at <0,6,0>
}

light_source {
	<10, 4, -10>
	color White
}

light_source {
	<-10, 4, -10>
	color White
}

light_source {
	<0, 20, -5>
	color White
}

light_source {
	<0, -20, -5>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background {White}
#end

#declare T_leather1 = texture {
	pigment {
		gradient y
		colour_map {
			[ 0.00 color rgb <0.7, 0.1, 0.1> ]
			[ 0.60 color rgb <0.7, 0.1, 0.1> ]
			[ 0.70 color rgb <0.6, 0.2, 0.2> ]
			[ 1.00 color rgb <0.5, 0.15, 0.15> ]
		}
		rotate z*-45
		turbulence 1
		scale 0.01
	}
	finish {
		ambient 0.3
		diffuse 0.7
		phong 0.1
		phong_size 10
		specular 0.1
		roughness 0.2
	}
	normal { bumps 0.05 }
}

#declare T_paper = texture {
	pigment {
		gradient x
		colour_map {
			[ 0.00 color rgb <0,0,0> ]
			[ 0.01 color rgb <0,0,0> ]
			[ 0.02 color rgb <1,1,1> ]
			[ 1.00 color rgb <1,1,1> ]
		}
		scale 0.05
	}
	finish {
		roughness 0.4
	}
	normal { bumps 0.05 }
}

#declare Height = 12.0;
#declare Width = 3.0;
#declare Width2 = Width/2;
#declare Length = 10.0;

#declare Incunabula = union {
	difference {	// the spine
		cylinder {<0,0,0>, <0,Height,0>, (Width2) }
		cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2) }
		box { <-Width,-1,-Width>, <Width,Height+1,0> }
		scale <1,1,0.5>
	}
	torus { Width2, 0.1
		translate <0,2,0>
		scale <1,1,0.5>
		texture { T_Gold_2A }
	}
	torus { Width2, 0.1
		translate <0,4,0>
		scale <1,1,0.5>
		texture { T_Gold_2A }
	}
	torus { Width2, 0.1
		translate <0,6,0>
		scale <1,1,0.5>
		texture { T_Gold_2A }
	}
	torus { Width2, 0.1
		translate <0,8,0>
		scale <1,1,0.5>
		texture { T_Gold_2A }
	}
	torus { Width2, 0.1
		translate <0,10,0>
		scale <1,1,0.5>
		texture { T_Gold_2A }
	}
	text { ttf "MERO_DEM.TTF" "Incunabula" 0.5, 0
		rotate <0,90,0>
		translate <-Width2, (Height*2/3), (-Length/6)>
		scale <1,1,1>
		texture { T_Gold_1A }
	}
	difference {
		cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25 }
		cylinder {<-Width,-1,-0.1>, <-Width,Height+1,-0.1>, 0.15}
		box { <-Width-1,-1,-Width>, <-Width,Height+1,Width> }
		scale <0.5,1,1>
	}
	difference {
		cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25}
		cylinder {<Width,-1,-0.1>, <Width,Height+1,-0.1>, 0.15}
		box { <Width,-1,-Width>, <Width+1,Height+1,Width> }
		scale <0.5,1,1>
	}

	// the covers
	box {<-Width2,0,-Length>,<-Width2+0.1,Height,-0.2>}
	box {<Width2,0,-Length>,<Width2-0.1,Height,-0.2>}

	// the paper
	difference {
		box { <-Width2+0.01, 0.25, -Length+0.25>,
				<Width2-0.01, Height-0.25, 1>
		}
		difference {
			box { <-Width, -1, 0>, <Width, Height+1, 3> }
			cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2)
				scale <1,1,0.5>
			}
		}
		cylinder {<0,-1,2*(-Length+0.25)>, <0,Height+1,2*(-Length+0.25)>,
			((Width-0.25)/2)
			scale <1,1,0.5>
		}
		cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25
			scale <0.5,1,1>
		}
		cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25
			scale <0.5,1,1>
		}
		texture { T_paper }
	}

	texture { T_leather1 }
}

#if (TestRender)
object { Incunabula }
#end

#version Temp_Vers;
