#declare Temp_Vers = version;
#version 3.1;


/*
 * A small vanity table, made of oak. This is where Edwin
 * keeps his hats.
 *
 * Table is 2 feet high, 1 foot wide, and 3 feet long.
 * It is created with the legs sitting on the XZ plane,
 * with the long axis of the table along the X axis.
 *
 * scale is 1 POVunit == 1 foot
 */

#declare TestRender = 0;

#if (TestRender)
#include "colors.inc"
#include "woods.inc"

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

camera {
	location <0,4,-4>
	look_at <0,1,0>
}

light_source { <-30, 0, -15*12> color White }
light_source { <30, 0, -15*12> color White }
light_source { <0, 72, 0> color White }
light_source { <30, 21, 0> color White }

#end

#declare LongVanity = union {
	// the legs
	box { <-1.45, 0, -0.45>, <-1.35, 1.99, -0.45>
		texture { T_Wood1 rotate x*90 scale <0.6,1,1> }
	}
	box { <-1.45, 0,  0.35>, <-1.35, 1.99,  0.45>
		texture { T_Wood1 rotate x*90 scale <0.7,1,1> }
	}
	box { < 1.35, 0, -0.45>, < 1.45, 1.99, -0.35>
		texture { T_Wood1 rotate x*90 scale <0.65,1,1> }
	}
	box { < 1.35, 0,  0.35>, < 1.45, 1.99,  0.45>
		texture { T_Wood1 rotate x*90 scale <0.75,1,1> }
	}

	// the top
	box { <-1.75, 1.9, -0.5>, <1.75, 2.0, 0.5 >
		texture { T_Wood1  rotate y*90
			scale <1, 0.4, 0.5>
			translate z*-10
			translate y*10
		}
	}
}

#if (TestRender)
object { LongVanity }
#end

#version Temp_Vers;
