#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * Edwin's pipe, and a pipe bowl. The pipe is carved from mother of
 * pearl, and is quite expensive. The bowl is carved granite.
 * The bowl rests on the XZ plane, and is 6 inches in diameter
 * and 2.25 inches high. 
 *
 * scale is 1 POVunit == 1 inch
 */

#if (TestRender)
#include "colors.inc"
#include "stones.inc"

camera {
// to look at edge of bowl
	location <-4,2,2>
	look_at <-2,2.5,0>
	
// to look at tip touching ground
//	location <-7,0.5,2>
//	look_at <-7,0,0>
}

light_source { <0, 10, -20>  color White }
light_source { <0, 10,  20>  color White }
light_source { <0, 10,   0>  color White }
light_source { <-20, 10, 0>  color White }
light_source { < 20, 10, 0>  color White }

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

plane {
	<0,1,0>, 0
	pigment { Gray50 }
}
#end

#local T_bowlstone = texture{T_Grnt0  scale <2, 3, 2> rotate <0, 0, 40>}
	texture{T_Grnt7a scale <1.3, 2, 1.3> rotate <0, 0, -30> rotate <40, 0, 0>
	finish{
		phong 0.3
		phong_size 90
		ambient 0.2
		diffuse 0.2
		brilliance 0.2
	}
}

#declare PipeBowl = merge {
	difference {
		sphere { <0,3,0>, 3 }
		sphere { <0,3,0>, 2.35 }
		box { <-10, 3, -10>, <10, 10, 10> }
		// cut angled grooves for pipes to rest in
		cylinder { <-5, 2.4, 0>, <0, 3.2, 0>, 0.5 }
		cylinder { <-5, 3.2, 0>, <0, 3.2, 0>, 0.5 }
		cylinder { <-5, 2.4, 0>, <0, 3.2, 0>, 0.5  rotate y*45 }
		cylinder { <-5, 3.2, 0>, <0, 3.2, 0>, 0.5  rotate y*45 }
		cylinder { <-5, 2.4, 0>, <0, 3.2, 0>, 0.5  rotate y*90 }
		cylinder { <-5, 3.2, 0>, <0, 3.2, 0>, 0.5  rotate y*90 }

		box { <-10, -10, -10>, <10, 0.1, 10> }

		scale <1, 0.75, 1>
	}

	// the feet
	sphere { <1.5, 0.3, 0> 0.3 }
	sphere { <1.5, 0.3, 0> 0.3   rotate y*120 }
	sphere { <1.5, 0.3, 0> 0.3   rotate y*240 }

	texture { T_bowlstone }
}

#local T_motherofpearl = texture {
	pigment { color rgb <1.0, 1.0, 0.8> }
	finish {
		ambient 0.6
		diffuse 0.6
		brilliance 1.0
		reflection 0.1
		phong 0.3
		phong_size 30
		irid { 0.1
			thickness .2
			turbulence .6
		}
	}
}

#local T_grime = texture {
	pigment {
		gradient y
		colour_map {
			[ 0.00 color rgbt <0.0, 0.0, 0.0, 0.1> ]
			[ 0.60 color rgbt <0.1, 0.1, 0.0, 0.2> ]
			[ 1.00 color rgbt <0.1, 0.1, 0.0, 0.5> ]
		}
		turbulence 1
	}
	finish {
		ambient 0.1
		diffuse 0.1
		brilliance 0.0
	}
}

#declare Pipe = merge {
	difference {	// the bowl
		difference {
			sphere { <0, 0.5, 0>, 0.5 }
			box { <-10, 0.5, -10>, <10, 10, 10> }
			texture { T_motherofpearl }
		}
		sphere { <0, 0.5, 0>, 0.475 }

		texture { T_motherofpearl }
		texture { T_grime }
		scale <1, 1.6, 1>
	}

	merge {		// the stem
		cone { <0, 0.15, 0>, 0.15
				<4, 0.8, 0>, 0.1 }
		sphere { <4, 0.8, 0>, 0.1 }
		cone { <4, 0.8, 0>, 0.1
			<5.5, 0.8, 0>, 0.075 }
		scale <1, 0.85, 1>
	}

	texture { T_motherofpearl }
}

#declare PipeAndBowl = merge {
	object { PipeBowl }
	object { Pipe
		rotate z*197.8
		translate <-1.85, 2.41, 0>
	}
}

#if (TestRender)
object { PipeAndBowl }
#end
#version Temp_Vers;
