#include"colors.inc"
#include"shapes.inc"
#include"DbsTxtrs.inc"

global_settings{max_trace_level 25}

camera
{
  location  <0, 0, -11>
  look_at   <0, 0, 0> 
}

light_source //NO1 - UNDERWATER
{ 
  <0, -15, -20>
  colour rgb<0.75, 0.75, 1.00>
}

light_source //NO2 - INSIDE THE BUCKY BALL
{ 
  <0, 0, 0>
  colour Red
}

fog //BACKGROUND FOG
{
  fog_type 1
  colour rgbt <0.35, 0.0, 0.15, 0.6>
  distance 100
  turbulence 0.35
  turb_depth 0.5
}

fog //GROUND FOG
{
  fog_type 2
  colour rgb<0.667, 0.667, 0>
  distance 75                  
  fog_alt 12
  fog_offset -12
  turbulence 0.25
  turb_depth 0.5
}

plane
{
  y, -10
  material
  {
    DBSWATER
    scale 10
  }
  hollow 
  translate x*15
  rotate y*30
}

//THE SKY
plane
{
  y, 60
  pigment
  {
    DBSFIRE
    scale 100
  }
  hollow
}

plane
{
  y, 55
  texture
  {
    DBSLIGHTNING
    scale 100
  }
  hollow
  no_shadow
}        

#declare star_seed=3333;
#declare star_count=7500;
#declare min_dist=5000;
#declare star_size=2;
#include "stars2.inc"

#include"Bball.inc"

object
{
  MyBBall
  texture
  {
    BballTxtr
  }
scale 4
}

sphere { 0, 1
pigment {Clear}
interior
{
media
{
  emission 0.05
  intervals 10
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  density
  {
    spherical
    ramp_wave
    turbulence 1
    color_map
    {
      [0.0 color rgb <0, 0, 0>]
      [0.1 color rgb <1, 0, 0>]
      [1.0 color rgb <1, 1, 0>]
    } 
  }
}
}
scale 4.0
hollow
} 

#include "liss.inc"

object //NO1
{
  Lissajous
  scale 0.7
  rotate<0, 180, 0>
  translate<-30, -10, 85>
}

object //NO2
{
  Lissajous
  scale 0.7
  //rotate<0, 180, 0>
  translate<30, -10, 85>
}

object //NO3
{
  Lissajous
  scale 0.7
  rotate<0, 180, 0>
  translate<30, -10, -85>
}

object //NO4
{
  Lissajous
  scale 0.7
  //rotate<0, 180, 0>
  translate<-30, -10, -85>
}
