/*
STAR FIELD INCLUDE FILE FOR POVRay

Created by Chris Colefax, May 1997
Creates a 3-dimensional star field
To customize the star field change the following options:

#declare star_count = 1000;
#declare min_distance = 1000;
#declare max_distance = 5000;
# star_size = 2;
#declare star_Seed = -4323;
#declare star_object = sphere{<0, 0, 0>,20
pigment{rgb<1, 1, 1> finish {ambient 1}}

*/

//CHECK VARIABLE AND ASSIGN DEFAULTS
#ifndef (star_count) #declare star_count=1000; #end
#ifndef (min_distance) #declare min_distance=1000; #end
#ifndef (max_distance) #declare max_distance=min_distance*5; #end
#declare _SF_distdif=max_distance-min_distance;
#ifndef (star_size) #declare star_size=1; #end
#ifndef (_SF_rand) #ifndef (star_seed) #declare _SF_rand=seed(0);
  #else #declare _SF_rand=seed(star_seed); #end #end
#ifndef (star_object)
  #declare star_object=disc{<0, 0, 0>, z, 0.5
    pigment{onion colour_map{[0.0 rgb 1.5] [1.0 rgb 0]} scallop_wave}
    finish{ambient 1 diffuse 0} scale 50} #end

//CREATE STAR FIELD
union
{
  #declare _SF_count=0; 
  #while (_SF_count<star_count)
  object
  {
    star_object
    scale star_size
    translate z * (min_distance + rand(_SF_rand) * _SF_distdif)
    rotate (<rand(_SF_rand), rand(_SF_rand), rand(_SF_rand)> -0.5)*360
  }
#declare _SF_count=_SF_count+1; #end
}



