/******************************************************************************
// Title       : The Backside of the Moon 
//
// File        : Defense.pov
//
// Author      : Joe Claunch
//
// Date        : 2/24/1999
//
// Renderer    : Persistence Of Vision raytracer version 3.1 (for Windows)
//
// Description : This is the main file for the image.
/******************************************************************************/


#declare Debug = 0;

global_settings { assumed_gamma 2.2 ambient_light 0.2}

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shapesq.inc"
#include "stones.inc"
#include "metals.inc"
#include "golds.inc"
#include "glass.inc"
#include "stars.inc"
#include "photon.inc"
#include "lnchpad.inc"
#include "saucer.inc"

//
// The camera.
//
/*
light_source { <0, 50, 0> color rgb 1.0
  media_interaction off 
} 

camera {
  location <0, 50, 0>
  right 4/3*x
  up y
  direction z
  angle 80
  look_at <0, 0, 0>
}
*/
camera {
  location <0, 0, -7.4>
  right 4/3*x
  up y
  direction z
  angle 80
  look_at <0, 4.9, 0>
}

//
// Light source not interacting with the atmosphere. 
//

#if (Debug!=0)

light_source { <0, 50, -50> color rgb 0.8
  media_interaction off 
} 

#end


#if (Debug=0)     

// The Sun

light_source { <-100, 50, -100> color rgb 1.5 media_interaction off}

// The Moon

difference{
  height_field { 
    tga "Mount.tga"
    smooth
    pigment {White}
    normal{
      bumps 0.6
      scale 0.1
    }
    scale <100, 75, 100>
    translate <-60, -7, -45>
    hollow
    rotate -60*y 
    hollow
  }
  box{<-5, -10.0, -3>, <3, 10.0, 3> rotate 29*y pigment{Black}}

//  box{<-1.5, 0.0, -2.5>, <-0.9, 0.5, -2.0> }
  hollow
}  

// The Stars

  plane {z, -1 translate 300*z texture {Starfield4} hollow}

#end

// **** Place everything in the picture ****

object {PhotonDisruptor scale 0.75 rotate 29*y translate <0, 1, 0> hollow}

object {LaunchPad rotate 29*y hollow}

object {Saucer scale 10 rotate <10, 0, -30> translate <-200, 280, 150>}

object {PhotonSquadron scale 1 rotate <0, 0, 45> translate <-100, 200, 150>}

object {CrashedSaucer scale 1.5 rotate 45*y rotate <33, 0, -20> translate <12.5, 14.5, 4.1>}

