/******************************************************************************
// Title       : The Backside of the Moon 
//
// File        : Lnchpad.inc
//
// Author      : Joe Claunch
//
// Date        : 2/24/1999
//
// Renderer    : Persistence Of Vision raytracer version 3.1 (for Windows)
//
// Description : This file generates the launch pad object.
//
/******************************************************************************/


#declare GasMedia1 = media {
  emission 0.6
  intervals 5
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    ramp_wave
    turbulence 2.9
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.1 color rgb <0.5, 0.5, 0.6>]
      [1.0 color rgb <1, 1, 1>]
    } 
  }
} 

#declare GasMedia2 = media {
  emission 0.6
  intervals 7
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    ramp_wave
    turbulence 3.1
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.1 color rgb <0.5, 0.5, 0.6>]
      [1.0 color rgb <1, 1, 1>]
    } 
  }
} 

#declare YellowSteel = texture {
   pigment { Yellow }
   finish {
      phong 0.1
      phong_size 10
      ambient 0.2
      diffuse 0.8
   }
}

#declare Door = union {
    box { //door frame
        <-0.5, 0.0, -0.1>,  // Near lower left corner
        < 0.5, 2.5,  0.1>   // Far upper right corner

        texture { T_Silver_1A }
    }

    box { // door
        <-0.4, 0.1, -0.109>,  // Near lower left corner
        < 0.4, 2.4,  0.109>   // Far upper right corner

        texture { T_Silver_5A }
    }

    sphere { // door knob
        < 0.25 1.2,  0.105>   // Center point
        0.05                  // radius
        texture { T_Silver_2A }
    }
}

#declare WarehouseLamp = union {
    cone { // Reflector
        <0, 0.06, 0>, 0.0    // Center and radius of one end
        <0, -0.08, 0>, 0.3   // Center and radius of other end
        open                // Removes end caps
        hollow
        pigment {color DarkGreen}
    }

    blob { // Support Tubing
        threshold 0.5
        cylinder { <0, 0.06, 0>, <0, 0.4, 0>, 0.05, 1 }
        cylinder { <0, 0.4, 0>, <0, 0.5, -0.75>, 0.05, 1 }
        sphere { <0, 0.5, -0.75>, 0.15, 1 }
        pigment { color Gray50 }
        finish { ambient 0.2 diffuse 0.8 phong 1 }
    }

    light_source { <0, 0.0, 0> color Goldenrod
        fade_distance 0.2
        fade_power 3
        looks_like {
            sphere { <0, -0.04, 0>, 0.05
                texture {
                    pigment {color Goldenrod}
                    finish {ambient .8 diffuse .6}
                }
            }
        }
    }

    light_source {
        <0, 0, 0>
        color Goldenrod
        spotlight
        point_at <0, -1.0, 0>
        radius 12.0
        falloff 19.0
        tightness 1
        fade_distance 0.2
        fade_power 3
    }

}

#declare StepSupport = box {
    <-0.01, -0.36, 0.045>, // Near lower left corner
    < 0.00,  0.00, 0.000>  // Far upper right corner
    rotate -45*x
}

#declare StepRail = union {
    object { StepSupport translate 0.95*y }
    box {
        <-0.01, 0.00, -0.01>, // Near lower left corner
        < 0.01, 1.00,  0.01>  // Far upper right corner
    }
    box {
        <-0.01, 0.00, -0.01>, // Near lower left corner
        < 0.01, 1.00,  0.01>  // Far upper right corner
        translate <0.0, -0.25, 0.25>
    }
}

#declare Step = union {
    box { // Step
        <-0.5, 0.0,  0.0>,  // Near lower left corner
        < 0.5, 0.05, 0.25>  // Far upper right corner
    }
    object { StepSupport translate <-0.5, 0.0,  0.00> } // Right rear support
    object { StepSupport translate < 0.5, 0.0,  0.00> } // Left  rear support
    object { StepSupport translate <-0.5, 0.0,  0.25> } // Right front support
    object { StepSupport translate < 0.5, 0.0,  0.25> } // Left  front support

    object { StepRail translate <  0.5, 0.0,  0.00> } // Left railing
    object { StepRail translate < -0.5, 0.0,  0.00> } // Left railing
}

#declare NumSteps = 100;
#declare Offset   = 0.0;
#declare Counter  = 1;

#declare Steps = union {
    #while (Counter<NumSteps)
        object { Step translate <0, -Offset, Offset> }
        #declare Counter=Counter+1;
        #declare Offset=Offset+0.25;
    #end
}

#declare Landing = union {
    box { // landing floor
        <-1.5, 0.0, 0.1>,  // Near lower left corner
        < 1.5, 0.05,  -1.5>   // Far upper right corner
        texture { Rust scale 0.005}
    }

    object { Steps
        translate 0.5*x
        rotate 90*y
        translate <1.5, -0.03, 0.0>
        texture { Rust }
    }
}

#declare DoorStairs = union {
  object { Door           
    rotate 180*y
    translate <0, 0.15, 0>
  }

  object { Landing
    translate <0, 0, 0.07>
  }

  object { WarehouseLamp
    rotate 180*y
    translate <0, 2.65, -0.83>
  }
}

#declare DownSpotX = light_source {<0, 1.2, -2.1> color rgb<1, 1, 1> * 3
  spotlight
  point_at <0, -10.0, -2.1>
  radius 100
  falloff 50
  fade_distance 1.5
  fade_power 3
  media_attenuation on
}
                     
#declare DownSpotZ = light_source {<2.1, 1.2, 0> color rgb<1, 1, 1> * 3
  spotlight
  point_at <2.1, -10.0, 0>
  radius 100
  falloff 50
  fade_distance 1.5
  fade_power 3
  media_attenuation on
}
                     
#declare SpotArray1 = union{
  light_source {<0.0, 1.0, -1.5> color rgb<1, 1, 1> * 3
    spotlight
    point_at <0, 11.25, 0>
    radius 1.5
    falloff 1.5
    media_attenuation on
  }
  light_source {<0.0, 1.0, -1.0> color rgb<1, 1, 1> * 3
    spotlight
    point_at <0, 9, 0>
    radius 1.5
    falloff 1.5
    media_attenuation on
  }
  light_source {<0.0, 1.0, -0.8> color rgb<1, 1, 1> * 3
    spotlight
    point_at <-0.20, 6, 0>
    radius 4
    falloff 3
    media_attenuation on
  }
  light_source {<0.0, 1.0, -0.5> color rgb<1, 1, 1> * 3
    spotlight
    point_at <0, 3, 0>
    radius 8
    falloff 7
    media_attenuation on
  }
}

#declare SpotArray2 = union{
  light_source {<0.0, 1.0, -1.5> color rgb<1, 1, 1> * 2.5
    spotlight
    point_at <0, 12, 0>
    radius 1.5
    falloff 1.5
    media_attenuation on
  }
  light_source {<0.0, 1.0, -1.5> color rgb<1, 1, 1> * 3
    spotlight
    point_at <0, 7, 0>
    radius 2
    falloff 2
    media_attenuation on
  }
  light_source {<0.0, 1.0, -0.5> color rgb<1, 1, 1> * 2.5
    spotlight
    point_at <0, 3, 0>
    radius 2
    falloff 2
    media_attenuation on
  }
}

#declare YellowBeacon = union{
  light_source {<0, 0, 0> 
    color rgb<4, 4, 4>    
    media_attenuation on
    fade_distance .025
    fade_power 2
  }
  sphere{<0, 0, 0> 0.015 pigment{color rgbf <0.8, 0.8, 0.2, 0.8>} finish{F_Glass2} texture{T_Glass3} interior{I_Glass} hollow}
}

#declare RedBeacon = union{
  light_source {<0, 0, 0> 
    color rgb<4, 4, 4>    
    media_attenuation on
    fade_distance .025
    fade_power 2
  }
  sphere{<0, 0, 0> 0.015 pigment{color rgbf <1.0, 0.0, 0.0, 0.8>} finish{F_Glass2} texture{T_Glass3} interior{I_Glass} hollow}
}

#declare Counter  = -2;
#declare LightCnt =  0;
#declare RedLightCnt =  0;

#declare Railing = union {
  #while (Counter<2.0)

#if(Debug=0)
    #declare LightCnt =  LightCnt + 1;
    #if(LightCnt>=4)
      #declare LightCnt =  0;
      #declare RedLightCnt = RedLightCnt + 1;
      #if(RedLightCnt<4)
        object{YellowBeacon translate<Counter, 1.055, -1.997>}
        object{YellowBeacon translate<1.997, 1.055, Counter>}
      #else
        #declare RedLightCnt =  0;
        object{RedBeacon translate<Counter, 1.055, -1.997>}
        object{RedBeacon translate<1.997, 1.055, Counter>}
      #end
    #end
#end
    
    cylinder {<Counter, 1, -1.997>, <Counter, 1.05, -1.997>, 0.003 pigment{White}}
    cylinder {<1.997, 1, Counter>, <1.997, 1.05, Counter>, 0.003 pigment{White}}
    #if(Counter != 2)
      cylinder {<Counter, 1.01, -1.997>, <Counter+0.05, 1.01, -1.997>, 0.001 pigment{White}}
      cylinder {<Counter, 1.03, -1.997>, <Counter+0.05, 1.03, -1.997>, 0.001 pigment{White}}
      cylinder {<Counter, 1.05, -1.997>, <Counter+0.05, 1.05, -1.997>, 0.001 pigment{White}}

      cylinder {<1.997, 1.01, Counter>, <1.997, 1.01, Counter+0.05>, 0.001 pigment{White}}
      cylinder {<1.997, 1.03, Counter>, <1.997, 1.03, Counter+0.05>, 0.001 pigment{White}}
      cylinder {<1.997, 1.05, Counter>, <1.997, 1.05, Counter+0.05>, 0.001 pigment{White}}
    #end
    #declare Counter=Counter+0.05;
  #end
}

#declare PipeCnt    = 0;
#declare PipeY      = 0.75;
#declare PipeRadius = 0.005;

#declare Pipes = union {
  #while (PipeCnt < 6)
    #switch (PipeCnt)
      #case (0)
        cylinder{<2.0+PipeRadius, PipeY, -1.8+(PipeCnt*0.2)>, <2.0+PipeRadius, PipeY, 1.25>, PipeRadius}
        sphere{<2.0+PipeRadius, PipeY, -1.8+(PipeCnt*0.2)>, PipeRadius}
        sphere{<2.0+PipeRadius, PipeY,  1.25>, PipeRadius*3}
        cylinder{<2.0+PipeRadius, PipeY,  1.25>, <2.0+PipeRadius, 1.15,  1.25>, PipeRadius*3}
        sphere{<2.0+PipeRadius, 1.15,  1.25>, PipeRadius*3}
        cylinder{<2.0+PipeRadius, 1.15,  1.25>, <1.7, 1.15, 1.25>, PipeRadius*3}
        #break
      #case (1)
        cylinder{<2.0+PipeRadius, PipeY, -1.8+(PipeCnt*0.2)>, <2.0+PipeRadius, PipeY, 1.80>, PipeRadius}
        sphere{<2.0+PipeRadius, PipeY, -1.8+(PipeCnt*0.2)>, PipeRadius}
        sphere{<2.0+PipeRadius, PipeY,  1.80>, PipeRadius*3}
        cylinder{<2.0+PipeRadius, PipeY,  1.80>, <2.0+PipeRadius, 1.15,  1.80>, PipeRadius*3}
        sphere{<2.0+PipeRadius, 1.15,  1.80>, PipeRadius*3}
        cylinder{<2.0+PipeRadius, 1.15,  1.80>, <1.7, 1.15, 1.80>, PipeRadius*3}
        #break
      #case (4)
        cylinder{<2.0+PipeRadius, PipeY, -2.0+PipeRadius>, <2.0+PipeRadius, PipeY, 2.0>, PipeRadius}
        sphere{<2.0+PipeRadius, PipeY, -2.0+PipeRadius>, PipeRadius}
        cylinder{<2.0+PipeRadius, PipeY, -2.0-PipeRadius>, <1.8, PipeY, -2.0-PipeRadius>, PipeRadius}
        sphere{<1.8, PipeY, -2.0-PipeRadius>, PipeRadius}
        #break
      #case (5)
        cylinder{<2.0+PipeRadius, PipeY, -1.8>, <2.0+PipeRadius, PipeY, 1>, PipeRadius}
        sphere{<2.0+PipeRadius, PipeY, -1.8>, PipeRadius}
        sphere{<2.0+PipeRadius, PipeY, 1>, PipeRadius}
        cylinder{<2.0+PipeRadius, PipeY, 1>, <2.0+PipeRadius, -1, 1>, PipeRadius*4}
        #break
      #else
        cylinder{<2.0+PipeRadius, PipeY, -1.8+(PipeCnt*0.2)>, <2.0+PipeRadius, PipeY, 1.8>, PipeRadius}
        sphere{<2.0+PipeRadius, PipeY, -1.8+(PipeCnt*0.2)>, PipeRadius}
        sphere{<2.0+PipeRadius, PipeY,  1.8>, PipeRadius}
    #end // End of switch

    #declare PipeY = PipeY - (PipeRadius * 8);
    #declare PipeCnt = PipeCnt + 1;
  #end
  pigment{White}
}

#declare LaunchPad = union{
  box{<-2.0, -10.0, -2.0>, <2.0, 1.0, 2.0> pigment {Red} hollow}

  sphere{<1.7, 1.3, 1.80> .3 pigment{White}}
  sphere{<1.7, 1.3, 1.25> .3 pigment{White}}
  
  object{Pipes}

  union{
    cone{< 0, 0, 0>, 0.3, <0, 1, 0>, 0.7}
    sphere{<0, 1, 0>, 0.7}
    pigment { color rgbf<1, 1, 1, 1> }
    finish { ambient 0 diffuse 0 }
    interior { media { GasMedia1 } }
    hollow yes
    scale <1.0, 1.2, 1.0> 
    translate <1.8, 0.5,  1.25>
  }

  union{
    cone{< 0, 0, 0>, 0.3, <0, 1, 0>, 0.5}
    sphere{<0, 1, 0>, 0.5}
    pigment { color rgbf<1, 1, 1, 1> }
    finish { ambient 0 diffuse 0 }
    interior { media { GasMedia2 } }
    hollow yes
    scale <1.0, 0.7, 1.0> 
    rotate 45*y
    translate <1.8, 0.6,  1.80>
  }

  light_source {<1.98, 1.01, 1.525> 
    color rgb<4, 4, 4>    
    media_attenuation on
    fade_distance 0.25
    fade_power 2
  }
  light_source {<1.7, 1.01, 0.5> 
    color rgb<4, 4, 4>    
    media_attenuation on
    fade_distance 0.5
    fade_power 2
  }

  union {
    difference{
      box{<-1.9, 1.0, -1.9>, <-1.4, 1.2, -1.6> pigment{White}}
      box{<-1.6, 1.0, -1.8>, <-1.2, 1.12, -1.7> pigment{White}}
      hollow      
    }

    light_source {<-1.6, 1.1, -1.75> 
      color rgb<4, 4, 4>    
      media_attenuation on
      fade_distance .25
      fade_power 3
    }

    light_source {<-1.3, 1.01, -1.95> 
      color rgb<.8, .8, .8>    
      media_attenuation on
      fade_distance 0.25
      fade_power 2
    }
  }

  text { ttf "cyrvetic.ttf" "M.A.J.E.S.T.I.C. 12" 1.0, 0 rotate 5*x scale 0.2 translate <-0.05, 0.75, -2.02> pigment{White} hollow}
  text { ttf "cyrvetic.ttf" "Alien Threat Defense System" 1.0, 0 rotate 5*x scale 0.15 translate <-0.18, 0.55, -2.02> pigment{White} hollow}
  text { ttf "cyrvetic.ttf" "Lunar Launch Complex 4798" 1.0, 0 rotate 5*x scale 0.15 translate <-0.18, 0.35, -2.02> pigment{White} hollow}

  object {DoorStairs scale 0.05 translate <-0.85, 0.8, -1.999>}
  
  object {Railing}
  
  #declare Position = -2.0;
  #while (Position<=2.0)
    object{DownSpotX translate Position*x}
    #declare Position = Position + 0.5;
  #end

  #declare Position = -2.0;
  #while (Position<=2.0)
    object{DownSpotZ translate Position*z}
    #declare Position = Position + 0.5;
  #end

  light_source {<0.0, 1.0, -1.5> color rgb<1, 1, 1> * 2
    spotlight
    point_at <0, 5, 0>
    radius 20
    falloff 19
    media_attenuation on
  }

  light_source {<1.0, 1.0, -0.05> color rgb<1, 1, 1> * 2
    spotlight
    point_at <0.95, 1.18, 0>
    radius 17
    falloff 16
    media_attenuation on
  }

  object {SpotArray1 rotate -45*y}
  object {SpotArray2 rotate  45*y}

  hollow
}

