/******************************************************************************
// Title       : The Backside of the Moon 
//
// File        : Photon.inc
//
// Author      : Joe Claunch
//
// Date        : 2/24/1999
//
// Renderer    : Persistence Of Vision raytracer version 3.1 (for Windows)
//
// Description : This file generates the Photon Disruptor image. It contains
//               the scene data for the missile on the launch pad, the 
//               exploding missile, and the missiles flying in formation.
/******************************************************************************/


#declare BlastMedia = media {
  emission 0.09
  intervals 5
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    ramp_wave
//    turbulence 0.1
//    turbulence 1.1
    turbulence 1.7
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.1 color rgb <1, 0, 0>]
      [1.0 color rgb <1, 1, 0>]
    } 
  }
} 

#declare FlameMedia = media {
  emission 0.9
  intervals 5
  samples 1, 20
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    ramp_wave
//    turbulence 0.1
//    turbulence 1.1
    color_map {
      [ 0.0 color rgbt <0, 0, 1,  1> ]
      [ 0.1 color rgbt <1, 0, 1, -1> ]
      [ 0.2 color rgbt <1, 1, 0, -1> ]
      [ 1.0 color rgbt <1, 1, 1, -1> ]
    } 
  }
} 

#declare BlackSteel = texture {
   pigment { Black }
   finish {
      phong 1.0
      phong_size 20
      ambient 0.2
      diffuse 0.8
   }
}

#declare WhiteSteel = texture {
   pigment { White }
   finish {
      phong 0.0
      phong_size 20
      ambient 0.2
      diffuse 0.8
   }
}

#declare OrangeSteel = texture {
//   pigment { Orange }
   pigment {rgb<0.8705882352941, 0.06274509803922, 0.03137254901961>}
   finish {
      phong 0.0
      phong_size 20
      ambient 0.2
      diffuse 0.8
   }
}


#declare FinWing = union {
  difference {
    box {
      <-1.34375, -0.5625, 0>,        // Near lower left corner
      < 1.34375,  0.5625, 0.09375>   // Far upper right corner
    }

     box {<-1.44375, -0.4625, -1.0>, <-1.24375, -0.6625,  1.0>}
     box {<-1.44375,  0.4625, -1.0>, <-1.24375,  0.6625,  1.0>}
     box {< 1.44375, -0.4625, -1.0>, < 1.24375, -0.6625,  1.0>}
     box {< 1.44375,  0.4625, -1.0>, < 1.24375,  0.6625,  1.0>}
  }

  cylinder {< 1.24375,  0.4625, 0>, < 1.24375,  0.4625, 0.09375>, 0.1}
  cylinder {<-1.24375,  0.4625, 0>, <-1.24375,  0.4625, 0.09375>, 0.1}
  cylinder {< 1.24375, -0.4625, 0>, < 1.24375, -0.4625, 0.09375>, 0.1}
  cylinder {<-1.24375, -0.4625, 0>, <-1.24375, -0.4625, 0.09375>, 0.1}
  
  disc { <0, 0, -0.0001>, z, 0.42 texture{BlackSteel}}
  
  hollow 
  rotate 90*z
}

#declare FinStrut = box {
 <-1.34375, -0.6875, -0.046875>,  // Near lower left corner
 < 1.34375,  0.6875,  0.046875>   // Far upper right corner
 hollow
 rotate 90*z
}

#declare MiniFin1 = box {
  <-0.046875, -0.875, -0.25>,  // Near lower left corner
  < 0.046875,  0.000,  0.00>   // Far upper right corner
  hollow
}
    
#declare MiniFin2 = box {
  <-0.046875, 0.000, -0.5>,  // Near lower left corner
  < 0.046875, 0.875,  0.0>   // Far upper right corner
  hollow
}
    
#declare Fin = union{
  object {FinWing}
  object {FinStrut rotate 90*y translate 0.6875*z}
}    

#declare FinUnit = union{
  union {
    object {Fin translate -1.729351*z rotate 0*y}
    object {Fin translate -1.729351*z rotate 120*y}
    object {Fin translate -1.729351*z rotate 240*y}
    translate 1.34375*y 
    translate 0.125*y
  }

  union {
    object {MiniFin1 translate - 0.368*z rotate 0*y}
    object {MiniFin1 translate - 0.368*z rotate 120*y}
    object {MiniFin1 translate - 0.368*z rotate 240*y}
    translate 4.5*y
  }

  union {
    object {MiniFin2 translate -0.368*z rotate 0*y}
    object {MiniFin2 translate -0.368*z rotate 120*y}
    object {MiniFin2 translate -0.368*z rotate 240*y}
    rotate 60*y
    translate 0.125*y
  }
}
    
#declare LowerBodyTube = difference {
  cylinder {
    <0, 0, 0>,       // Center of one end
    <0, 4.6, 0>,     // Center of other end
    0.368            // Radius
    hollow
  }

  cylinder {
    <0, -1.0, 0>,     // Center of one end
    <0,  4.6, 0>,     // Center of other end
    0.36               // Radius            
    pigment {color Black }
  }
  hollow
}

#declare UpperBodyTube = union{

  cylinder {
    <0, 0.0, 0>,     // Center of one end
    <0, 0.631, 0>,     // Center of other end
    1.0
    hollow
    texture {OrangeSteel}
  }
  
  cylinder {
    <0, 0.63, 0>,     // Center of one end
    <0, 1.0, 0>,     // Center of other end
    1.0
    hollow
    texture {WhiteSteel}
  }
   
  cylinder {
    <0, 0.0, 0>,     // Center of one end
    <0, 1.0, 0>,     // Center of other end
    1.0
    hollow

    texture {
      pigment{image_map { gif "decal1.gif" map_type 2 once transmit 1, 1.0 } } 
      finish {
        phong 0.0
        phong_size 20
        ambient 0.2
        diffuse 0.8
      }
      scale <1, 1, 1>
      translate 0.025*y
    }
    
    scale 1.001
  }
  
  rotate 135*y
  scale <0.488, 9.5, 0.488>
}

#declare NoseCone = difference {
    sphere {<0, 0, 0> 1 scale <0.488, 3.3125, 0.488>}
    plane {y, 1 inverse}
    rotate 180*x
}

#declare FinStripe = intersection {
  union {
    object {LowerBodyTube}
    object {FinUnit}
  }
  cylinder {
    <0, 2.25, 0>,     // Center of one end
    <0, 2.50, 0>,     // Center of other end
    1.45              // Radius
  }         
  scale 1.01
}

#declare MachHalf = lathe {
    cubic_spline
    4,
    <0, 0>,
    <1, 1>,
    <0, 2>,
    <0, 0>
}

#declare MachDM = union {
    object { MachHalf }
    object { MachHalf rotate 180*x translate 2*y}
}

#declare Counter       = 0.0;
#declare NumDiamonds   = 20;

#declare MachDiamonds = union {
  #while (Counter<NumDiamonds)
    object { MachDM
      pigment { color rgbf<1, 1, 1, 1> }
      finish { ambient 0 diffuse 0 }
      interior { media { FlameMedia } }
      hollow yes
      #declare Sizer = (NumDiamonds-Counter)/NumDiamonds;
      scale <Sizer, 3.0, Sizer>
      translate -(Counter*2.5)*y }
      #declare Counter=Counter+1;
  #end
}


#declare PhotonDisruptor = union{
  object {NoseCone texture{WhiteSteel} translate 14*y}
  object {UpperBodyTube /*texture{OrangeSteel}*/ translate 4.5*y}
  object {LowerBodyTube texture{WhiteSteel}}
  object {FinUnit texture{WhiteSteel}}
  object {FinStripe texture{BlackSteel}}
  object {MachDiamonds scale <0.9, 2.5, 0.9>translate -14*y}
  hollow
}

#declare ExplodingPhoton = union{
  object {NoseCone texture{WhiteSteel} rotate -37*x translate <5, 30, 0>}

  union{
    object {UpperBodyTube}
    sphere{< 0, 0, 0> 1.0 
      pigment { color rgbf<1, 1, 1, 1> }
      finish { ambient 0 diffuse 0 }
      interior { media { BlastMedia } }
      hollow yes
      scale <5, 14, 5> 
      rotate 45*y
      translate <0, 6.0, 0>
    }
    rotate 20*x
    translate 6.5*y
  }
  
  union{
    object {LowerBodyTube texture{WhiteSteel}}
    object {FinUnit texture{WhiteSteel}}
    object {FinStripe texture{BlackSteel}} 
    object {MachDiamonds scale <0.45, 1.25, 0.45> translate -7*y}
    rotate -15*y
    rotate -25*x
    translate -2*y
  }                     
  
  #declare R1 = seed(0);
  #declare Pieces = 0;
  #while (Pieces<=150.0)
    #declare X = (rand(R1) * 20) - 10;
    #declare Y = (rand(R1) * 20) - 10 + 11;
    #declare Z = (rand(R1) * 20) - 10;
    #declare Size = rand(R1) * 0.8;
    #declare Color = rand(R1) + 0.3;
    sphere {<X, Y, Z> Size pigment{rgb<Color, Color - 0.3, 0>}}
    #declare Pieces = Pieces + 1;
  #end


  hollow 
}

#declare PhotonSquadron = union{
  object {PhotonDisruptor rotate -33*y translate 10*z translate 40*y}
  object {ExplodingPhoton translate 10*z rotate 120*y}
  object {PhotonDisruptor translate 30*z rotate 240*y translate -20*y}
  hollow
}

