/******************************************************************************
// Title       : The Backside of the Moon 
//
// File        : Saucer.inc
//
// Author      : Joe Claunch
//
// Date        : 2/24/1999
//
// Renderer    : Persistence Of Vision raytracer version 3.1 (for Windows)
//
// Description : This file generates the flying saucer, the crashed saucer, and
//               the death ray beam.
/******************************************************************************/

#declare BeamMedia = media {
  emission 0.7
  intervals 5
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    ramp_wave
//    turbulence 0.1
    turbulence 0
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.1 color rgb <1, 1, 0>]
      [1.0 color rgb <0, 1, 0>]
    } 
  }
} 

#declare AlienBeam_CMap1 =  
color_map {
    [0.00 rgbf <0,1,0,0.7>]
    [0.15 rgbf <0.94, 0.81, 0.99, 0.65>]
    [0.25 rgbf <0.94, 0.81, 0.99, 0.65>]
    [0.30 rgbf <0.87, 0.70, 0.98, 0.85>]
    [0.40 rgbf <0.87, 0.870, 0.0, 0.85>]
    [0.45 rgbf <0.73, 0.900, 0.0, 0.95>]
    [1.00 rgbf <0,1,0,0.8>]
}

#declare T_AlienBeam = 
texture {
    pigment {
        marble
        color_map { AlienBeam_CMap1 }
        turbulence 3.7
    }
    finish { ambient 1 }
}

#declare SaucerDetail = union{
  cylinder {<0, 0, 1>, <0,  0.25, 0>, 0.02 rotate 0*y}
  cylinder {<0, 0, 1>, <0,  0.25, 0>, 0.02 rotate 72*y}
  cylinder {<0, 0, 1>, <0,  0.25, 0>, 0.02 rotate 144*y}
  cylinder {<0, 0, 1>, <0,  0.25, 0>, 0.02 rotate 216*y}
  cylinder {<0, 0, 1>, <0,  0.25, 0>, 0.02 rotate 288*y}
  cylinder {<0, 0, 1>, <0, -0.25, 0>, 0.02 rotate 0*y}
  cylinder {<0, 0, 1>, <0, -0.25, 0>, 0.02 rotate 72*y}
  cylinder {<0, 0, 1>, <0, -0.25, 0>, 0.02 rotate 144*y}
  cylinder {<0, 0, 1>, <0, -0.25, 0>, 0.02 rotate 216*y}
  cylinder {<0, 0, 1>, <0, -0.25, 0>, 0.02 rotate 288*y}
}

#declare Saucer = union {
  union{
    object{SaucerDetail}
    cone {<0, 0, 0> 1 <0,  0.25, 0>, 0} 
    cone {<0, 0, 0> 1 <0, -0.25, 0>, 0}
    sphere{<0, 0, 0>, 1 scale <0.33, 0.3, 0.33>}
    difference{
      torus{0.1, 0.01 rotate 90*x scale <1, 2, 1> translate <0.1, -0.25, 0>} 
      box{<0.1, -5, -5>, <10, 10, 5>}
    }
    sphere{<0.09, -0.45, 0>, 0.02}
    cone {<0.09, -0.45, 0>, 0, <0.15, -0.45, 0> 0.06} 
    cone {<0.15, -0.45, 0>, 0.01, <0.25, -0.45, 0> 0} 
    sphere{<0.20, -0.45, 0>, 0.02}
    texture{T_Silver_3B}
  }

  union{
    cone {<0, 0, 0> 1.05 <0,  0.1, 0>, 0} 
    cone {<0, 0, 0> 1.05 <0, -0.1, 0>, 0}
    texture{T_Chrome_4E}
  }

  light_source {<0.0, -10.0, 0.0> color rgb<1, 1, 1> * 1.3
    spotlight
    point_at <0, 0, 0>
    radius 10
    falloff 10
    media_attenuation on
    fade_distance 100
    fade_power 2
    shadowless
  }
  
  union{
    cone {<0.25, -0.45, 0>, 0, <11, -0.45, 0>, 0.2}
    sphere {<11, -0.45, 0>, 0.2}
    texture{T_AlienBeam}
    hollow yes
  } 

  light_source {<11.3, -0.45, 0> 
    color rgb<2, 2, 0>    
    media_attenuation on
    fade_distance 5
    fade_power 2
  }

  light_source {<11.3, -0.5, 0> 
    color rgb<2, 2, 0>    
    media_attenuation on
    fade_distance 5
    fade_power 2
  }

  hollow 
}

#declare ImpactMedia = media {
  emission 0.7
  intervals 5
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    ramp_wave
    turbulence 4.3
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.1 color rgb <0.5, 0.5, 0.6>]
      [1.0 color rgb <1, 1, 1>]
    } 
  }
} 

#declare R1 = seed(0);
#declare Pieces = 0;

#declare BlastHole = union{
  #while (Pieces<20.0)
    box{<-0.5, -0.1, -0.1>, <0.5, 0.1, 0.1>
      scale<rand(R1)+0.5, rand(R1)+0.5, rand(R1)+0.5>
      rotate<rand(R1)*360.0, rand(R1)*360.0, rand(R1)*360.0>
    }
    #declare Pieces = Pieces + 1;
  #end
}

#declare Saucer2 = union {
  union{
    object{SaucerDetail}
    cone {<0, 0, 0> 1 <0,  0.25, 0>, 0} 
    cone {<0, 0, 0> 1 <0, -0.25, 0>, 0}
    sphere{<0, 0, 0>, 1 scale <0.33, 0.3, 0.33>}
    difference{
      torus{0.1, 0.01 rotate 90*x scale <1, 2, 1> translate <0.1, -0.25, 0>} 
      box{<0.1, -5, -5>, <10, 10, 5>}
    }
    sphere{<0.09, -0.45, 0>, 0.02}
    cone {<0.09, -0.45, 0>, 0, <0.15, -0.45, 0> 0.06} 
    cone {<0.15, -0.45, 0>, 0.01, <0.25, -0.45, 0> 0} 
    sphere{<0.20, -0.45, 0>, 0.02}
    texture{T_Silver_5A}
  }

  union{
    cone {<0, 0, 0> 1.05 <0,  0.1, 0>, 0} 
    cone {<0, 0, 0> 1.05 <0, -0.1, 0>, 0}
    texture{T_Chrome_5B}
  }

  
  hollow 
}

#declare CrashedSaucer = union {
  difference {
    object{Saucer2}
    object{BlastHole translate <0.7, 0.0, -0.7> texture{T_AlienBeam}}
  }

  light_source {<0.6, 0.0, -0.6> 
    color rgb<1, 3, 0>    
    media_attenuation on
    fade_distance 1
    fade_power 3
  }

  union{
    #declare R1 = seed(0);
    #declare Pieces = 0;
    #while (Pieces<=500.0)
      #declare X = (rand(R1) *  0.5) - 0.25 + 0.5;
      #declare Y = (rand(R1) * -10);
      #declare Z = (rand(R1) *  0.5) - 0.25 - 0.5;
      #declare Size = rand(R1) * 0.01;
      #declare Color = rand(R1) * 2.0;
      sphere {<X, Y, Z> Size pigment{rgb<Color, 3.0, 0>}}
      #declare Pieces = Pieces + 1;
    #end
  }
  
  sphere{< 0, 0, 0> 1.0 
    pigment { color rgbf<1, 1, 1, 1> }
    finish { ambient 0 diffuse 0 }
    interior { media { ImpactMedia } }
    hollow yes
    scale <1.5, 0.7, 1.5> 
  }
}