//create the wall and cityscape
// by Darren Izzard, from "Infinite Worlds"
// part of my "Imaginary Worlds" entry for the IRTC

//object: Desk, size: <0,0,0>-<5,1,2> (approx.)

#include "colors.inc"
#include "textures.inc"

//#declare TEST_DESK_MAKER=1;   //uncomment to test this include

#ifdef(TEST_DESK_MAKER)
// for testing
camera { location <4,5,-4> look_at <2.5,1,0>}
light_source { <3,10,-5> color White }
#end

#declare Monitor=object {
         union {
               //monitor
               difference {
                          box {<0.2,0,1>,<1.1,0.8,1.75>}
                          #declare ZPos=1.65;
                          #while(ZPos>1.3)
                              box {<0.3,1,ZPos>,<1,0.7,ZPos-0.025>}
                              #declare ZPos=ZPos-0.05;
                          #end
                          box {<0.3,0.15,0.9>,<1,0.75,1.1>}
                          box {<0.25,0.15,0.9>,<1.05,0.75,1.025>}
                          box {<-0.5,0,0>,<1.5,1,1> rotate x*5 translate <0.2,0.8,1>}   //to give sloping top
                          bounded_by {box {<0.2,0,1>,<1.1,0.8,1.75>}}
                          texture {
                                  pigment {
                                          color rgb <0.9,0.9,0.8>
                                          }
                                  }
                          }
               box {<0,0,0>,<1,1,1>             //image on screen
                   texture {
                           pigment {
                                   image_map {
                                             png "delemsml.png"
                                             interpolate 2
                                             }
                                   }
                           finish { ambient 0.5 }
                           }
                   scale <0.7,0.6,0.1>
                   translate <0.3,0.15,1.05>
                   }
               box {<0,0,0>,<1,1,1>         //monitor buttons (on/off switch, etc.)
                   texture {
                           pigment {
                                   image_map {
                                             png "monibutn.png"
                                             interpolate 2
                                             }
                                   }
                           }
                   scale <0.7,0.15,0.1>
                   translate <0.3,0,0.99>
                   }
               }
         }

#declare Desk=union {
         box {<0,0,0>,<5,1,2>
             texture {
                     pigment {
                             wood
                             color_map {
                                       [0 color Brown]
                                       [1 color (Brown+Red)/2]
                                       }
                             turbulence 0.7
                             scale 0.25
                             }
                     }
             }
         object {Monitor
                scale <1.5,1.5,1>
                translate <1,1,0>
                }
         }

#ifdef(TEST_DESK_MAKER)
object {Desk}
#end
