//create the wall and cityscape
// by Darren Izzard, from "Infinite Worlds"
// part of my "Imaginary Worlds" entry for the IRTC

//object: Wall, size: <0,0,0>-<12,6,0.5> (approx.)

#include "colors.inc"
#include "textures.inc"

//#declare TEST_WALL_MAKER=1;   //uncomment to test this include

#declare TURN_OFF_WALL_SHADOWS=1;   //remove shadows from certain objects

#declare WINDOW_LOCATION=<4.5,3,0>;  //location of cityscape window
#declare WINDOW_SIZE=<2,1.5,0>;    //size of cityscape window
#declare CITYSCAPE_DEPTH=1.5;      //depth of cityscape scene (Z)
#declare OFFICE_WINDOW_AMBIENT=0.17;        //ambient level to give impression of lit window

#declare USE_PILLAR_STURM=1;    //comment out to remove sturmian solver from pillars

#ifdef(TEST_WALL_MAKER)
// for testing
camera { location <3,2,-15> look_at <6,3,0>}
light_source { <3,10,-15> color White }
#end

#declare Wall=object {
         #declare PaintTexture=texture {
                                   pigment {color rgb <0.3,0.4,0.7>}
                                   normal {wood 0.05 turbulence 0.6 scale 0.1}
                                   finish {specular 0.1}
                                   }
         #declare WallPigment=pigment {
                                   bozo
                                   pigment_map {
                                     [0 granite color_map {[0 color rgb <0.5,0.5,0.5>] [1 color rgb <0.3,0.3,0.3>]}]
                                     [1 granite color_map {[0 color rgb <0.4,0.4,0.4>] [1 color rgb <0.6,0.6,0.6>]}]
                                     }
                                   turbulence 0.5
                                   }
         union {
               difference {
                          box {<0,0,0>,<12,4.9,0.5>}  //main wall
                          box {<0,0,-0.1>,WINDOW_SIZE+<0,0,0.6> translate WINDOW_LOCATION}  //window hole
                          texture {
                                      pigment {WallPigment}
                                      normal {
                                             brick 0.3
                                             scale 0.2
                                             }
                                      }
                          bounded_by{box{<0,0,0>,<12,5,0.5>}}
                          }
               difference { //window frame
                          box {<0,0,-0.1>,WINDOW_SIZE+<0,0,0.6>}
                          box {<0.1,0.1,-0.2>,WINDOW_SIZE+<-0.1,-0.1,0.7>}
                          texture {PaintTexture}
                          bounded_by{box {<0,0,-0.1>,WINDOW_SIZE+<0,0,0.6>}}
                          translate WINDOW_LOCATION
                          }
               union {    //cityscape section
                     //actual cityscape is constructed within a <0,0,0>,<1,1,1> box
                     //(with clipping) and then scaled to fit the #declared values
                     //above
                     light_source { <0.5,0.9,0.5> color (White+Yellow)/4    //was /3
                                    fade_power 2
                                    fade_distance 1
                                    }
                     difference { //concealed box masking cityscape from rest of scene
                          box {<-0.01,-0.01,0>,<1.01,1.01,1.01>}
                          box {<0,0,-0.01>,<1,1,1>}
                          bounded_by{box {<-0.01,-0.01,0>,<1.01,1.01,1.01>}}
                          pigment{color Black}
                          }
                     intersection {
                                  union {   //the cityscape is constructed here
                                        box {<0,0,0>,<1,0.01,1>            //basic ground
                                            pigment { color rgb<0.5,0.5,0.5>}
                                            }
                                        box {<0,0,0>,<1,0.015,0.3>      //road surface
                                            pigment { color rgb<0.1,0.1,0.1>}
                                            }
                                        #declare XPos=0;    //road markings
                                        #while (XPos<1)
                                               box{<XPos,0,0.125>,<XPos+0.2,0.02,0.175>
                                                   pigment { color rgb<0.6,0.4,0.1>}
                                                   }
                                               #declare XPos=XPos+0.3;
                                        #end
                                        union {    //tall office block
                                              box{ 0,1    //building
                                                   texture {
                                                           pigment { color rgb<0.3,0.5,0.5>}
                                                           normal { brick 0.05 scale 0.015 }
                                                           }
                                                   }
                                              #declare XPos=0.1;    //windows
                                              #while (XPos<1)
                                                     #declare YPos=0.2;
                                                     #while (YPos<1)
                                                            box {<XPos,YPos,-0.01>,<XPos+0.1,YPos+0.2,1>
                                                                texture {
                                                                        pigment { color Yellow }
                                                                        finish { ambient OFFICE_WINDOW_AMBIENT }
                                                                        }
                                                                }
                                                            union {
                                                                #declare FramePos=0;
                                                                #while (FramePos<1.1)
                                                                       box {<XPos+FramePos*0.1-0.01,YPos-0.01,-0.02>,<XPos+FramePos*0.1+0.01,YPos+0.21,1>}
                                                                       box {<XPos-0.01,YPos+FramePos*0.2-0.01,-0.02>,<XPos+0.11,YPos+FramePos*0.2+0.01,1>}
                                                                       #declare FramePos=FramePos+0.5;
                                                                #end
                                                                texture {
                                                                        pigment {color Brown}
                                                                        }
                                                                }
                                                            #declare YPos=YPos+0.3;
                                                     #end
                                                     #declare XPos=XPos+0.3;
                                              #end
                                              rotate y*-45
                                              translate <-0.2,0,0.2>
                                             }
                                        union { //smaller office block
                                              box {<0.7,0,0.7>,<1,0.7,1>    //building
                                                  pigment { color rgb<0.6,0.3,0.3>}
                                                  }
                                              //pyramid on top of it
                                              prism {
                                                    linear_spline
                                                    conic_sweep
                                                    0,1,5
                                                    <-1,-1>,<1,-1>,<1,1>,<-1,1>,<-1,-1>
                                                    texture {
                                                            pigment { color rgb <0.3,0.3,0.9> }
                                                            finish {specular 0.2}
                                                            }
                                                    scale 0.15
                                                    translate <0.85,0.7,0.85>
                                                    }
                                              //windows
                                              #declare YPos=0.1;
                                              #while (YPos<0.6)
                                                     union {
                                                           box {<0.8,YPos,0.69>,<0.9,YPos+0.1,1>}
                                                           box {<0.69,YPos,0.8>,<1,YPos+0.1,0.9>}
                                                           texture {
                                                                   pigment{color Yellow}
                                                                   finish{ambient OFFICE_WINDOW_AMBIENT}
                                                                   }
                                                           }
                                                     union {
                                                                #declare FramePos=0;
                                                                #while (FramePos<1.1)
                                                                       box {<0.8+FramePos*0.1-0.01,YPos-0.01,0.69>,<0.8+FramePos*0.1+0.01,YPos+0.11,1>}
                                                                       box {<0.8-0.01,YPos+FramePos*0.1-0.01,0.69>,<0.8+0.11,YPos+FramePos*0.1+0.01,1>}
                                                                       #declare FramePos=FramePos+0.5;
                                                                #end
                                                                texture {
                                                                        pigment {color Brown}
                                                                        }
                                                                }
                                                     #declare YPos=YPos+0.2;
                                              #end
                                              }
                                        }
                                  box {<0,0,0>,<1,1,1> pigment{color Black}}
                                  bounded_by{box {<0,0,0>,<1,1,1>}}
                                  }
                     scale WINDOW_SIZE+<0,0,CITYSCAPE_DEPTH>
                     translate WINDOW_LOCATION+<0,0,0.55>   //this allows for windowframe
                     }
               box {<0,5,-0.1>,<12,4.75,0.6> texture {PaintTexture}
                         #ifdef(TURN_OFF_WALL_SHADOWS)
                               no_shadow
                         #end
                   }  //beam on top of wall
               box {<0,6,-0.1>,<12,6.15,0.6> texture {PaintTexture}
                         #ifdef(TURN_OFF_WALL_SHADOWS)
                               no_shadow
                         #end
                   }  //beam on top of columns
               union {                       //the columns
                     #declare XPos=0.5;
                     #while(XPos<12)
                         lathe {
                               cubic_spline
                             8,
                             <0.4,-0.1>
                             <0.2,0>
                             <0.15,0.2>
                             <0.2,0.4>
                             <0.25,0.7>
                             <0.2,0.9>
                             <0.1,1>
                             <0,1.1>
                           #ifdef(USE_PILLAR_STURM)
                             sturm
                           #end
                             scale <1,1,0.6>
                             translate <XPos,5,0.25>
                         #ifdef(TURN_OFF_WALL_SHADOWS)
                               no_shadow
                         #end
                             }
                         #declare XPos=XPos+1;
                     #end
                     texture {
                             pigment {
					marble
					pigment_map {
						[0 WallPigment]
						[0.9 color rgb <0.3,0.3,0.3>]
						[1 color Red*2/3]
						}
					turbulence 0.9
					scale 0.1
					}
                            normal {
                                   granite 0.05 scale 0.1
                                   }
                             finish {specular 0.1}
                             }
                     }
               }
         }

#ifdef(TEST_WALL_MAKER)
object {Wall}
#end

