// aurora.inc
// Defines an aurora.
//
// Use in an object statement. Scale the basic shape in the x and z directions -
// increased z will make the shape thicker and the aurora brighter. Then add the
// texture and interior, then scale in the y direction and rotate/translate into
// position. See aurora.pov for an example.

// the basic aurora shape - a wavy hollow prism to contain the medium
#declare Aurora =
prism { quadratic_spline
    0, 1, 20,
    <-0.75, -0.202>, <-1, -0.01>, <-1, 0.01>, <-0.75, -0.152>,
    <-0.5, -0.20>, <-0.25, -0.102>, <0, 0.1>, <0.25, 0.252>,
    <0.5, 0.30>, <0.75, 0.202>, <1, 0.01>, <1, -0.01>,
    <0.75, 0.152>, <0.5, 0.20>, <0.25, 0.102>, <0, -0.1>,
    <-0.25, -0.252>, <-0.5, -0.30>, <-0.75, -0.202>, <-1, -0.01>
    hollow
}

// basic aurora surface texture - simply fully transparent
#declare T_Aurora =
texture {
    pigment { rgbt <1,1,1,1> }
}

// an interior declaration for the aurora medium inside the shape
#declare I_Aurora =
interior {
    media {
        // start with full white emission
        emission rgb <1.5,1.5,1.5>
//        absorption rgb <1,1,1>
        // make the aurora brighter at the bottom, fading to the top
        density { planar
        }
        // add narrow, irregular, vertical striping
        density { marble
            turbulence 0.6
            scale 0.1
        }
        // colour_map to give the aurora colours
        // various patterns work well here: bozo, crackle, marble
        density { bozo
            colour_map {
                [0.0 rgb <1,0,0>]
                [0.3 rgb <1,0,0>]
                [0.5 rgb <1,1,0>]
                [0.7 rgb <0,1,0>]
                [1.0 rgb <0,0.8,0.5>]
            }
            turbulence 0.5
            scale 2
        }
    }
}