// dinosur.inc
// Defines a Dinosaur object and various textures.
// See dinosaur.pov for an example.

#declare P_Dino =
pigment { bozo
    colour_map {
        [0.0 rgb <0.3,0.6,0.6>]
        [0.3 rgb <0.5,0.6,0.3>]
        [0.6 rgb <0.9,0.6,0.2>]
        [1.0 rgb <0.9,0.5,0.3>]
    }
}

// a simple dinosur skin texture
#declare T_DinoBlob =
texture {
    pigment { P_Dino }
    normal { bumps 1 scale 0.1 }
}

// a layered skin texture, fading to lighter tones on the underside
#declare T_DinoBody =
texture {
    pigment { P_Dino }
    normal { bumps 1 scale 0.1 }
}
texture {
    pigment { gradient y
        colour_map {
            [0.0 rgbt <1,1,1,0.3>]
            [0.2 rgbt <1,1,1,1>]
            [1.0 rgbt <1,1,1,1>]
        }
        scale 3.2
        translate <0,-1.6,0>
    }
//    normal { bumps 1 scale 0.1 }
}

// the main dinosaur blob shape
#declare DinoBlob =
blob { threshold 0.5
    // main body
    sphere { <0,0,0> 1, 1
        scale <2.6,1.6,1.2>
        texture { T_DinoBody }
        rotate <0,0,35>
        translate <0,3.2,0>
    }
// *** NECK AND HEAD ***
    // first neck segment
    sphere { <0,0,0>, 1, 1
        scale <1.3,0.75,0.55>
        texture { T_DinoBody }
        rotate <0,0,50>
        translate <1.0,4.1,0>
    }
    // second neck segment
    sphere { <0,0,0>, 1, 1
        scale <0.85,0.47,0.38>
        texture { T_DinoBody }
        rotate <0,0,40>
        translate <1.5,4.8,0>
    }
    // third neck segment
    sphere { <0,0,0>, 1, 1
        scale <0.45,0.4,0.33>
        texture { T_DinoBody }
        rotate <0,0,38>
        translate <1.75,5.05,0>
    }
    // fourth neck segment
    sphere { <0,0,0>, 1, 1
        scale <0.45,0.4,0.33>
        texture { T_DinoBody }
        rotate <0,0,38>
        translate <2.0,5.25,0>
    }
    // fifth neck segment
    sphere { <0,0,0>, 1, 1
        scale <0.45,0.35,0.29>
        texture { T_DinoBody }
        rotate <0,0,25>
        translate <2.4,5.4,0>
    }
    // head
    sphere { <0,0,0>, 1, 1
        scale <0.65,0.5,0.4>
        rotate <0,0,65>
        translate <2.8,5.6,0>
    }
    // snout
    sphere { <0,0,0>, 1, 1
        scale <0.9,0.5,0.25>
        texture { T_DinoBody }
        rotate <0,0,-5>
        translate <3.3,5.5,0>
    }
    // neck flap
    sphere { <0,0,0>, 1, 1
        scale <0.7,0.2,0.1>
        texture { T_DinoBody }
        rotate <0,0,20>
        translate <2.4,5.15,0>
    }
    // neck flap 2
    sphere { <0,0,0>, 1, 1
        scale <0.7,0.2,0.1>
        texture { T_DinoBody }
        rotate <0,0,32>
        translate <2.0,4.9,0>
    }
    // right eyebrow top
    sphere { <0,0,0>, 1, 1
        scale <0.13,0.07,0.1>
        translate <3.0,5.9,-0.14>
    }
    // right eyebrow rear
    sphere { <0,0,0>, 1, 1
        scale <0.13,0.07,0.1>
        rotate <0,0,75>
        translate <2.9,5.8,-0.14>
    }
    // right eyebrow bottom
    sphere { <0,0,0>, 1, 1
        scale <0.13,0.07,0.1>
        rotate <0,0,150>
        translate <2.95,5.73,-0.14>
    }
    // left eyebrow top
    sphere { <0,0,0>, 1, 1
        scale <0.13,0.07,0.1>
        translate <3.0,5.9,0.14>
    }
    // left eyebrow rear
    sphere { <0,0,0>, 1, 1
        scale <0.13,0.07,0.1>
        rotate <0,0,75>
        translate <2.9,5.8,0.14>
    }
    // left eyebrow bottom
    sphere { <0,0,0>, 1, 1
        scale <0.13,0.07,0.1>
        rotate <0,0,150>
        translate <2.95,5.73,0.14>
    }
// *** TAIL ***
    // first tail segment
    sphere { <0,0,0>, 1, 1
        scale <1.5,1.0,0.75>
        texture { T_DinoBody }
        rotate <0,0,-15>
        translate <-1.3,3.4,0>
    }
    // second tail segment
    sphere { <0,0,0>, 1, 1
        scale <1.0,0.6,0.4>
        texture { T_DinoBody }
        rotate <0,0,-25>
        translate <-2.15,3.8,0>
    }
    // third tail segment
    sphere { <0,0,0>, 1, 1
        scale <0.63,0.5,0.38>
        texture { T_DinoBody }
        rotate <0,0,-20>
        translate <-2.6,4.1,0>
    }
    // fourth tail segment
    sphere { <0,0,0>, 1, 1
        scale <0.5,0.33,0.25>
        texture { T_DinoBody }
        rotate <0,0,-10>
        translate <-3.0,4.3,0>
    }
    // fifth tail segment
    sphere { <0,0,0>, 1, 1
        scale <0.35,0.23,0.17>
        texture { T_DinoBody }
        rotate <0,0,-5>
        translate <-3.25,4.35,0>
    }
    // sixth tail segment
    sphere { <0,0,0>, 1, 1
        scale <0.3,0.2,0.14>
        texture { T_DinoBody }
        rotate <0,0,-5>
        translate <-3.5,4.42,0>
    }
    // seventh tail segment
    sphere { <0,0,0>, 1, 1
        scale <0.45,0.14,0.1>
        texture { T_DinoBody }
        rotate <0,0,-2>
        translate <-3.82,4.48,0>
    }
// *** LEFT LEG ***
    // first right leg segment
    sphere { <0,0,0>, 1, 1
        scale <1.0,0.6,0.4>
        rotate <0,0,-80>
        rotate <10,0,0>
        translate <-0.75,3.0,-0.6>
    }
    // second right leg segment
    sphere { <0,0,0>, 1, 1
        scale <0.65,0.5,0.35>
        rotate <0,0,-85>
        rotate <13,0,0>
        translate <-0.7,2.5,-0.7>
    }
    // third right leg segment
    sphere { <0,0,0>, 1, 1
        scale <0.8,0.35,0.3>
        rotate <0,0,-100>
        rotate <15,0,0>
        translate <-0.8,1.9,-0.8>
    }
    // fourth right leg segment
    sphere { <0,0,0>, 1, 1
        scale <1.0,0.38,0.38>
        rotate <0,0,-100>
        rotate <15,0,0>
        translate <-0.9,1.2,-0.85>
    }
    // fifth right leg segment
    sphere { <0,0,0>, 1, 1
        scale <0.7,0.2,0.4>
        rotate <0,0,-87>
        rotate <1,0,0>
        translate <-0.92,0.65,-0.87>
    }
    // first right toe
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.15,0.15>
        rotate <0,0,-80>
        rotate <13,0,0>
        translate <-0.92,0.2,-1.15>
    }
    // second right toe
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.15,0.15>
        rotate <0,0,-80>
        rotate <0,0,0>
        translate <-0.92,0.2,-0.9>
    }
    // third right toe
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.15,0.15>
        rotate <0,0,-80>
        rotate <-13,0,0>
        translate <-0.92,0.2,-0.65>
    }
// *** RIGHT LEG ***
    // first left leg segment
    sphere { <0,0,0>, 1, 1
        scale <1.0,0.6,0.4>
        rotate <0,0,-50>
        rotate <-10,0,0>
        translate <-0.7,3.05,0.6>
    }
    // second left leg segment
    sphere { <0,0,0>, 1, 1
        scale <0.65,0.5,0.35>
        rotate <0,0,-48>
        rotate <-13,0,0>
        translate <-0.2,2.7,0.7>
    }
    // third left leg segment
    sphere { <0,0,0>, 1, 1
        scale <0.8,0.35,0.3>
        rotate <0,0,-130>
        rotate <10,0,0>
        translate <-0.2,2.3,0.7>
    }
    // fourth left leg segment
    sphere { <0,0,0>, 1, 1
        scale <1.0,0.38,0.38>
        rotate <0,0,-130>
        rotate <15,0,0>
        translate <-0.6,1.9,0.6>
    }
    // fifth left leg segment
    sphere { <0,0,0>, 1, 1
        scale <0.7,0.2,0.4>
        rotate <0,0,-37>
        rotate <-10,0,0>
        translate <-0.5,1.5,0.67>
    }
    // first left toe
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.15,0.15>
        rotate <0,0,-80>
        rotate <-13,0,0>
        translate <-0.2,1.1,0.95>
    }
    // second left toe
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.15,0.15>
        rotate <0,0,-80>
        rotate <0,0,0>
        translate <-0.2,1.1,0.7>
    }
    // third left toe
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.15,0.15>
        rotate <0,0,-80>
        rotate <13,0,0>
        translate <-0.2,1.1,0.45>
    }
// *** RIGHT ARM ***
    // first right arm segment
    sphere { <0,0,0>, 1, 1
        scale <0.7,0.45,0.3>
        rotate <0,0,-45>
        rotate <30,0,0>
        translate <0.7,3.5,-0.6>
    }
    // second right arm segment
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.2,0.2>
        rotate <0,0,45>
        rotate <45,0,0>
        translate <0.65,3.25,-0.72>
    }
    // third right arm segment
    sphere { <0,0,0>, 1, 1
        scale <0.85,0.25,0.25>
        rotate <0,0,33>
        rotate <40,0,0>
        translate <0.4,2.95,-0.85>
    }
    // fourth right arm segment
    sphere { <0,0,0>, 1, 1
        scale <1.0,0.25,0.25>
        rotate <0,0,-10>
        rotate <20,0,0>
        translate <0.45,2.6,-0.95>
    }
    // fifth right arm segment
    sphere { <0,0,0>, 1, 1
        scale <1.0,0.2,0.2>
        rotate <0,0,-13>
        rotate <20,0,0>
        translate <1.2,2.45,-1.05>
    }
    // first right finger
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-25>
        rotate <35,0,0>
        translate <1.8,2.3,-1.2>
    }
    // first right finger claw
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-45>
        rotate <35,0,0>
        translate <1.95,2.2,-1.25>
    }
    // second right finger
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-25>
        rotate <20,0,0>
        translate <1.8,2.3,-1.1>
    }
    // second right finger claw
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-45>
        rotate <20,0,0>
        translate <1.95,2.2,-1.13>
    }
    // third right finger
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-25>
        rotate <5,0,0>
        translate <1.8,2.3,-1.0>
    }
    // third right finger claw
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-45>
        rotate <5,0,0>
        translate <1.95,2.2,-1.01>
    }
// *** LEFT ARM ***
    // first left arm segment
    sphere { <0,0,0>, 1, 1
        scale <0.7,0.45,0.3>
        rotate <0,0,-45>
        rotate <-30,0,0>
        translate <0.7,3.5,0.6>
    }
    // second left arm segment
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.2,0.2>
        rotate <0,0,45>
        rotate <-45,0,0>
        translate <0.65,3.25,0.72>
    }
    // third left arm segment
    sphere { <0,0,0>, 1, 1
        scale <0.85,0.25,0.25>
        rotate <0,0,33>
        rotate <-40,0,0>
        translate <0.4,2.95,0.85>
    }
    // fourth left arm segment
    sphere { <0,0,0>, 1, 1
        scale <1.0,0.25,0.25>
        rotate <0,0,-10>
        rotate <-20,0,0>
        translate <0.45,2.6,0.95>
    }
    // fifth left arm segment
    sphere { <0,0,0>, 1, 1
        scale <1.0,0.2,0.2>
        rotate <0,0,-13>
        rotate <-20,0,0>
        translate <1.2,2.45,1.05>
    }
    // first left finger
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-25>
        rotate <-35,0,0>
        translate <1.8,2.3,1.2>
    }
    // first left finger claw
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-45>
        rotate <-35,0,0>
        translate <1.95,2.2,1.25>
    }
    // second left finger
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-25>
        rotate <-20,0,0>
        translate <1.8,2.3,1.1>
    }
    // second left finger claw
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-45>
        rotate <-20,0,0>
        translate <1.95,2.2,1.13>
    }
    // third left finger
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-25>
        rotate <-5,0,0>
        translate <1.8,2.3,1.0>
    }
    // third left finger claw
    sphere { <0,0,0>, 1, 1
        scale <0.4,0.07,0.07>
        rotate <0,0,-45>
        rotate <-5,0,0>
        translate <1.95,2.2,1.01>
    }
    // apply general blob texture to all parts without specific texture
    texture { T_DinoBlob }
}

// difference the basic blob shape with a mouth cutout
#declare DinoMouth =
difference {
    object { DinoBlob }
    superellipsoid { <0.6,0.6>
        rotate <0,0,45>
        scale <1,0.12,1>
        translate <4.2,5.47,0>
    }
}

// eye texture
#declare T_DinoEye =
texture {
    pigment { radial
        colour_map {
            [0.0 rgb <1,1,0>]
            [0.45 rgb <1,1,0>]
            [0.46 rgb <0,0,0>]
            [0.54 rgb <0,0,0>]
            [0.55 rgb <1,1,0>]
            [1.0 rgb <1,1,0>]
        }
    }
    finish {
        specular 0.7
        roughness 0.001
    }
}

// teeth texture
#declare T_DinoTeeth =
texture {
    pigment { rgb <1,1,1> }
    finish { ambient 0.8 }
}

// mouth interior texture
#declare T_DinoMouth =
texture {
    pigment { rgb <1.0,0.3,0.2> }
}

// add the eyes and teeth and the mouth interior texture
#declare Dinosaur =
union {
    object { DinoMouth }
    // eyes
    sphere { <0,0,0> 0.1
        texture { T_DinoEye }
        rotate <0,-130,0>
        translate <3.0,5.8,-0.15>
    }
    sphere { <0,0,0> 0.1
        texture { T_DinoEye }
        rotate <0,130,0>
        translate <3.0,5.8,0.15>
    }
    // teeth
    #declare N = 0;
    #while (N < 8)
    // right lower
    cone { <0, 0, 0>, 0.007, <0,0.07,0>, 0
        texture { T_DinoTeeth }
        translate <3.67-N/16, 5.38+N/100, -0.04-N/100>
    }
    // left lower
    cone { <0, 0, 0>, 0.007, <0,0.07,0>, 0
        texture { T_DinoTeeth }
        translate <3.67-N/16, 5.38+N/100, 0.04+N/100>
    }
    // right upper
    cone { <0, 0, 0>, 0, <0,0.07,0>, 0.007
        texture { T_DinoTeeth }
        translate <3.7-N/16, 5.5-N/150, -0.04-N/100>
    }
    // left upper
    cone { <0, 0, 0>, 0, <0,0.07,0>, 0.007
        texture { T_DinoTeeth }
        translate <3.7-N/16, 5.5-N/150, 0.04+N/100>
    }
    #declare N = N+1;
    #end
    texture { T_DinoMouth }
}
