// dmirtc1.pov
// The underground sea from Jules Verne's "Journey to the Centre of the Earth"
// David Morgan-Mar

// development switches
#declare AreaLights = 1;
#declare Blur = 1;
#declare Floor = 1;
#declare NormalCave = 1;
#declare Fungus = 1;
#declare Clouds = 1;
#declare Mushrooms = 1;
#declare Aurorae = 1;
#declare Dino = 1;
#declare Pteros = 1;

#if (Mushrooms)
#include "mushroom.inc"
#end
#if (Aurorae)
#include "aurora.inc"
#end
#if (Dino)
#include "dinosaur.inc"
#end
#if (Pteros)
#include "pterosaur.inc"
#end

// parameters
#declare AuroraX = 15;
#declare AuroraHeight = 0.5;
#declare CloudHeight = 2.5;

global_settings {
#if (Clouds & Aurorae)
    // set max_trace_level higher to avoid black pixels in overlapping
    // aurora/cloud areas
    max_trace_level 10
#end
}

// camera and light sources
camera {
    location <30,0.2,0>
    look_at <0,0.15,0>
#if (Blur)
    aperture 0.01
    blur_samples 20
    focal_point <28.5,0,0>
#end
}

light_source { <5,3,0> colour rgb <2,2,2>
#if (AreaLights)
    area_light <20,0,0>, <0,2,0>, 10, 3
#end
}
light_source { <29,2,0> colour rgb <1,1,1>
    spotlight
    point_at <30,0.2,0>
    radius 10
    falloff 12
}
light_source { <30,0.1,-0.1> colour rgb <1,1,1>
    shadowless
}

light_source { <31,0.19,0> colour rgb <1,0.8,0.5>
    spotlight
    point_at <28.7,0.1,0>
    radius 15
    falloff 20
}
/*
light_source { <26,2.2,0> colour rgb <0.3,0.3,0.3>
    shadowless
}
*/


// normal texture component for rock wall
#declare N_cave =
normal { granite 1 }

// cavern wall rock texture
#declare T_cave =
texture {
    pigment { marble
        colour_map {
           [ 0.0     rgbft <0.895833, 0.895833, 0.895833, 0.0, 0.0> ]
           [ 0.099644  rgbft <0.802067, 0.781233, 0.855527, 0.0, 0.0> ]
           [ 0.19573  rgbft <0.895833, 0.828431, 0.739567, 0.0, 0.0> ]
           [ 0.295374  rgbft <0.827957, 0.768817, 0.755376, 0.0, 0.0> ]
           [ 0.395018  rgbft <0.701727, 0.73574, 0.714809, 0.0, 0.0> ]
           [ 0.501779  rgbft <0.763582, 0.742634, 0.694751, 0.0, 0.0> ]
           [ 0.594306  rgbft <0.781233, 0.73834, 0.625, 0.0, 0.0> ]
           [ 0.697509  rgbft <0.662791, 0.709302, 0.712209, 0.0, 0.0> ]
           [ 0.797153  rgbft <0.699292, 0.645833, 0.592374, 0.0, 0.0> ]
           [ 0.896797  rgbft <0.674936, 0.605279, 0.554198, 0.0, 0.0> ]
           [ 1.0     rgbft <0.692647, 0.695752, 0.5625, 0.0, 0.0> ]
    }
        turbulence 2
    }
    #if (NormalCave)
    normal { N_cave }
    #end
}
// the cavern itself - simply the inside of a scaled sphere!
sphere { <0,0,0> 10
    scale <5,0.4,1>
    texture { T_cave scale 4 }
    inverse
}

#if (Fungus)
// second sphere layered inside first to add glowing fungus and glow-worms
// first a layered texture
#declare T_fungus =
texture { // fungus layer
    pigment { agate
        colour_map {
            [0.0 rgbf <0.2,0.8,0,0>]
            [0.07 rgbf <1,1,1,1>]
        }
        frequency 5
    }
    #if (NormalCave)
    normal { N_cave }
    #end
    finish {
        ambient 0.6
    }
}
texture { // glow-worm layer
    pigment { granite
        colour_map {
            [0.0 rgbf <1,1,0.6,0>]
            [0.04 rgbf <1,1,0.6,0>]
            [0.041 rgbf <1,1,1,1>]
        }
        frequency 3
        turbulence 0.2
    }
//    #if (NormalCave)
    normal { N_cave }
//    #end
    finish {
        ambient 1
    }
}
// the glowing fungus sphere, a bit smaller than the cavern sphere, scaled the same
sphere { <0,0,0> 9.999
    scale <5,0.4,1>
    texture { T_fungus scale 4 }
    inverse
}
#end // Fungus

// the underground sea
plane { y, -0.3
    texture {
        pigment { cylindrical
            colour_map {
                [0.0 rgbf <0,0.25,0.5,0.5> ]
                [0.1 rgbf <0,0.25,0.4,0.5> ]
                [0.3 rgbf <0,0.25,0.3,0.5> ]
                [1.0 rgbf <0,0.2,0.2,0.5> ]
            }
            scale 30
        }
    }
    normal { waves 0.4
        frequency 80
        turbulence 0.3
        scale 6
    }
}
plane { y, -0.301
    texture {
        pigment { rgb <0.6,1,0.8> }
    }
    finish {
        ambient 1
    }
}

#if (Clouds)
// cloud layer
#declare T_clouds =
texture {
    pigment { bozo
        colour_map {
            [0.0 rgbf <0.85,0.85,0.85,0>]
            [0.04 rgbf <1,1,1,0>]
            [0.1 rgbf <1,1,1,0>]
            [0.2 rgbt <1,1,1,1>]
            [1.0 rgbt <1,1,1,1>]
        }
        translate <30,0,0>
        frequency 1
        turbulence 0.2
    }
    normal { bozo 0.3
        turbulence 0.1
        scale 0.4
    }
    finish {
        ambient 0.6
    }
}
plane { y, 2.2
    texture { T_clouds scale 1.5}
    inverse
}
#end // Clouds

#if (Floor)
// the shoreline, with rocks
height_field { png "floor.png"
    smooth
    water_level 0.0001
    translate <-0.5,0,-0.5> // centre in horizontal plane
    rotate <0,-90,0> // rotate into correct orientation
    scale <20,0.5,20>
    translate <30,-0.3001,0>
    texture { T_cave scale 0.8 }
}
#end // Floor

#if (Mushrooms)
// the mushrooms
#declare R1 = seed(1);
Mushroom(0,1,28.7,-0.3,0.6,0.7,290)
#declare Loop = 0;
#while (Loop < 20)
    Mushroom(int(3*rand(R1)),0,27.5+2*rand(R1),-0.28,rand(R1),0.02+0.1*rand(R1),360*rand(R1))
    #declare Loop = Loop + 1;
#end
#end // Mushrooms

#if (Aurorae)
// the aurorae
object {
    Aurora
    scale <2,1,3>
    rotate <0,90,10>
    translate <AuroraX,0,0>
    texture { T_Aurora }
    interior { I_Aurora }
    scale <1,2,1>
    translate <0,AuroraHeight,0>
}
object {
    Aurora
    scale <2,1,3>
    rotate <0,70,-10>
    texture { T_Aurora }
    interior { I_Aurora }
    rotate <0,180,0>
    translate <AuroraX,0,0>
    scale <1,2,1>
    translate <0,AuroraHeight,3>
}
object {
    Aurora
    scale <2,1,3>
    texture { T_Aurora }
    interior { I_Aurora }
    rotate <0,70,-10>
    translate <AuroraX,0,0>
    scale <1,2,1>
    translate <0,AuroraHeight,-3>
}
#end // Aurora

#if (Dino)
// the dinosaur
object {
    Dinosaur
    scale <0.1,0.1,0.1>
    rotate <0,-50,0>
    translate <28.5,-0.28,-0.45>
}
object {
    Dinosaur
    scale <0.03,0.03,0.03>
    matrix <1,0,0,
            0,1,0,
            0,0,-1,
            0,0,0>
    rotate <0,70,0>
    translate <29.1,-0.27,0.3>
}
#end // Dino

#if (Pteros)
// pterosaurs, in order of distance from camera
// close on left foreground, banking left
object {
    Pterosaur
    scale <0.5,0.5,0.5>
    rotate <35,0,-5>
    rotate <0,30,0>
    translate <23,1.7,-3.0>
}
// flying right at centre left above mushroom
object {
    Pterosaur
    scale <0.5,0.5,0.5>
    rotate <-15,0,5>
    rotate <0,-80,0>
    translate <21,3.2,-2.0>
}
// rear view of full wingspan, between pterosaur 1 and mushroom
object {
    Pterosaur
    scale <0.5,0.5,0.5>
    rotate <10,0,5>
    rotate <0,145,0>
    translate <19,1.9,-2.5>
}
// under lip of mushroom, centre
object {
    Pterosaur
    scale <0.4,0.4,0.4>
    rotate <10,0,5>
    rotate <0,-15,0>
    translate <16,1.2,0.5>
}
// near water, centre left
object {
    Pterosaur
    scale <0.3,0.3,0.3>
    rotate <-20,0,0>
    rotate <0,-115,0>
    translate <14,0.4,-2.2>
}

#end
