// pterosaur.inc
// Defines a Pterosaur object. See dinosaur.pov for example.
//
// Transforming the Pterosaur object:
// rotate <45,0,0>  - bank to the left
// rotate <-45,0,0> - bank to the right
// rotate <0,0,45>  - climb
// rotate <0,0,-45> - dive

#declare RightPteroWing =
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
  <0.003130, 3.884194, 0.000000>, <0.001565, 2.694836, 0.000000>, <0.000000, 1.505477, 0.000000>, <-0.001565, 0.128326, 0.000000>, 
  <1.317684, 4.070423, -0.000923>, <2.192488, 3.381847, 0.000000>, <3.192488, 2.693271, 0.000000>, <4.380282, 1.816901, 0.000000>, 
  <2.444444, 4.194053, 0.000000>, <4.133020, 3.818466, 0.000000>, <5.258216, 3.255086, 0.000000>, <8.136150, 2.441315, -1.001565>, 
  <4.823161, 4.568075, 0.000000>, <6.198748, 4.317684, 0.000000>, <9.139280, 3.754304, -0.312989>, <15.397496, 1.500782, -3.067293>
}

#declare LeftPteroWing =
bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
  <-0.003130, 3.884194, 0.000000>, <-0.001565, 2.694836, 0.000000>, <-0.000000, 1.505477, 0.000000>, <0.001565, 0.128326, 0.000000>, 
  <-1.317684, 4.070423, -0.000923>, <-2.192488, 3.381847, 0.000000>, <-3.192488, 2.693271, 0.000000>, <-4.380282, 1.816901, 0.000000>, 
  <-2.444444, 4.194053, 0.000000>, <-4.133020, 3.818466, 0.000000>, <-5.258216, 3.255086, 0.000000>, <-8.136150, 2.441315, -1.001565>, 
  <-4.823161, 4.568075, 0.000000>, <-6.198748, 4.317684, 0.000000>, <-9.139280, 3.754304, -0.312989>, <-15.397496, 1.500782, -3.067293>
}

#declare T_PteroWings =
texture {
    pigment { crackle
        colour_map {
            [0.0 rgb <0.52,0.45,0.4>]
            [0.5 rgb <0.6,0.4,0.3>]
            [1.0 rgb <0.5,0.5,0.4>]
        }
        scale 0.3
        turbulence 0.1
    }
    normal { wrinkles 1
        scale 0.1
    }
}

#declare PteroWings =
union {
    object { RightPteroWing }
    object { LeftPteroWing }
    scale <0.3,0.3,0.3>
    rotate <-90,0,0>
    rotate <0,-90,0>
    texture { T_PteroWings }
}

#declare T_PteroBody =
texture {
    pigment { gradient y
        colour_map {
            [0.0 rgb <1.0,0.9,0.8>]
            [1.0 rgb <0.5,0.4,0.3>]
        }
        scale 0.6
        translate <0,-0.3,0>
    }
    normal { bumps 1
        scale 0.01
    }
}

#declare T_PteroHead =
texture {
    pigment { gradient x
        triangle_wave
        colour_map {
            [0.0 rgb <0.8,0.5,0.1>]
            [0.1 rgb <0.6,0.5,0.4>]
            [0.2 rgb <0.8,0.4,0.4>]
            [1.0 rgb <0.9,0.9,0.9>]
        }
        turbulence 0.2
        scale 1.5
    }
    normal { bumps 0.5
        scale 0.3
    }
}

#declare PteroBody =
blob { threshold 0.5
    // body
    sphere { <0,0,0> 1, 1
        scale <2,0.3,0.3>
        translate <1,0,0>
    }
    // head
    sphere { <0,0,0> 1, 1
        scale <1.5,0.15,0.15>
        texture { T_PteroHead }
        rotate <0,0,-30>
        translate <2.1,0.1,0>
    }
    // right arm
    sphere { <0,0,0> 1, 1
        scale <1.4,0.1,0.1>
        rotate <0,82,0>
        translate <1.32,0,-0.8>
    }
    // left arm
    sphere { <0,0,0> 1, 1
        scale <1.4,0.1,0.1>
        rotate <0,-82,0>
        translate <1.32,0,0.8>
    }
    // right leg
    sphere { <0,0,0> 1, 1
        scale <0.4,0.05,0.05>
        rotate <0,0,15>
        translate <-0.1,-0.1,-0.1>
    }
    // left leg
    sphere { <0,0,0> 1, 1
        scale <0.4,0.05,0.05>
        rotate <0,0,15>
        translate <-0.1,-0.1,0.1>
    }
    texture { T_PteroBody }
}

#declare PteroEyes =
union {
    sphere { <0,0,0.075> 0.05 }
    sphere { <0,0,-0.075> 0.05 }
    texture {
        pigment { wood
            colour_map {
                [0.0 rgb <0,0,0>]
                [0.1 rgb <0,0,0>]
                [0.15 rgb <0.9,0.8,0.1>]
                [1.0 rgb <0.8,0.7,0.1>]
            }
            scale 0.3
        }
        finish {
            specular 1
            roughness 0.001
        }
    }
    translate <2.3,0,0>
}

#declare Pterosaur =
union {
    object { PteroWings }
    object { PteroBody }
    object { PteroEyes }
}