
// Glenn's POV-Ray Object File - Dreadnought
// created 5-Feb-99
// last update 16-Feb-99
// copyright 1999 Glenn McCarter
// This file does not render.  #include "Dreadnought.inc" in another .pov file
//
// Objects:
// PatrolShip
//
// A dreadnought-style Class II semi-autonomous patrol ship
//
//
// Origin at center of main fuselage
// +Z towards rear of ship
// Intended scale is English system (inches)
// Uses LH coordinate reference system (Y=up)
// For POV-Ray version 3.1+

#include "Vane1.pov"



//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare PatrolShipFinish =
//	finish { ambient .48 diffuse .7 specular .8 roughness .15 }
	finish { ambient .08 diffuse .7 specular .8 roughness .15 }
#declare PatrolShipStripeFinish =
	finish { ambient .18 diffuse .7 specular .9 roughness .06 }

#declare PatrolShipTex =
	texture {
		pigment { color rgb<.7,.8,1> }
//		normal { bumps .09 scale 3*Feet }
//		finish { ambient .28 diffuse .7 specular .8 roughness .005 }
//		finish { ambient .48 diffuse .7 specular .8 roughness .005 } // too hot spots
//		finish { ambient .48 diffuse .7 specular .8 roughness .15 }
		finish { PatrolShipFinish }
	}

#declare BrightWhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient 5.98 }
	}

#declare HeadlightTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient 1.5 diffuse .9 }
	}

#declare FlatBlackTex =
	texture {
		pigment { color rgb<0,0,0> }
		finish { ambient .02 diffuse .1 specular .2 roughness .05 }
	}

#declare Stripe1Tex=
texture {
	pigment {
		image_map { gif "stripe1.gif" transmit 15 1 once}
		translate <-.5,-.5,0>
	}
	finish { PatrolShipStripeFinish }
}
#declare Detail1Tex=
texture {
	pigment {
		image_map { gif "detail1.gif" transmit 15 1 once}
		translate <-.5,-.5,0>
	}
	finish { PatrolShipFinish }
}


//===============================================
//             Lights
//===============================================

#declare ShowCone =
	cone {
		<0,.1*Feet,0>,0,<0,100*Feet,0>,20*Feet
		texture { pigment {rgb<.1,.1,1>} finish { ambient .6 } }
	}
#declare UpSpot =
//	union {
//		object { ShowCone }
	light_source {
		<0,0,0>
//		color rgb <0.890,0.725,0.661>*0.7
//		color rgb <0.890,0.725,0.361>*0.3 // peachy yellow
//		color rgb <0.690,0.725,0.961>*0.3 // blueish
		color rgb <0.960,0.625,0.361>*0.3 // reddish
		spotlight
		point_at <0,10*Feet,0>
		radius 20    // degrees fully lit (*2)
		falloff 42   // degrees no lighting (*2)
		tightness 1
		looks_like {
			sphere {
				<0,0,0>, .01*Feet
				texture {
					pigment { color rgb<1,1,1> }
					finish { ambient 2 diffuse .8 }
				}
			}
		}
		media_interaction off
		fade_distance 240*Feet
		fade_power 1
	}
//	}
#declare DownSpot =
	light_source {
		<0,0,0>
		color rgb <0.960,0.625,0.361>*0.3 // reddish
		spotlight
		point_at <0,10*Feet,0>
		radius 35    // degrees fully lit (*2)
		falloff 62   // degrees no lighting (*2)
		tightness 1
		looks_like {
			sphere {
				<0,0,0>, .01*Feet
				texture {
					pigment { color rgb<1,1,1> }
					finish { ambient 2 diffuse .8 }
				}
			}
		}
		media_interaction off
		fade_distance 240*Feet
		fade_power 1
	}

#declare HeadlightSpot =
	light_source {
		<0,0,0>
		color rgb <0.960,0.625,0.361>*1.3 // reddish
		spotlight
		point_at <0,0,-10*Feet>
		radius 18    // degrees fully lit (*2)
		falloff 28   // degrees no lighting (*2)
		tightness 1
		media_interaction off
		fade_distance 440*Feet
		fade_power 1
	}


#declare LightGroup =
	union {
		object { UpSpot rotate <0,0,-25> translate <-36*Feet,-160*Feet,-100*Feet> } //lower pod up
		object { UpSpot rotate <0,0, 25> translate < 36*Feet,-160*Feet,-100*Feet> } //lower pod up

		object { DownSpot rotate <180,0, 35> translate <-36*Feet,-182*Feet,-100*Feet> } //lower pod highlight
		object { DownSpot rotate <-18,0,-35> translate < 26*Feet,-192*Feet,-100*Feet> } //lower pod far side uplight

    object { UpSpot rotate <-40,0,-70> translate <-140*Feet,-60*Feet,100*Feet> } // wing
    object { HeadlightSpot rotate <-2,0,0> translate < 0*Feet,-180*Feet,-170*Feet> } // headlight
	}

//===============================================
//             Objects
//===============================================

#macro Slab(X1,X2,Thickness,Length,LeadingEdgeZScale)
	union {
		box { <X1,-Thickness/2,0>,<X2,Thickness/2,Length> }
		cylinder { <X1,0,0>,<X2,0,0>,Thickness/2 scale <1,1,LeadingEdgeZScale> }
		sphere { <0,0,0>,Thickness/2 scale <1,1,LeadingEdgeZScale> translate <X1,0,0> }
		sphere { <0,0,0>,Thickness/2 scale <1,1,LeadingEdgeZScale> translate <X2,0,0> }
//		sphere { <0,0,0>,20*Feet translate <55*Feet,0,0> }
//		sphere { <0,0,0>,20*Feet translate <-40*Feet,0,0> }
//		sphere { <-60*Feet,0,0>,20*Feet }
	}
#end

#declare GunBarrel =
	union {
		cylinder { <0,0,0>,<20*Feet,0,0>,2.8*Feet }
		difference {
			cylinder { <0,0,0>,<40*Feet,0,0>,0.8*Feet }
			cylinder { <-1,0,0>,<41*Feet,0,0>,0.5*Feet }
		}
	}
#declare Gun2Group =
	union {
		object { GunBarrel translate <-12*Feet,0,-4*Feet> }
		object { GunBarrel translate <-12*Feet,0, 4*Feet> }
	}
#declare GunMount =
	union {
		torus { 10*Feet,1*Feet rotate z*90 }
		cylinder { <0,0,-10*Feet>,<0,0,10*Feet>,1*Feet } // gymbal
		cylinder { <0,10*Feet,0>,<0,16*Feet,0>,2*Feet } // vert mount
		cylinder { <0,15*Feet,0>,<0,19*Feet,0>,3*Feet } // vert mount
	}
#macro GunGroup(Zelev,Yrot)
	union {
		object { Gun2Group rotate <0,0,Zelev> rotate y*Yrot }
		object { GunMount rotate y*Yrot }
		texture { PatrolShipTex }
	}
#end

#declare PWingShape =
	union {
		object { Slab(0,140*Feet,12*Feet,60*Feet,1.8)
//			rotate z*-12
		}
		cylinder { // outboard pod
			<0,0,-12*Feet>,<0,0,60*Feet>,16*Feet
			translate <80*Feet,-20*Feet,0>
//			rotate z*-12
		}
		sphere { // outboard pod front end
			<0,0,-12*Feet>,16*Feet
			scale <1,1,2.8>
			translate <80*Feet,-20*Feet,0>
//			rotate z*-12
		}
		texture { PatrolShipTex }
	}
#declare PLeftWing =
	union {
		object { PWingShape }
		object { GunGroup(-12,90) translate <120*Feet,-24*Feet,0> }
	}
#declare PRightWing =
	union {
		object { PWingShape scale <-1,1,1> }
		object { GunGroup(-32,135) translate <-120*Feet,-24*Feet,0> }
	}

#declare PTail =
	union {
		object { Slab(0,100*Feet,8*Feet,50*Feet,1) // vertical
			rotate z*90
		}
		object { Slab(-40*Feet,40*Feet,4*Feet,35*Feet,1) // horizontal
			translate <0,85*Feet,0>
		}
		cylinder { // periscope
			<0,0,0>,<0,30*Feet,0>,2.7*Feet
			translate <0,95*Feet,20*Feet>
		}
		cylinder { // periscope
			<0,0,0>,<0,70*Feet,0>,1.4*Feet
			translate <0,95*Feet,52*Feet>
		}
		cylinder { // support
			<0,0,0>,<0,85*Feet,0>,3.4*Feet
			scale <1,1,2>
			translate <15*Feet,0*Feet,16*Feet>
		}
		cylinder { // support
			<0,0,0>,<0,85*Feet,0>,3.4*Feet
			scale <1,1,2>
			translate <-15*Feet,0*Feet,16*Feet>
		}

		texture { PatrolShipTex }
	}

#declare HRad = 360*Feet/2;
#declare Cradle =
	intersection { // cutaway junk
		union { // add round and square parts
			difference {
				sphere { // main
					<0,0,0>,HRad
					scale <.5,.5,1>
					scale 1.12
				}
				sphere { // inner
					<0,0,0>,HRad
					scale <.5,.5,1>
					scale 1.08
				}
			} // end difference
			box {
				<-20*Feet,-140*Feet,-160*Feet>,<-16*Feet,0,-60*Feet>
			}
			box {
				< 20*Feet,-140*Feet,-160*Feet>,< 16*Feet,0,-60*Feet>
			}
			cylinder {
				<-22*Feet,0,0>,<22*Feet,0,0>,40*Feet
				translate <0,-140*Feet,-85*Feet>
			}
		} // end union
		box {
			<-200*Feet,-150*Feet,-100*Feet>,<200*Feet,-50*Feet,-0*Feet>
			rotate x*12
		}
		cylinder {
			<0,0,-200*Feet>,<0,0,200*Feet>,80*Feet
			inverse
		}
		texture { PatrolShipTex }
	} // end intersection

               
#declare HeadLightAssy =
	union {
		difference {
			sphere { // main pod
				<0,0,0>,40*Feet
				scale <.2,.2,1,>
			}
			cylinder {
				<0,0,-20*Feet>,<0,0,0>,12*Feet
				translate <0,0,-33*Feet>
				texture { FlatBlackTex }
			}
		} // end difference
		sphere { // front pod
			<0,0,0>,3*Feet
			scale <.7,.7,1,>
			translate <0,0,-40*Feet>
//			texture { HeadlightTex }
			texture { PatrolShipTex }
		}
		texture { PatrolShipTex }
	}

#declare LVane =
	object { VaneShape rotate <13,0,0> scale 300*Feet texture { PatrolShipTex } }
#declare RVane =
	object { VaneShape scale <-1,1,1> rotate <13,0,0> scale 300*Feet texture { PatrolShipTex } }

#declare PLowerPod =
	union {
		object { LVane translate <-30*Feet,-140*Feet,0*Feet> }
		object { RVane translate <30*Feet,-140*Feet,0*Feet> }
		cylinder { // vane support
			<-30*Feet,0,0>,<30*Feet,0,0>,5*Feet
			translate <0,-110*Feet,30*Feet>
		}
		difference {
		object { Slab(0,200*Feet,16*Feet,120*Feet,1.6)
			rotate z*90
			translate <0,-200*Feet,0>
		}
			cylinder {
				<-20*Feet,0,0>,<20*Feet,0,0>,50*Feet
				translate <0,-170*Feet,100*Feet>
			}
		texture { PatrolShipTex }
		texture { Stripe1Tex rotate y*90 scale <100*Feet,200*Feet,140*Feet> translate <0,-90*Feet,-10*Feet> }

		} // end difference
		cylinder { // leading edge vert
			<0,0,0>,<0,-200*Feet,0>,8*Feet
		}
		sphere {
			<0,-200*Feet,0>,8*Feet
		}
		box { // crossbar
			<-34*Feet,0,5*Feet>,<34*Feet,4*Feet,35*Feet>
			translate <0,-175*Feet,0>
		}
		object { HeadLightAssy translate <-34*Feet,-175*Feet,0> }
		object { HeadLightAssy translate < 34*Feet,-175*Feet,0> }
		cylinder { // nautilus axis
			<-22*Feet,0,0>,<22*Feet,0,0>,18*Feet
			translate <0,-135*Feet,20*Feet>
		}
		sphere { // main keel
			<0,0,0>,12*Feet
			scale <.6,.6,4>
			rotate <0,0,0>
			translate <0,-218*Feet,40*Feet>
			texture { PatrolShipTex }
			texture { Stripe1Tex rotate y*90 scale <100*Feet,200*Feet,40*Feet> translate <0,-190*Feet,19*Feet> }
		}
		sphere { // keel front end
			<0,0,0>,2*Feet
			texture { HeadlightTex }
			translate <0,-218*Feet,-10*Feet>
		}
		cylinder { // keel front tip
			<0,0,-70*Feet>,<0,0,0>,.8*Feet
			translate <0,-218*Feet,40*Feet>
		}
		sphere { // keel front tip
			<0,0,0>,1.1*Feet
			scale <1,1,4>
			translate <0,-218*Feet,40*Feet-70*Feet>
		}
		cylinder { // keel support
			<0,0,0>,<0,20*Feet,0>,6*Feet
			scale <.6,1,3>
			translate <0,-220*Feet,40*Feet>
			texture { PatrolShipTex }
			texture { Detail1Tex rotate y*90 scale <20*Feet,16*Feet,30*Feet> translate <0,-210*Feet,35*Feet> }
		}
		texture { PatrolShipTex }
//		texture { Stripe1Tex rotate y*90 scale <100*Feet,200*Feet,40*Feet> translate <0,-130*Feet,13*Feet> }
	}
#declare PNose =
	sor {
//		cubic_spline
		9,
		<44.0,-40>
		<40.0,  0> // base
		<39.0, 10>
		<36.0, 20>
		<28.0, 30>
		<11.5, 50>
		< 3.3, 80>
		< 0.0,110> // tip
		< 0.0,130> // tip
//		sturm
		rotate x*-90
		scale 1*Feet
		texture { PatrolShipTex }
	}

#declare PFuselage =
	union {
		object { Cradle translate <0,0,0> }
//		object { RVane translate <0,0,0> }
		difference {
			sphere { // main
				<0,0,0>,360*Feet/2
				scale <.5,.5,1>
			}
			cylinder { // cutout for nose
				<0,0,0>,<0,0,60*Feet>,44*Feet
				translate <0,0,-200*Feet>
				texture { FlatBlackTex }
			}
 		} // end difference
		difference {
			sphere { // top pod
				<0,0,0>,360*Feet/2
				scale <.5,.5,1>
				scale .7
			}
			box { // window cutout
				<-20*Feet,0,0>,<20*Feet,6*Feet,60*Feet>
				translate <0,40*Feet,-90*Feet>
			}
			translate <0,60*Feet,70*Feet> // position to ship
		} // end difference
			texture { PatrolShipTex }
			texture { Stripe1Tex rotate y*90 scale <100*Feet,200*Feet,100*Feet> translate <0,0,-130*Feet> }
	}


//---------------- Patrol Ship --------------------

#declare PatrolShip =
	union {
		object { PFuselage }
		object { PNose rotate y*0 translate <0,0,-150*Feet> }
		object { PLeftWing translate <0,-40*Feet,80*Feet> }
		object { PRightWing translate <0,-40*Feet,80*Feet> }
		object { PLowerPod translate <0,0,-120*Feet> }
		object { PTail translate <0,80*Feet,160*Feet> }
		object { LightGroup }
	}

