//Mario scene, created 99-01-10 for IRTC "Imaginary Worlds" stills competition.

#include "colors.inc"

#declare tele=0;
#declare wide=1;

#declare Camera=tele;

camera {

#if (Camera=0)  

  location <8+16*-5,80,-16384*16>
  angle 1/16

#else

  location <8+16*-5,80,-512>
  angle 32

#end

  look_at <8+16*-5,80,64>
}

/*  

camera {
  look_at <8+16*-5,80,64>
}
*/

#declare GrassGreen1 = color rgb <0/255, 200/255, 0/255>;
#declare GrassGreen2 = color rgb <24/255, 240/255, 0>;
#declare DirtBrown1 = color rgb <200/255, 152/255, 88/255>;
#declare DirtBrown2 = color rgb <224/255, 192/255, 80/255>;
#declare SkyBlue = color rgb <0/255, 96/255, 184/255>;

#declare MtBlue1 = color rgb <112/255, 176/255, 208/255>;
#declare MtBlue2 = color rgb <192/255, 224/255, 224/255>;

#declare MtBlue3 = color rgb <192/255, 224/255, 224/255>;
#declare MtBlue4 = color rgb <232/255, 240/255, 248/255>;

#declare Dirt = texture {
/*
  pigment {
    bumps 
    color_map {
      [0.00 DirtBrown1]
      [0.80 DirtBrown1]
      [0.80 DirtBrown2]
      [1 DirtBrown2]
    }
    scale 2
  }
*/
  pigment {
    image_map {
      gif "dirt.gif"
      interpolate 4
    }
    scale 16
  }
  finish { ambient .8 diffuse .5 }
}

#declare Grass = texture {
/*
  pigment {
    bumps 
    color_map {
      [0.00 GrassGreen1]
      [1 GrassGreen2]
    }
    scale 10
  }
*/
  pigment {
    image_map {
      gif "grass.gif"
      interpolate 2
    }
    scale <16,8,1>
    translate y*1
  }
  finish { ambient .9  diffuse .3 }

}

#declare Mttx1 = texture {
  pigment {
    leopard 
    color_map {
      [0.00 MtBlue1]
      [0.70 MtBlue1]
      [0.70 MtBlue2]
      [1 MtBlue2]
    }
    scale <5,7,1>
  }
  finish { ambient .7  diffuse .4 }
}

#declare Mttx2 = texture {
  pigment {
    bumps 
    color_map {
      [0.00 MtBlue3]
      [0.90 MtBlue3]
      [0.90 MtBlue4]
      [1 MtBlue4]
    }
    scale 15
  }
  finish { ambient .7  diffuse .4 }
}

#declare Cloudtx = texture {
  pigment { rgb <168/255, 208/255, 208/255> }
  finish { ambient 1  diffuse .9 }
}

#declare Pipetx = texture {
  pigment { rgb y }
  finish { reflection .1 phong 60 phong_size 60 specular .5 diffuse .5 ambient .3 }
}






#declare Mt = 
union {
  cylinder { <0,-1024,0> <0,-32,0> 32 }
  sphere { <0,-32,0> 32 }
}


#declare Mt2 = 
union {
  cylinder { <0,-1024,0> <0,-24,0> 24 }
  sphere { <0,-24,0> 24 }
}

#declare Cloud =

union {
  cylinder { <-32,0,0> <64,0,0> 8 }
  sphere { <-32,0,0> 8 }
  sphere { <64,0,0> 8 }
  
  texture { Cloudtx }
  no_shadow
} 

#declare Block1 =
union {
  difference {
    superellipsoid {
      <.3, .3>
      translate <1,1,1>
      scale 8
      pigment { rgb <248/255, 216/255, 32/255> }
      finish { ambient .7 diffuse .4 }
    }
    union { 
      box { <5,6,-1> <6,11,1> }
      box { <10,6,-1> <11,11,1> }
    }
  }
}   

#declare Block2 =
superellipsoid {
  <.6, .6>
  translate <1,1,1>
  scale 8
  pigment { Gray50 }
  finish { ambient .7 diffuse 1.2 }
}   






box { <-1024,-7,0> <4096,0,2048> texture { Grass } }    //ground
box { <-1024,-4096,0> <4096,-7,2048> texture { Dirt } }




union {
  cylinder { <0,-256,0> <0,-17.5,0> 21 }
  cylinder { <0,-16,0> <0,0,0> 22.5 }
  
  texture { Pipetx }
  rotate z*-45
  translate <16*2,80,21.5>
  finish { reflection .1 }
}

cylinder { <0,-17.5,0> <0,-16,0> 21
  rotate z*-45
  translate <16*2,80,21.5>
  texture { Pipetx }
  finish { ambient .17 diffuse .1 }
}

union {
  cylinder { <0,0,0> <0,48,0> 7}
  cylinder { <0,0,0> <0,8,0> 8}
  cylinder { <0,40,0> <0,48,0> 8}
  
  texture { Pipetx }
  translate <8+16*2,0,1040>
}
           

union {
  cylinder { <0,0,0> <0,64,0> 7}
  cylinder { <0,0,0> <0,8,0> 8}
  cylinder { <0,56,0> <0,64,0> 8}
  
  texture { Pipetx }
  translate <8+16*3,0,1024>
}

union {
  cylinder { <0,0,0> <0,64,0> 7}
  cylinder { <0,0,0> <0,8,0> 8}
  cylinder { <0,56,0> <0,64,0> 8}
  
  texture { Pipetx }
  translate <8+16*4.5,0,1010>
}

union {
  cylinder { <0,00,0> <0,18,0> 14.5 }
  cylinder { <0,18,0> <0,31,0> 16 }
  texture { Pipetx }
  pigment { rgb <128/255, 128/255, 200/255> }
  translate  <16*-8, 0, 16>
}

union {
object { Block2 translate <16*-10,16*3,0> normal { bumps scale 2 } }
object { Block1 translate <16*-9,16*3,0> }
object { Block1 translate <16*-8,16*3,0> }
object { Block2 translate <16*-7,16*3,0> normal { bumps scale 2 } }

object { Block2 translate <16*-10,16*2,0> normal { bumps scale 2 } }
object { Block2 translate <16*-7,16*2,0> normal { bumps scale 2 } }

object { Block2 translate <16*-10,16,0> normal { bumps scale 2 } }
object { Block2 translate <16*-7,16,0> normal { bumps scale 2 } }

object { Block2 translate <16*-10,0,0> normal { bumps scale 2 } }
object { Block2 translate <16*-7,0,0> normal { bumps scale 2 } }

translate z*1024
}


light_source {
  <-96,32,1024> White spotlight
  fade_distance 128 fade_power 1
  radius 20 falloff 30
  point_at <8+16*3,32,1024>
}

light_source {
  <-400,0,0> White spotlight
  fade_distance 128 fade_power 1
  radius 20 falloff 30
  point_at <0,0,0>
  translate  <16*-800, 0,0> 
  rotate y*-25
  translate  <0, 16, 16> 
}






#declare zx=-1024;
#while (zx<1025)

union {

object { Mt translate <0,80,2144> texture { Mttx1 } no_shadow }
object { Mt translate <32,144,2080> texture { Mttx1 } no_shadow }  
object { Mt translate <64,256,2144> texture { Mttx1 } no_shadow }
object { Mt translate <96,128,2080> texture { Mttx1 } no_shadow }    
object { Mt translate <240,48,2080> texture { Mttx1 } no_shadow }    

object { Mt translate <-80,96,2144> texture { Mttx1 } no_shadow }
object { Mt translate <-144,48,2144> texture { Mttx1 } no_shadow }



object { Mt2 translate <120,176,2208> texture { Mttx2 } no_shadow }
object { Mt2 translate <184,80,2208> texture { Mttx2 } no_shadow }
object { Mt2 translate <264,128,2208> texture { Mttx2 } no_shadow }

object { Mt2 translate <-104,160,2208> texture { Mttx2 } no_shadow }
object { Mt2 translate <-152,128,2208> texture { Mttx2 } no_shadow }



object { Cloud scale 2 translate <0,0,2048> }
object { Cloud scale 2 translate <16*-8,0,2208> }
object { Cloud translate <88,24,2144> }
object { Cloud translate <120,40,2144> }

object { Cloud translate <104,120,2280> }
difference { object { Cloud translate <56,136,2150> } box { <-256,0,0> <56,512,4096> } }

union {
  cylinder { <-24,0,0> <24,0,0> 8 }
  sphere { <-24,0,0> 8 }
  sphere { <24,0,0> 8 }
  texture { Cloudtx }
  translate <240,88,2146>
  no_shadow
}

object { Cloud translate <-(8+16*3),8+16*2,2280> }
difference { object { Cloud translate <-(8+16*7),8+16*6,2280> } box { <-512,0,0> <-(8+16*5),200,4096> } }
union {
  cylinder { <-16,0,0> <16,0,0> 8 }
  sphere { <-16,0,0> 8 }
  sphere { <16,0,0> 8 }
  
  texture { Cloudtx }
  no_shadow
  translate <-(8+16*3),8+16*7,2280>
}
 
union {
  cylinder { <-16,0,0> <32,0,0> 8 }
  sphere { <-16,0,0> 8 }
  sphere { <32,0,0> 8 }
  
  texture { Cloudtx }
  no_shadow
   translate <-(8+16*12),8+16*4,2144>
} 
object { Cloud translate <-(8+16*15),8+16*1,2256> }
object { Cloud translate <-(8+16*10),8+16*2,2208> }

translate x*zx
}

#declare zx=zx+512;
#end







light_source { <-8192,4096,-4096> color White }


sky_sphere { pigment { SkyBlue } }