#declare Quick=0;       // Set to 1 for simple, non-reflective textures
#declare UseClouds=0;   // Not used, but they make a nice variation.

#declare FullScene=1;   // Suppress lights/cameras/objects in include files

#include "sky.inc"      // Cloudy grey sky
#include "clouds.inc"   // Extra clouds
#include "facility.inc" // The control station at right
#include "plants.inc"   // Plants on the control station
#include "tanks.inc"    // Tanks and silos
#include "rocks.inc"    // Foreground rocks
#include "ground.inc"   // Ground and background mountains
#include "pipes.inc"    // Grid of (mostly horizontal) pipes
#include "factory.inc"  // Industrial-looking building at left

#if (UseClouds) object { CloudBank } #end
object { Facility rotate y*90 translate <440,0,420> }
object { Plants }
object { Ground }
object { TankAssembly }
object { Boulders }
object { Pipes }
object { Factory }

camera { location <0.001,75,-0.001> look_at <0,125,1000> rotate y*25 }

light_source { <-5000,10000,10000> colour rgb 0.75 }
light_source { <-1000,1,-10000> colour rgb 0.66 }
light_source { <-10000,10000,-10000> colour rgb 0.66 }
light_source { <-10000,10000,0> colour rgb 0.75 }

sky_sphere { GreySky rotate y*25 }
