#ifndef (Quick) #declare Quick=0 #end

#if (Quick)
  #declare P_Black          = pigment { colour rgb <0,0,0> }
  #declare P_GrimyStone1    = pigment { colour rgb <0.5,0.4,0.4> }
  #declare P_GrimyStone2    = pigment { colour rgb <0.4,0.3,0.2> }
  #declare P_GrimyStone3    = pigment { colour rgb <0.45,0.35,0.25> }
  #declare P_GrimyStone4    = pigment { colour rgb <0.3,0.2,0.1> }
  #declare P_GrimyStone5    = pigment { colour rgb <0.35,0.25,0.15> }
  #declare P_GrimyMetal1    = pigment { colour rgb <0.6,0.7,0.8> }
  #declare P_GrimyMetal2    = pigment { colour rgb <0.5,0.4,0.3> }
  #declare P_GrimyMetal3    = pigment { colour rgb <0.55,0.6,0.55> }
  #declare P_GreyMetal      = pigment { colour rgb <0.3,0.3,0.3> }
  #declare P_GreyStone1     = pigment { colour rgb <0.9,0.9,0.9> }
  #declare P_GreyStone2     = pigment { colour rgb <0.7,0.7,0.7> }
  #declare P_GreyStone3     = pigment { colour rgb <0.8,0.8,0.8> }
  #declare P_Red            = pigment { colour rgb <0.7,0.15,0.05> }
  #declare T_GrimyMetal     = texture { pigment { P_GrimyMetal3 }}
  #declare T_LightGreyStone = texture { pigment { P_GreyStone3 }}
#else
  #declare P_Black          = pigment { colour rgb <0,0,0> }
  #declare P_GrimyStone1    = pigment { colour rgb <0.5,0.4,0.4> }
  #declare P_GrimyStone2    = pigment { colour rgb <0.4,0.3,0.2> }
  #declare P_GrimyStone3    = pigment { bozo pigment_map { [0.0 P_GrimyStone1][1.0 P_GrimyStone2] } warp { turbulence 0.7 omega 0.8 } scale <25,75,25> }
  #declare P_GrimyStone4    = pigment { colour rgb <0.3,0.2,0.1> }
  #declare P_GrimyStone5    = pigment { bozo pigment_map { [0.0 P_GrimyStone2][1.0 P_GrimyStone4] } warp { turbulence 0.7 omega 0.8 } scale <25,75,25> }
  #declare P_GrimyMetal1    = pigment { colour rgb <0.6,0.7,0.8> }
  #declare P_GrimyMetal2    = pigment { colour rgb <0.5,0.4,0.3> }
  #declare P_GrimyMetal3    = pigment { bozo pigment_map { [0.3 P_GrimyMetal1][1.0 P_GrimyMetal2] } warp { turbulence 0.3 omega 1.0 } scale 11 }
  #declare P_GreyMetal      = pigment { colour rgb <0.3,0.3,0.3> }
  #declare P_GreyStone1     = pigment { colour rgb <0.9,0.9,0.9> }
  #declare P_GreyStone2     = pigment { colour rgb <0.7,0.7,0.7> }
  #declare P_GreyStone3     = pigment { bozo pigment_map { [0.0 P_GreyStone1][1.0 P_GreyStone2] } warp { turbulence 0.7 omega 0.8 } scale <25,75,25> }
  #declare P_Red            = pigment { bozo colour_map { [0.0 rgb <0.8,0,0>][1.0 rgb <0.6,0.3,0.1>] } scale <1,3,1> }
  #declare T_GrimyMetal     = texture { pigment { P_GrimyMetal3 } finish { specular 1.0 roughness 0.005 brilliance 4.0 ambient 0.1 diffuse 0.6 }}
  #declare T_LightGreyStone = texture { pigment { P_GreyStone3 }}
#end


#declare Facade = union {
  difference {
    box { <-62.5,0,0>, <62.5,400,100> pigment { P_GrimyStone3 }}
    box { <-20,250,-0.001>, <-15,350,25> }
    box { <0,250,-0.001>, <5,350,25> }
    box { <20,250,-0.001>, <25,350,25> }
    box { <5,175,-0.001>, <25,140,99> pigment { colour rgb <1,1,1> }}
    box { <-5,175,1>, <30,140,98> pigment { colour rgb <1,1,1> }}
    bounded_by { box { <-62.5,0,0>, <62.5,400,100> }}
    pigment { P_GrimyStone2 }
  }
  #if (Quick=0)
    light_source { <12,170,50> colour rgb <0.9,0.9,0.5> fade_distance 70 fade_power 2 }
  #end
  box { <5,175,-5>, <25,163,0> pigment { P_GrimyStone5 }}
  box { <5,152,-5>, <25,140,0> pigment { P_GrimyStone5 }}
  box { <-20,250,10>, <-15,255,-25> pigment { P_GrimyMetal3 }}
  box { <  0,250,10>, <  5,255,-25> pigment { P_GrimyMetal3 }}
  box { < 20,250,10>, < 25,255,-25> pigment { P_GrimyMetal3 }}
  box { <-62.501,375,-0.001>, <62.501,400,100> pigment { P_GrimyMetal3 }}
  box { <-62.5,400,0>, <62.5,425,100> pigment { P_GrimyStone5 }}
  cylinder { <-47,425,50>, <-47,440,50>, 7.5 pigment { P_GrimyStone5 }}
  cylinder { <20,425,50>, <20,450,50>, 20 pigment { P_GrimyStone5 }}
  cylinder { <-35,425,50>, <-35,485,50>, 1 pigment { P_Black }}
  cylinder { <10,450,50>, <10,500,50>, 2 pigment { P_GrimyStone5 }}
  cylinder { <30,450,50>, <30,490,50>, 6 pigment { P_GrimyStone5 }}
  cylinder { <30,470,50>, <30,480,50>, 6.001 texture { T_GrimyMetal }}
  sphere { <-12.5,387.5,0>, 8 pigment { P_GreyMetal }}  sphere { <12.5,387.5,0>, 8 pigment { P_GreyMetal }}
  sphere { <-37.5,387.5,0>, 8 pigment { P_GreyMetal }}  sphere { <37.5,387.5,0>, 8 pigment { P_GreyMetal }}
  box { <-100,245,-25>, <-80,260,-15> pigment { P_GrimyMetal3 }}
  box { <90,245,-25>, <70,260,-15> pigment { P_GrimyMetal3 }}
  cylinder { <-95,245,-20>, <-95,270,-20>, 5 texture { T_GrimyMetal }}
  cylinder { <-92,270,-20>, <-92,290,-20>, 2 texture { T_GrimyMetal }}
  cylinder { < 82,270,-20>, < 82,290,-20>, 2 texture { T_GrimyMetal }}
  cylinder { < 85,245,-20>, < 85,270,-20>, 5 texture { T_GrimyMetal }}
  cylinder { <-100,245,-20>, <90,245,-20>, 5 texture { T_GrimyMetal }}
  cylinder { <-100,235,-20>, <90,235,-20>, 3 pigment { P_Black }}
  cylinder { <-90,235,-20>, <-90,95,-20>, 1 pigment { P_Black }}
  cylinder { < 80,235,-20>, < 80,95,-20>, 1 pigment { P_Black }}
  cylinder { <-80,200,-20>, < 70,200,-20>, 3 pigment { P_Black }}
  cylinder { <-105,200,-20>, <-80,200,-20>, 3 texture { T_GrimyMetal }}
  cylinder { < 70,200,-20>, < 95,200,-20>, 3 texture { T_GrimyMetal }}
  cylinder { <-98,205,-20>, <-98,95,-20>, 1 pigment { P_Black }}
  cylinder { < 88,205,-20>, < 88,95,-20>, 1 pigment { P_Black }}
  cylinder { <-300,110,-20>, <90,110,-20>, 6 texture { T_GrimyMetal }}
  cylinder { <-300,95,-20>, <60,95,-20>, 3 pigment { P_Black }}
  cylinder { <55,95,-20>, <55,235,-20>, 1 pigment { P_Black }}
  cylinder { <-40,205,-20>, <-40,235,-20>, 1 pigment { P_Black }}
  cylinder { <-45,205,-20>, <-45,235,-20>, 1 pigment { P_Black }}
  cylinder { <-35,205,-20>, <-35,235,-20>, 1 pigment { P_Black }}
  cylinder { <-50,205,-20>, <-50,110,-20>, 1 pigment { P_Black }}
  cylinder { <-45,205,-20>, <-45,110,-20>, 1 pigment { P_Black }}
  cylinder { <-55,205,-20>, <-55,110,-20>, 1 pigment { P_Black }}
  box { <-52,160,-22>, <-38,170,-18> pigment { P_GrimyMetal3 }}
  box { <-52,145,-22>, <-38,135,-18> pigment { P_GrimyMetal3 }}
  cylinder { <85,265,-20>, <105,265,3000>, 1.5 texture { T_GrimyMetal }}
  cylinder { <85,245,-20>, <105,245,3000>, 1.5 texture { T_GrimyMetal }}
  translate x*-62.5
}

#declare Garages = union {
  box { <0,225,100>, <-50,200,3050> texture { T_LightGreyStone }}
  box { <0,0,0>, <15,275,100> pigment { P_GrimyStone3 }}
  #declare foo=250;
  #while (foo < 3000)
    box { <0,0,foo>, <-50,275,foo+50> texture { T_LightGreyStone }}
    sphere { <5,100,foo>, 10 texture { T_GrimyMetal }}
    #declare foo=foo+500;
  #end
  cylinder { <5, 50,10>, <5, 50,5000>, 3 texture { T_GrimyMetal }}
  cylinder { <5,100,10>, <5,100,5000>, 3 texture { T_GrimyMetal }}
  cylinder { <5,0,5000>, <5,100,5000>, 3 pigment { P_Black }}
  sphere { <0,0,0>, 20 scale <0.25,1,1> translate <42.5,255,3000> texture { T_GrimyMetal }}
  cylinder { <-100,250,3050>, <165,250,3050>, 2 pigment { P_Black }}
  cylinder { <165,250,3050>, <165,230,3050>, 2 pigment { P_Black }}
  cylinder { <-100,230,3050>, <170,230,3050>, 4 pigment { P_Black }}
  cylinder { <160,230,3050>, <160,0,3050>, 3 pigment { P_Black }}
  cylinder { <-10,260,3000>, <42.5,260,3000>, 2 pigment { P_Black }}
  cylinder { <-10,270,3000>, <42.5,270,3000>, 2 pigment { P_Black }}
}

#declare T_DullCopper = texture {
  pigment { colour rgb <0.8,0.4,0.2> }
  finish { specular 0.8 roughness 0.05 metallic reflection 0.2 brilliance 4.0 ambient 0.1 diffuse 0.4 }
}

#declare Silos = union {
  cylinder { <-470,0,2000>, <-470,400,2000>, 14.999 pigment { P_GrimyStone3 }}
  cylinder { <-470,320,2000>, <-470,330,2000>, 15 pigment { P_Red }}
  cylinder { <-470,285,2000>, <-470,295,2000>, 15 pigment { P_Red }}
  cylinder { <-470,250,2000>, <-470,260,2000>, 15 pigment { P_Red }}
  cylinder { <-470,200,2000>, <-470,220,2000>, 15 pigment { P_Red }}
  cylinder { <-470,165,2000>, <-470,175,2000>, 15 pigment { P_Red }}
  torus { 15, 5 translate <-470,395,2000> pigment { P_GrimyStone3 }}
  cylinder { <-450,395,2000>, <-100,395,2000>, 1 pigment { P_Black }}
  cylinder { <-462,400,2000>, <-462,440,2000>, 3 pigment { P_GrimyStone3 }}

  cylinder { <-500,0,3100>, <-500,10,3100>, 70 pigment { P_GrimyMetal3 }}
  cylinder { <-500,10,3100>, <-500,200,3100>, 70 texture { T_DullCopper }}
  cylinder { <-500,200,3100>, <-500,230,3100>, 70 pigment { P_GrimyMetal3 }}
  cylinder { <-520,230,3100>, <-520,300,3100>, 2 pigment { P_Black }}
  cylinder { <-460,230,3100>, <-460,250,3100>, 10 pigment { P_GrimyStone5 }}
}

#declare Factory = union {
  object { Facade }
  object { Garages }
  object { Silos }
  translate <-150,0,3000>
}

#ifndef (FullScene)
  object { Factory }
  #declare FullScene=1;
  #declare Quick=1;
//  #include "rocks.inc"
//  object { Boulders1 }
/*
  union {
    box { <-150,0,2000>, <-130,0.002,5000> pigment { colour rgb <0.8,0.7,0.6> }}
    #declare foo=2000;
    #while (foo < 5000)
      cylinder { <-160,0,foo>, <-160,30,foo>, 3 pigment { colour rgb <1.0,0.5,0.0> }}
      cylinder { <-120,0,foo>, <-120,30,foo>, 3 pigment { colour rgb <0.8,0.7,0.6> }}
      #declare foo=foo+500;
    #end
    cylinder { <-135,20,2000>, <-1000,20,2000>, 3 pigment { colour rgb <0.8,1.0,1.0> }}
    cylinder { <-1000,40,2600>, <-120,40,2600>, 4 pigment { colour rgb <1,1,1> }}
    sphere { <-120,40,2600>, 4 pigment { colour rgb <1,1,1> }}
    cylinder { <-120,40,2600>, <-120,0,2600>, 4 pigment { colour rgb <1,1,1> }}
    translate x*20
  }
*/
  box { <-20,0,400>, <5,0.001,10000> pigment { colour rgb <1,1,1> }}
  box { <250,0,340>, <280,0.001,10000> pigment { colour rgb <1,1,1> }}
  box { <-300,0,800>, <1000,0.001,850> pigment { colour rgb <1,1,1> }}
  box { <-300,0,6000>, <1000,0.001,6500> pigment { colour rgb <1,1,1> }}
  camera { location <0,75,0> look_at <0,125,1000> rotate y*25 }
  light_source { <-5000,10000,10000> colour rgb 0.75 }
  light_source { <-1000,1,-10000> colour rgb 0.66 }
  light_source { <-10000,10000,-10000> colour rgb 0.66 }
  light_source { <-10000,10000,0> colour rgb 0.75 }
  background { colour rgb <0.25,0.5,1.0> }
#end
