// POV-Ray include file: findfont.inc
//               Author: Jeff Lee <shipbrk@gate.net> 
//                 Date: 11 April 1997
//             Modified: 25 February 1999
//
// Include file to find text fonts.  This can of course be extended to
// however many search directories are needed, but it was originally
// designed so that I could use the same .POV files on my OS/2 system
// at home and my Windows 3.1 system at work, without having to alter
// the directory names in every text object when I brought the file
// from one system to the other.
//
// Call with the following sequence:
//
//    #declare FindFontParameter="fontname.ttf"
//    #include "findfont.inc"
//    #declare fontname=FindFontResult
//
//      [...]
//
//    text{ ttf fontname "Gromit!  They're the wrong trousers!" [...] }
//
// "fontname" may be replaced by whatever variable name you wish.
//
// Redefine ffn1 and ffn2 to whatever your own directories are named.
// ffn3 is the default; POV-Ray will search the Library_Path
// directories for the file.
//
#declare ffn1=concat( "c:/os2/mdos/winos2/system/", FindFontParameter )
#declare ffn2=concat( "c:/windows/fonts/", FindFontParameter )
#declare ffn3=concat( "c:/windows/system/", FindFontParameter )
#declare ffn4=FindFontParameter

#debug concat( "Checking for ", ffn1, "\n" )
#if (file_exists( ffn1 ))
  #declare FindFontResult=ffn1
#else
  #debug concat( "Checking for ", ffn2, "\n" )
  #if (file_exists( ffn2 ))
    #declare FindFontResult=ffn2
  #else
    #debug concat( "Checking for ", ffn3, "\n" )
    #if (file_exists( ffn3 ))
      #declare FindFontResult=ffn3
    #else
      #debug concat( "Checking for ", ffn4, "\n" )
      #if (file_exists( ffn4 ))
        #declare FindFontResult=ffn4
      #else
        #warning concat( "\n***** Unable to locate font file ", ffn3,
          ",\n***** either explicitly or in a Library_Path directory.\n\n" )
        #error "Aborting..."
      #end
    #end
  #end
#end
#debug concat( "Font file found as ", FindFontResult, "\n" )
