#ifndef (Quick) #declare Quick=0 #end

#if (Quick=1)
  #declare T_Ground = texture { pigment { colour rgb <0.6,0.5,0.4> }}
  #declare T_Road   = texture { pigment { colour rgb <0.8,0.7,0.6> }}
#else
  #declare P_Dirt1  = pigment { colour rgb <0.6,0.5,0.4> }
  #declare P_Dirt2  = pigment { bozo    colour_map { [0.65 rgbt <1,1,1,1>][0.7 rgb <0.40,0.30,0.20>] } warp { turbulence 1.0 lambda 3 } scale 500}
  #declare P_Dirt3  = pigment { bozo    colour_map { [0.50 rgbt <1,1,1,1>][0.6 rgb <0.70,0.60,0.50>] } warp { turbulence 1.0 omega 0.8 } scale <2,0.5,0.5> rotate y*50 warp { turbulence 1.0 lambda 4 omega 1.0 } }
  #declare P_Dirt4  = pigment { marble  colour_map { [0.60 rgbt <1,1,1,1>][0.7 rgb <0.60,0.50,0.40>] } warp { turbulence 1.0 omega 1 } scale <2,0.5,0.5> rotate y*176 }
  #declare P_Dirt5  = pigment { bozo    colour_map { [0.60 rgbt <1,1,1,1>][0.7 rgb <0.75,0.65,0.55>] } warp { turbulence 1.0 omega 1 } scale <1,0.75,0.75> rotate y*35 }
  #declare P_Dirt6  = pigment { bozo    colour_map { [0.50 rgbt <1,1,1,1>][0.6 rgb <0.65,0.55,0.45>] } warp { turbulence 1.0 omega 1 } scale <1,1,1> rotate y*102 }
  #declare T_Dirt   = texture { pigment { P_Dirt1 }} texture { pigment { P_Dirt2 }} texture { pigment { P_Dirt3 }} texture { pigment { P_Dirt4 }} texture { pigment { P_Dirt5 }} texture { pigment { P_Dirt6 }}
  #declare T_Ground = texture { T_Dirt scale 0.25 }
  #declare T_Road   = texture { pigment { bozo colour_map { [0.0 rgb <0.9,0.8,0.6>][1.0 rgb <0.7,0.6,0.5>] } scale 0.25 }}
#end


#declare P_Mountain1a = pigment { bozo colour_map { [0.0 rgb <0.475,0.45,0.55>*1.4][1.0 rgb <0.5,0.525,0.55>*1.4] } scale <0.05,0.1,0.05> translate x*-10 }
#declare P_Mountain1  = pigment { gradient <1,1,0> pigment_map { [0.4 P_Mountain1a][0.45 colour rgbt <0.55,0.5,0.6,1>] } scale 10 warp { turbulence <0,0.8,0> } scale 0.2 }
#declare P_Mountain2a = pigment { bozo colour_map { [0.0 rgb <0.455,0.425,0.525>*1.4][1.0 rgb <0.5,0.45,0.525>*1.4] } scale <0.05,0.1,0.05> translate x*-10 }
#declare P_Mountain2  = pigment { gradient <1,1,0> pigment_map { [0.4 P_Mountain2a][0.45 colour rgbt <0.5,0.5,0.55,1>] } scale 10 translate x*50 warp { turbulence <0,0.8,0> } translate x*-50 scale <0.2,0.15,0.2> }
#declare P_Mountain3a = pigment { bozo colour_map { [0.0 rgb <0.45,0.4,0.5>*1.4][1.0 rgb <0.475,0.425,0.5>*1.4] } scale <0.05,0.1,0.05> translate x*-10 }
#declare P_Mountain3  = pigment { gradient <1,1,0> pigment_map { [0.4 P_Mountain3a][0.45 colour rgbt <0.45,0.4,0.5,1>] } scale 10 translate x*-100 warp { turbulence <0,0.8,0> } translate x*100 scale <0.2,0.125,0.2> }
#declare T_Mountain1  = texture { pigment { P_Mountain1 } finish { ambient 1 diffuse 0.0 }}
#declare T_Mountain2  = texture { pigment { P_Mountain2 } finish { ambient 1 diffuse 0.0 }}
#declare T_Mountain3  = texture { pigment { P_Mountain3 } finish { ambient 1 diffuse 0.0 }}

#declare Mountains = union {
  disc { <0,0,0>, -z, 1 texture { T_Mountain1 } no_shadow scale <1000,650,1000> translate <400,0,15000> }
  disc { <0,0,0>, -z, 1 texture { T_Mountain2 } no_shadow scale <1000,650,1000> translate <1250,0,14999.5> }
  disc { <0,0,0>, -z, 1 texture { T_Mountain3 } no_shadow scale <1000,650,1000> translate <-450,0,14999> }
  disc { <0,0,0>, -z, 1 texture { T_Mountain2 rotate z*180} no_shadow scale <1000,650,1000> translate <2000,0,14999.5> }
  disc { <0,0,0>, -z, 1 texture { T_Mountain3 rotate z*180} no_shadow scale <1000,650,1000> translate <2400,0,14999> }
  disc { <0,0,0>, -z, 1 texture { T_Mountain1 rotate z*180} no_shadow scale <1000,650,1000> translate <2800,0,15000> }
}

#declare MountainRange = union {
  object { Mountains }
  object { Mountains translate <3200,0,2> }
  object { Mountains translate x*6400 }
}

#declare Ground = union {
  box { <-20,0,400>, <5,0.001,10000> texture { T_Road }}
  box { <250,0,340>, <280,0.001,10000> texture { T_Road }}
  box { <-300,0,800>, <1000,0.001,850> texture { T_Road }}
  #if (Quick)
    plane { y, 0 }
  #else
    difference {
      plane { y, 0 }
      box { <350,0.001,1000>, <1000,-100,3000> pigment { colour rgb <0,0.4,0.4> }}
    }
  #end
  sphere { <0,0,0>, 5 scale <40,1,40> translate <-75,-2,240> no_shadow }
  sphere { <0,0,0>, 5 scale <60,1,30> translate <250,-1,100> no_shadow }
  #if (Quick=0) object { MountainRange } #end
  texture { T_Ground }
}

#ifndef (FullScene)
  object { Ground }
  camera { location <0,75,0> look_at <0,125,1000> rotate y*25 }
  light_source { <-5000,10000,10000> colour rgb 0.75 }
  light_source { <-1000,1,-10000> colour rgb 0.66 }
  light_source { <-10000,10000,-10000> colour rgb 0.66 }
  light_source { <-10000,10000,0> colour rgb 0.75 }
  background { colour rgb <0.25,0.5,1.0> }
#end
