#ifndef (Quick) #declare Quick=0 #end

#if (Quick)
  #declare P_Black       = pigment { colour rgb <0.0,0.0,0.0> }
  #declare P_White       = pigment { colour rgb <1.0,1.0,1.0> }
  #declare P_Orange      = pigment { colour rgb <1.0,0.5,0.0> }
  #declare P_Tan         = pigment { colour rgb <0.9,0.8,0.7> }
  #declare P_Teal        = pigment { colour rgb <0.0,0.5,0.5> }
  #declare P_Cyan        = pigment { colour rgb <0.3,0.9,0.9> }
  #declare T_Water       = texture { pigment { colour rgb <0.3,0.2,0.1> }}
  #declare T_DentedMetal = texture { pigment { colour rgb <0.85,0.9,0.9> }}
#else
  #declare P_Black       = pigment { bozo colour_map { [0.0 rgb <0.0,0.0,0.0>][1.0 rgb <0.1,0.1,0.1>] } scale <1,5,4> }
  #declare P_White       = pigment { bozo colour_map { [0.0 rgb <1.0,1.0,1.0>][1.0 rgb <0.8,0.8,0.8>] } scale <1,5,4> }
  #declare P_Orange      = pigment { bozo colour_map { [0.0 rgb <1.0,0.5,0.0>][1.0 rgb <0.9,0.4,0.0>] } scale <1,5,4> }
  #declare P_Tan         = pigment { bozo colour_map { [0.0 rgb <0.9,0.8,0.7>][1.0 rgb <0.7,0.6,0.5>] } scale <1,5,4> }
  #declare P_Teal        = pigment { bozo colour_map { [0.0 rgb <0.0,0.5,0.5>][1.0 rgb <0.0,0.4,0.4>] } scale <1,5,4> }
  #declare P_Cyan        = pigment { bozo colour_map { [0.0 rgb <0.3,0.9,0.9>][1.0 rgb <0.1,0.7,0.7>] } scale <1,5,4> }
  #declare T_Water       = texture { pigment { colour rgb <0.3,0.2,0.1> } finish { reflection 0.75 specular 1.0 roughness 0.001 } normal { ripples 0.025 }}
  #declare T_DentedMetal = texture { pigment { colour rgb <0.85,0.9,0.9> } finish { reflection 0.6 metallic specular 1.0 roughness 0.005 brilliance 4 ambient 0.1 diffuse 0.6 } normal { bumps }}
#end


#declare WaterTank = union {
  box { <350,-20,1000>, <1000,-100,3000> texture { T_Water }}
  cylinder { <566,-5,1000>, <566,-5,3000>, 3 pigment { P_White }}
  cylinder { <783,-5,1000>, <783,-5,3000>, 3 pigment { P_White }}

  cylinder { <530,-30,1250>, <530,20,1250>, 10 pigment { P_White }}
  torus { 10, 3 pigment { P_Black } translate <530,10,1250> }
  sphere { <0,0,0>, 15 scale <1,0.5,1> translate <530,29,1250> pigment { P_White }}

  cylinder { <600,-30,1100>, <600,20,1100>, 10 pigment { P_White }}
  torus { 10, 2 translate <600,10,1100> pigment { P_Black }}
}

#declare Channel = union {
  prism { linear_spline linear_sweep -500, 20, 9,
    <100,0>, <90,3>, <85,1>, <85,0.5>, <-85,0.5>, <-85,1>, <-90,3>, <-100,0>, <100,0>
    rotate <-90,-90,0>
    pigment { P_Black }
  }
  box { <-500,0.5,-85>, <20,0.75,85> texture { T_Water }}
  box { <20,0,-100>, <80,10,100> pigment { colour rgb <0,0.4,0.4> }}
}

#declare Tarmac = union {
  box { <-100,0,2000>, <-90,0.002,5000> pigment { P_Tan }}
  box { <-90,0,2000>, <200,0.002,2100> pigment { P_Tan }}
  box { <-80,0,2200>, <200,0.002,2900> pigment { P_Teal }}
  box { <-90,0,3000>, <200,0.002,3100> pigment { P_Tan }}
  box { <-80,0,3200>, <200,0.002,3900> pigment { P_Teal }}
  box { <-90,0,4000>, <200,0.002,4100> pigment { P_Tan }}
}

#declare VertPipe1 = union { // Tan with cyan band, white sphere
  cylinder { <0,0,0>, <0,20,0>, 6 pigment { P_Tan }}
  cylinder { <0,20,0>, <0,35,0>, 6 pigment { P_Teal }}
  sphere { <0,0,0>, 6 pigment { P_White } scale <1,0.75,1> translate y*37 }
}

#declare VertPipe2 = union { // Black and cyan
  cylinder { <0,0,0>, <0,10,0>, 6 pigment { P_Black }}
  cylinder { <0,10,0>, <0,30,0>, 6 pigment { P_Tan }}
}

#declare VertPipe3 = union { // White with bands in centre
  cylinder { <0,0,0>, <0,40,0>, 5 pigment { P_White }}
  torus { 5, 1 translate y*15 pigment { P_Teal }}
  torus { 5, 1 translate y*22 pigment { P_Orange }}
}

#declare VertPipe4 = union { // Orange mushroom-looking thing
  cylinder { <0,0,0>, <0,50,0>, 10 }
  torus { 10,3 translate y*47 }
  pigment { P_Orange }
}

#declare VertPipe5 = union { // White with orange ring
  cylinder { <0,0,0>, <0,50,0>, 4 pigment { P_White }}
  torus { 4, 2 translate y*48 pigment { P_White }}
  torus { 4, 1 translate y*25 pigment { P_Orange }}
}

#declare VertPipe6 = union { // Tan with white rings 
  cylinder { <0,0,0>, <0,50,0>, 4 pigment { P_Tan }}
  torus { 4, 3 translate y*33 }
  torus { 4, 3 translate y*17 }
  pigment { P_White }
}

#declare VertPipe7  = cylinder { <0,0,0>, <0,40,0>, 4 pigment { P_White }}
#declare VertPipe8  = cylinder { <0,0,0>, <0,40,0>, 4 pigment { P_Tan }}
#declare VertPipe9  = cylinder { <0,0,0>, <0,40,0>, 4 pigment { P_Teal }}

#declare ps = seed( 1701 )
#declare RandomPipes = union {
  object { VertPipe7 translate <-50,0,1100> }
  cylinder { <-2000,20,6500>, <2000,20,6500>, 10 pigment { P_Black }}
  cylinder { <-2000,20,7000>, <2000,20,7000>, 10 pigment { P_Black }}
  cylinder { <-2000,20,8000>, <2000,20,8000>, 10 pigment { P_Black }}
  cylinder { <-2000,20,9000>, <2000,20,9000>, 10 pigment { P_Black }}
  cylinder { <-2000,20,9500>, <2000,20,9500>, 10 pigment { P_Black }}
  #declare foo=0;
  #while (foo < 15)
    #declare bar = (rand(ps) * 0.5) + 0.75;
    object { VertPipe7 scale <bar,(rand(ps)*0.6)+0.7, bar> translate <(rand(ps)*450)-100,0,(rand(ps)*3000)+1000> }
    #declare bar = (rand(ps) * 0.5) + 0.75;
    object { VertPipe8 scale <bar,(rand(ps)*0.6)+0.7, bar> translate <(rand(ps)*450)-100,0,(rand(ps)*3000)+1000> }
    #declare bar = (rand(ps) * 0.5) + 0.75;
    object { VertPipe9 scale <bar,(rand(ps)*0.6)+0.7, bar> translate <(rand(ps)*450)-100,0,(rand(ps)*3000)+1000> }
    #declare foo=foo+1;
  #end
  translate x*50
}

#declare Junction1 = union {
  cylinder { <0,0,10>, <0,60,10>, 3 }
  torus { 3, 3 scale <1,0.5,1> translate <0,57,10> }
  torus { 3, 1.5 translate <0,40,10> }
  cylinder { <0,60,10>, <0,64,10>, 1 }
  intersection {
    torus { 2, 1 rotate x*-90 }
    box { <0,0,-1.001>, <3.001,3.001,1.001> }
    bounded_by { box { <0,0,-1>, <2,2,1> }}
    translate <0,64,10>
  }
  sphere { <0,66,10>, 1 }
  cylinder { <0,66,10>, <1,66,10>, 1 }
  cylinder { <2,64,10>, <2,50,10>, 1 }
  torus { 3, 1.00 translate <0,35,10> pigment { P_Black }}
  torus { 3, 1.50 translate <0,30,10> pigment { P_Black }}
  torus { 3, 1.25 translate <0,25,10> pigment { P_Teal }}
  torus { 3, 1.50 translate <0,15,10> pigment { P_Teal }}

  cylinder { <30,0,10>, <30,35,10>, 3 }
  intersection {
    torus { 10, 3 rotate x*-90 }
    box { <0,0,-3.001>, <13.001,13.001,3.001> }
    bounded_by { box { <0,0,-3>, <13,13,3> }}
    translate <20,35,10>
  }
  cylinder { <20,45,10>, <0,45,10>, 3 }
  torus { 3, 0.50 translate <30,35,10> pigment { P_Black }}
  torus { 3, 0.75 translate <30,25,10> pigment { P_Teal }}

  cylinder { <30,0,-20>, <30,15,-20>, 2.5 }
  torus { 2.5, 1 translate <30,14,-20> pigment { P_Black }}
  cylinder { <30,15,-20>, <30,23,-20>, 2 pigment { P_Cyan }}
  torus { 1.5, 0.5 translate <30,23,-20> pigment { P_Tan }}
  cylinder { <30,23,-20>, <30,63,-20>, 1.5 }
  torus { 1.5, 0.5 translate <30,30,-20> pigment { P_Tan }}
  cylinder { <30,35,-20>, <30,40,-20>, 2.5 }
  cylinder { <30,45,-20>, <30,50,-20>, 2.5 }
  cylinder { <30,55,-20>, <30,60,-20>, 2.5 }
  torus { 1.5, 1 translate <30,61.5,-20> }

  cylinder { <50,0,-20>, <50,15,-20>, 4 }
  cylinder { <50,15,-20>, <50,18,-20>, 3 pigment { P_Black }}
  cylinder { <50,18,-20>, <50,25,-20>, 4 }
  sphere { <0,0,0>, 4 scale <1,0.5,1> translate <50,27,-20> }

  pigment { P_White }
}

#declare OrangePipes = union {
  cylinder { <-200,10,1100>, <-80,10,1100>, 2 } sphere { <-80,10,1100>, 2 }
  cylinder { <-80,10,1100>, <-80,5,1100>, 2 }   sphere { <-80,5,1100>, 2 }
  cylinder { <-80,5,1110>, <-50,5,1110>, 2 }  cylinder { <-50,20,1110>, <-50,0,1110>, 2 }

  cylinder { <50,0,1500>, <50,10,1500>, 5 }  sphere { <50,10,1500>, 5 }
  cylinder { <50,10,1500>, <2000,10,1500>, 5 }

  cylinder { <550,-20,2500>, <550,10,2500>, 5 }  sphere { <550,10,2500>, 5 }
  cylinder { <550,10,2500>, <2000,10,2500>, 5 }

  cylinder { <150,0,1125>, <150,10,1125>, 3 }  sphere { <150,10,1125>, 3 } 
  cylinder { <150,10,1125>, <290,10,1125>, 3 } sphere { <290,10,1125>, 3 } 
  cylinder { <290,10,1125>, <290,0,1125>, 3 }

  cylinder { <550,30,1100>, <550,10,1100>, 8 }   sphere { <550,10,1100>, 8 } 
  cylinder { <550,6,1100>, <2000,6,1100>, 4 }
  torus { 8, 2 translate <550,28,1100> }

  pigment { P_Orange }
}

#declare CyanPipes = union {
  union {
    cylinder { <125,0,2000>, <125,0,1050>, 3 }  sphere { <125,0,1050>, 3 }
    cylinder { <125,0,1050>, <225,0,1050>, 3 }  sphere { <225,0,1050>, 3 }
    cylinder { <225,0,2000>, <225,0,1050>, 3 }  
    cylinder { <175,0,2000>, <175,0,1050>, 3 }  
    cylinder { <125,0,1050>, <225,0,1050>, 3 }  
    cylinder { <125,0,1125>, <225,0,1125>, 3 }  
    scale <1,0.2,1>
  }

  cylinder { <280,-10,1020>, <280,7,1020>, 2 } sphere { <280,7,1020>, 2 }
  cylinder { <280,7,1020>, <2000,7,1020>, 2 }

  cylinder { <20,0,5000>, <20,20,5000>, 5 }  sphere { <20,20,5000>, 5 }
  cylinder { <20,20,5000>, <2000,20,5000>, 5 }

  cylinder { <20,0,1240>, <20,10,1240>, 3 }  sphere { <20,10,1240>, 3 }
  cylinder { <20,10,1240>, <120,10,1240>, 3 }  sphere { <120,10,1240>, 3 }
  cylinder { <120,10,1240>, <120,0,1240>, 3 }
  torus { 3, 2 rotate z*90 translate <30,10,1240> }
  torus { 3, 2 rotate z*90 translate <60,10,1240> }
  torus { 3, 2 rotate z*90 translate <90,10,1240> }

  pigment { P_Cyan }
}

#declare RightPipe = union {
  cylinder { <0,0,0>, <0,30,0>, 5 }
  sphere { <0,30,0>, 5 }
  cylinder { <0,30,0>, <1000,30,0>, 5 }
  torus { 5, 2 translate y*15 }
}

#declare TealPipes = union {
  cylinder { <75,0,1300>, <75,10,1300>, 4 }  sphere { <75,10,1300>, 4 }
  cylinder { <75,10,1300>, <200,10,1300>, 4 }  sphere { <200,10,1300>, 4 }
  cylinder { <200,10,1300>, <200,0,1300>, 4 }

  cylinder { <75,0,2100>, <75,10,2100>, 4 }  sphere { <75,10,2100>, 4 }
  cylinder { <75,10,2100>, <200,10,2100>, 4 }  sphere { <200,10,2100>, 4 }
  cylinder { <200,10,2100>, <200,0,2100>, 4 }

  cylinder { <2600,20,3000>, <2600,20,800>, 5 }
  cylinder { <1800,20,3000>, <1800,20,800>, 5 }
  cylinder { <1400,20,3000>, <1400,20,800>, 5 }
  cylinder { <1200,20,3000>, <1200,20,800>, 5 }
  cylinder { <1100,20,3000>, <1100,20,800>, 5 }
  torus { 5, 3 rotate x*-90 translate <1100,20, 950> }
  torus { 5, 3 rotate x*-90 translate <1100,20,1000> }
  torus { 5, 2 rotate x*-90 translate <1100,20,1075> }
  torus { 5, 3 rotate x*-90 translate <1100,20,1150> }
  torus { 5, 3 rotate x*-90 translate <1100,20,1200> }
  torus { 5, 2 rotate x*-90 translate <1100,20,1260> }
  torus { 5, 3 rotate x*-90 translate <1100,20,1300> }
  torus { 5, 3 rotate x*-90 translate <1100,20,1400> }
  torus { 5, 2 rotate x*-90 translate <1100,20,1500> }
  torus { 5, 2 rotate x*-90 translate <1100,20,1550> }
  torus { 5, 3 rotate x*-90 translate <1100,20,1600> }
  torus { 5, 3 rotate x*-90 translate <1100,20,1800> }
  torus { 5, 2 rotate x*-90 translate <1100,20,1900> }
  torus { 5, 3 rotate x*-90 translate <1100,20,2000> }
  torus { 5, 3 rotate x*-90 translate <1100,20,2200> }
  torus { 5, 3 rotate x*-90 translate <1100,20,2300> }

  object { RightPipe translate <1050,0,1325> }
  object { RightPipe translate <1150,0,2500> }
  object { RightPipe translate <1150,0,3520> }
  object { RightPipe translate <1050,0,4620> }

  cylinder { <500,20,3000>, <2000,20,3000>, 5 }  sphere { <500,20,3000>, 5 }
  cylinder { <500,20,3000>, <500,0,3000>, 5 }

  cylinder { <500,0,4000>, <500,30,4000>, 5 }  sphere { <500,30,4000>, 5 }
  cylinder { <500,30,4000>, <2000,30,4000>, 5 }

  cylinder { <100,0,900>, <100,3,900>, 20 }

  pigment { P_Teal }
}

#declare WhitePipes = union {
  // between 5 and 250 behind 850
  cylinder { <225,0,1070>, <225,10,1070>, 3 }  sphere { <225,10,1070>, 3 }
  cylinder { <225,10,1070>, <500,10,1070>, 3 }  sphere { <500,10,1070>, 3 }
  cylinder { <500,10,1070>, <500,-20,1070>, 3 }

  cylinder { <1000,0,3250>, <1000,50,3250>, 16 }  sphere { <1000,50,3250>, 16 }
  cylinder { <900,50,3250>, <2000,50,3250>, 10 }
  cylinder { <920,35,3250>, <920,70,3250>, 10 }
  sphere { <0,0,0>, 12 scale <1,0.5,1> translate <920,74,3250> pigment { P_Cyan }}

  cylinder { <-40,10,1610>, <200,10,1610>, 3 }  sphere { <200,10,1610>, 3 } 
  cylinder { <-40,0,1610>, <-40,10,1610>, 3 }   sphere { <-40,10,1610>, 3 }
  cylinder { <200,10,1610>, <200,0,1610>, 3 }
  torus { 3, 1 translate <-40,5,1610> }
  torus { 3, 1 rotate z*90 translate <-35,10,1610> }

  cylinder { <20,20,2200>, <1050,20,2200>, 5 }  sphere { <20,20,2200>, 5 }
  cylinder { <20,0,2200>, <20,20,2200>, 5 } sphere { <1050,20,2200>, 5 }
  cylinder { <1050,20,2200>, <1050,0,2200>, 5 }

  cylinder { <225,30,1310>, <1050,30,1310>, 4 }  sphere { <225,30,1310>, 4 }
  cylinder { <225,30,1310>, <225,0,1310>, 4 }  sphere { <1050,30,1310>, 4 }
  cylinder { <1050,0,1310>, <1050,30,1310>, 4 }

  cylinder { <-30,20,3500>, <1050,20,3500>, 5 }  sphere { <1050,20,3500>, 5 }
  cylinder { <-30,0,3500>, <-30,20,3500>, 5 }  sphere { <-30,20,3500>, 5 }
  cylinder { <1050,0,3500>, <1050,20,3500>, 5 }  

  sphere { <150,0,890>, 4 }    sphere { <170,0,895>, 4 }    sphere { <200,0,910>, 4 }
  sphere { <40,0,900>, 4 }
  pigment { P_White }
}

#declare RoundTank = union {
  sphere { <0,42,0>, 25 texture { T_DentedMetal }}
  torus { 5, 2 translate y*68 texture { T_DentedMetal }}
  sphere { <0,68,0>, 5 texture { T_DentedMetal }}
  cone { <0,68,0>, 4, <0,83,0>, 2 texture { T_DentedMetal }}
  cylinder { <0,0,-18>, <0,39,-18>, 2 pigment { P_Black } rotate y* 45 }
  cylinder { <0,0,-18>, <0,39,-18>, 2 pigment { P_Black } rotate y*135 }
  cylinder { <0,0,-18>, <0,39,-18>, 2 pigment { P_Black } rotate y*225 }
  cylinder { <0,0,-18>, <0,39,-18>, 2 pigment { P_Black } rotate y*315 }
  translate <-100,0,1400>
}

#declare LeftPipes = union {
  box { <-150,0,2000>, <-130,0.002,5000> pigment { P_Tan }}
  #declare foo=2000;
  #while (foo < 5000)
    cylinder { <-160,0,foo>, <-160,30,foo>, 3 pigment { P_Orange }}
    cylinder { <-120,0,foo>, <-120,30,foo>, 3 pigment { P_Tan }}
    #declare foo=foo+500;
  #end
  cylinder { <-135,20,2000>, <-1000,20,2000>, 3 pigment { P_Cyan }}
  cylinder { <-1000,40,2600>, <-120,40,2600>, 4 pigment { P_White }}
  sphere { <-120,40,2600>, 4 pigment { P_White }}
  cylinder { <-120,40,2600>, <-120,0,2600>, 4 pigment { P_White }}
  translate x*20
}

#declare Pipes = union {
  object { Tarmac }
  object { WaterTank }
  object { RoundTank }
  object { Channel translate z*1100 }
  object { RandomPipes }
  object { VertPipe1 translate <125,0,1000> }
  object { VertPipe1 translate <100,0,1050> }
  object { VertPipe2 translate <50,0,950> }
  object { VertPipe3 translate <230,0,1000> }
  object { VertPipe3 translate <240,0,1500> }
  object { VertPipe4 translate <200,0,1400> }
  object { VertPipe5 translate <200,0,1000> }
  object { VertPipe6 translate < 70,0,2000> }
  object { VertPipe6 translate <130,0,2000> }
  object { Junction1 translate <290,0,880> }
  object { OrangePipes }
  object { CyanPipes }
  object { TealPipes }
  object { WhitePipes }
  object { LeftPipes }
}

#ifndef (FullScene)
#declare FullScene=1;
#declare Quick=1;
//#include "tanks.inc"
//object { TankAssembly }
//#include "ground.inc"
//object { Ground }
//#include "rocks.inc"
//object { Boulders }
  object { Pipes }
  box { <-20,0,400>, <5,0.001,10000> pigment { P_White }}
  box { <250,0,340>, <280,0.001,10000> pigment { P_White }}
  box { <-300,0,800>, <1000,0.001,850> pigment { P_White }}
  box { <-300,0,6000>, <1000,0.001,6500> pigment { P_White }}
  difference {
    box { <340,0,990>, <1010,-110,3010> pigment { colour rgb <1,1,1> }}
    box { <350,0.001,1000>, <1000,-100,3000> pigment { colour rgb <0,0.4,0.4> }}
  }
  camera { location <0,75,0> look_at <0,125,1000> rotate y*25 }
  light_source { <-5000,10000,10000> colour rgb 0.75 }
  light_source { <-1000,1,-10000> colour rgb 0.66 }
  light_source { <-10000,10000,-10000> colour rgb 0.66 }
  light_source { <-10000,10000,0> colour rgb 0.75 }
  background { colour rgb <0.25,0.5,1.0> }
#end
