#ifndef (Quick) #declare Quick=0; #end

#declare T_Plant1Bark    = texture { pigment { colour rgb <0.8,0.7,0.6> }}
#declare T_Plant1Leaf    = texture { pigment { colour rgb <0.3,0.4,0.05> } finish { specular 0.9 roughness 0.005 }}
#declare T_Plant2Bark    = texture { pigment { colour rgb <0.6,0.5,0.4> }}
#declare T_Plant2Leaf    = texture { pigment { colour rgb <0.4,0.5,0.1> } finish { specular 0.9 roughness 0.005 }}

#declare PlantLeaf = mesh {
  #if (Quick=0)
    triangle { <-0.040,1.820,-0.205>, <0.040,1.820,-0.205>, < 0.000,2.000,-0.313> }
    triangle { <-0.040,1.820,-0.205>, <0.040,1.820,-0.205>, <-0.065,1.630,-0.138> }
    triangle { < 0.040,1.820,-0.205>, <0.065,1.630,-0.138>, <-0.065,1.630,-0.138> }
    triangle { <-0.065,1.630,-0.138>, <0.065,1.630,-0.138>, <-0.085,1.400,-0.078> }
    triangle { < 0.065,1.630,-0.138>, <0.085,1.400,-0.078>, <-0.085,1.400,-0.078> }
    triangle { <-0.085,1.400,-0.078>, <0.085,1.400,-0.078>, <-0.090,1.155,-0.045> }
    triangle { < 0.085,1.400,-0.078>, <0.090,1.155,-0.045>, <-0.090,1.155,-0.045> }
    triangle { <-0.090,1.155,-0.045>, <0.090,1.155,-0.045>, <-0.100,0.000, 0.000> }
    triangle { < 0.090,1.155,-0.045>, <0.100,0.000, 0.000>, <-0.100,0.000, 0.000> }
    rotate x*-5
  #else
    triangle { <-0.100,0.000,0.000>, <0.000,2.000,0.000>, <0.100,0.000,0.000> }
  #end
  scale <0.5,1,1>
}

#declare ls = seed(1024);

#declare Plant1Branch = union {
  cone { <0,0,0>, 0.2, <0,10,0>, 0.05 texture { T_Plant1Bark }}
  #if (Quick=0)
    #declare foo=0;
    #declare bar=0;
    #while (foo < 10)
      #declare ztrans = 0.2 - (0.15 * (foo/10));
      object { PlantLeaf rotate <-50+(20*rand(ls)),0,10-(20*rand(ls))>
        scale 0.80+(0.30*rand(ls))
        translate <0,foo,ztrans> rotate y*bar
      }
      #declare bar=bar+45+45*rand(ls);
      #if (bar > 360) #declare bar=bar-360;  #end
      #declare foo=foo+0.03;
    #end
  #end
}

#declare Plant1 = union {
  cone { <0,0,0>, 1, <0,15,0>, 0 texture { T_Plant1Bark }}
  #declare foo=1;
  #declare bar=0;
  #while (foo < 15)
    #declare ztrans = 0.2 - (0.15 * (foo/10));
    object { Plant1Branch rotate <-(80-foo*2)+(20*rand(ls)),0,10-(20*rand(ls))>
      scale 0.80+(0.30*rand(ls))-(foo/30)
      translate <0,foo,ztrans> rotate y*bar
    }
    #declare bar=bar+35+35*rand(ls);
    #if (bar > 360) #declare bar=bar-360;  #end
    #declare foo=foo+0.4;
  #end
  texture { T_Plant1Leaf }
}

#declare Plant2Cluster1 = union {
  object { PlantLeaf rotate <150+(15*rand(ls)),  0,0> }
  object { PlantLeaf rotate <150+(15*rand(ls)), 72,0> }
  object { PlantLeaf rotate <150+(15*rand(ls)),144,0> }
  object { PlantLeaf rotate <150+(15*rand(ls)),216,0> }
  object { PlantLeaf rotate <150+(15*rand(ls)),288,0> }
  texture { T_Plant2Leaf }
}

#declare Plant2Cluster2 = union {
  object { PlantLeaf rotate <170+(10*rand(ls)),  0,0> }
  object { PlantLeaf rotate <170+(10*rand(ls)), 72,0> }
  object { PlantLeaf rotate <170+(10*rand(ls)),144,0> }
  object { PlantLeaf rotate <170+(10*rand(ls)),216,0> }
  object { PlantLeaf rotate <170+(10*rand(ls)),288,0> }
  texture { T_Plant2Leaf }
}

#declare Plant2Cluster3 = union {
  object { PlantLeaf rotate <170+(10*rand(ls)),216,0> }
  object { PlantLeaf rotate <170+(10*rand(ls)),288,0> }
  texture { T_Plant2Leaf }
}

#declare Plant2 = union {
  cylinder { <0,0,0>, <0,105,0>, 0.5 texture { T_Plant2Bark }}  
  object { Plant2Cluster1 scale 9.00 translate y*105 }
  object { Plant2Cluster1 scale 8.75 translate y*100 rotate y*13 }
  object { Plant2Cluster1 scale 8.50 translate y* 98 rotate y*50 }
  object { Plant2Cluster1 scale 8.00 translate y* 95 rotate y*30 }
  object { Plant2Cluster2 scale 8.00 translate y* 92 rotate y*40 }
  object { Plant2Cluster3 scale 9.00 translate y*90 }
  object { Plant2Cluster3 scale 6.00 translate y*75 rotate y*90 }
  object { Plant2Cluster2 scale 5.00 translate y*68 rotate y*10 }
  object { Plant2Cluster3 scale 8.00 translate y*55 rotate y*180 }
  object { Plant2Cluster1 scale 7.00 translate y*45 }
  object { Plant2Cluster2 scale 6.00 translate y*32 }
  object { Plant2Cluster3 scale 6.50 translate y*30 rotate y*72 }
  object { Plant2Cluster3 scale 5.00 translate y*25 rotate y*200 }
  object { Plant2Cluster3 scale 4.00 translate y*17 rotate y*300 }
  object { Plant2Cluster3 scale 3.00 translate y*8 }
}

#declare Plant3 = union {
  cylinder { <0,0,0>, <0,105,0>, 0.5 texture { T_Plant2Bark }}  
  object { Plant2Cluster2 scale 9.00 translate y*105 }
  object { Plant2Cluster1 scale 8.75 translate y*100 rotate y*13 }
  object { Plant2Cluster1 scale 8.50 translate y* 98 rotate y*50 }
  object { Plant2Cluster2 scale 8.00 translate y* 96 rotate y*40 }
  object { Plant2Cluster1 scale 8.00 translate y* 93 rotate y*30 }
  object { Plant2Cluster3 scale 9.00 translate y* 87 }
  object { Plant2Cluster1 scale 7.00 translate y* 82 }
  object { Plant2Cluster3 scale 6.00 translate y* 76 rotate y*90 }
  object { Plant2Cluster3 scale 8.00 translate y* 73 rotate y*180 }
  object { Plant2Cluster1 scale 6.00 translate y* 68 }
  object { Plant2Cluster2 scale 7.50 translate y* 65 rotate y*72 }
  object { Plant2Cluster1 scale 6.00 translate y* 61 }
  object { Plant2Cluster3 scale 6.50 translate y* 58 rotate y*72 }
  object { Plant2Cluster2 scale 5.00 translate y* 53 rotate y*10 }
  object { Plant2Cluster3 scale 5.00 translate y* 47 rotate y*200 }
  object { Plant2Cluster1 scale 4.00 translate y* 44 rotate y*300 }
  object { Plant2Cluster3 scale 3.00 translate y* 42 }
  object { Plant2Cluster2 scale 5.00 translate y* 37 rotate y*80 }
  object { Plant2Cluster1 scale 4.00 translate y* 33 rotate y*60 }
  object { Plant2Cluster3 scale 3.00 translate y* 26 }
  object { Plant2Cluster2 scale 3.00 translate y* 24 rotate y*120 }
  object { Plant2Cluster3 scale 3.00 translate y* 22 rotate y*240 }
  rotate y*72
}

#declare Plant4 = union {
  object { Plant3 bounded_by { box { <-10,0,-10>, <10,40,10> }} clipped_by { bounded_by }}
  object { Plant3 bounded_by { box { <-10,40,-10>, <10,70,10> }}
    clipped_by { bounded_by }
    translate y*-40
    matrix <1,0,0, 0,1,-0.25, 0,0,1, 0,0,0>
    translate y*40
  }
  object { Plant3 bounded_by { box { <-10,70,-10>, <10,120,10> }} clipped_by { bounded_by }
    translate z*-7.5
  }
}

#declare Plants = union {
  object { Plant1 scale 2 translate <470,1,530> }
  object { Plant2 translate <470,1,530> }
  object { Plant2 translate <437,0,285> }
  object { Plant3 scale <1,0.9,1> translate <437,0,282> }
  object { Plant4 scale 0.75 translate <437,0,275> }
  translate z*5
}


#ifndef (FullScene)
  object { Plant4 rotate y*90 }
  camera { location <0,50,-200> look_at <0,50,0> }
//  camera { location <0,75,0> look_at <0,125,1000> rotate y*25 }
  light_source { <-10000,10000,-10000> colour rgb 1 }
  light_source { <-10000,10000,0> colour rgb 1 }
  background { colour rgb <0.25,0.5,1.0> }
#end
